/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import inferno.elevator.ElevatorLevel;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ElevatorLevelPairs
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<ElevatorLevel, ElevatorLevel> lowerToUpper = new LinkedHashMap<ElevatorLevel, ElevatorLevel>();
    private final Map<ElevatorLevel, ElevatorLevel> upperToLower = new LinkedHashMap<ElevatorLevel, ElevatorLevel>();

    public void put(ElevatorLevel lowerLevel, ElevatorLevel upperLevel) {
        this.lowerToUpper.put(lowerLevel, upperLevel);
        this.upperToLower.put(upperLevel, lowerLevel);
    }

    public ElevatorLevel getLowerLevel(ElevatorLevel level) {
        return this.upperToLower.getOrDefault(level, level);
    }

    public ElevatorLevel getUpperLevel(ElevatorLevel level) {
        return this.lowerToUpper.getOrDefault(level, level);
    }

    public boolean isLowerLevel(ElevatorLevel level) {
        return this.lowerToUpper.containsKey(level);
    }

    public boolean isUpperLevel(ElevatorLevel level) {
        return this.upperToLower.containsKey(level);
    }
}

