/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.Blockage;
import inferno.data2.IIdentifiable;
import inferno.data2.SpeedModifier;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.geom.Inter;
import inferno.geom.Plane3d;
import inferno.geom.PreciseGeom;
import inferno.geom.Util;
import inferno.sim.KB;
import inferno.sim.path.PathGen;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;

public class Tri
implements Serializable,
IIdentifiable {
    static final long serialVersionUID = 1L;
    public static final int FLAG_NEAR_INVERSE_TRI = 1;
    public static final int FLAG_INVERSE_TRI = 2;
    public final int id;
    public final ANode node;
    public final Vertex[] v;
    public final Point2f[] uv;
    public transient WingedEdgeUse[] eu = new WingedEdgeUse[3];
    public transient Tri[] t = new Tri[0];
    public final double radius;
    public final Point3d center;
    public final Vector3d normal;
    public final Terrain terrain;
    public final Plane3d plane;
    public final double actualSlope;
    public int flags = 0;
    private SpeedModifier d_speedMod;
    public transient PathGen.SearchConnection[] searchConnections;
    private transient List<Blockage> d_blockages = Collections.emptyList();

    public Tri(int id, ANode node, Terrain terrain, Vertex v1, Vertex v2, Vertex v3, Point2f[] uv) {
        this.id = id;
        this.node = node;
        this.v = new Vertex[]{v1, v2, v3};
        this.uv = uv;
        this.terrain = terrain;
        this.center = this.calcCenter();
        this.radius = this.calcRadius();
        this.normal = this.calcNormal();
        this.plane = new Plane3d(v1.p, v2.p, v3.p);
        this.actualSlope = Util.getSlope(this.normal);
        this.d_speedMod = SpeedModifier.IDENTITY;
        node.addMeshElem(this);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setAdjacency(WingedEdge flap1, WingedEdge flap2, WingedEdge flap3) {
        this.eu[0] = this.getEdgeUse(flap1, 0);
        this.eu[1] = this.getEdgeUse(flap2, 1);
        this.eu[2] = this.getEdgeUse(flap3, 2);
        this.t = new Tri[]{this.adjTri(0), this.adjTri(1), this.adjTri(2)};
    }

    public void setBlockages(List<Blockage> blockages) {
        this.d_blockages = blockages;
    }

    public List<Blockage> getBlockages() {
        return this.d_blockages;
    }

    public boolean testAllFlags(int flags) {
        return (this.flags & flags) == flags;
    }

    public boolean testAnyFlags(int flags) {
        return (this.flags & flags) != 0;
    }

    private WingedEdgeUse getEdgeUse(WingedEdge flap, int ix) {
        byte dir = flap.base.n1 == this.v[ix] ? (byte)1 : -1;
        return new WingedEdgeUse(flap, dir);
    }

    private Tri adjTri(int ix) {
        WingedEdge flap = this.eu[ix].wedge;
        if (flap.isBoundary()) {
            return null;
        }
        return this == flap.t1 ? flap.t2 : flap.t1;
    }

    public void writeAdjacency(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.eu);
        oos.writeObject(this.t);
        oos.writeObject(this.searchConnections);
        oos.writeObject(this.d_blockages);
    }

    public void readAdjacency(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.eu = (WingedEdgeUse[])in.readObject();
        this.t = (Tri[])in.readObject();
        this.searchConnections = (PathGen.SearchConnection[])in.readObject();
        this.d_blockages = (List)in.readObject();
    }

    private double calcRadius() {
        double d1 = Inter.dist(this.center, this.v[0].p);
        double d2 = Inter.dist(this.center, this.v[1].p);
        double d3 = Inter.dist(this.center, this.v[2].p);
        return Math.max(d1, Math.max(d2, d3));
    }

    public boolean isPhysicallyAdjacent(Tri tri) {
        for (Tri adjTri : this.t) {
            if (adjTri != tri) continue;
            return true;
        }
        return false;
    }

    public boolean isAdjacent(Tri tri) {
        for (PathGen.SearchConnection conn : this.searchConnections) {
            if (conn.tri != tri) continue;
            return true;
        }
        return false;
    }

    private Point3d calcCenter() {
        return Util.triCenter(this.v[0].p, this.v[1].p, this.v[2].p);
    }

    private Vector3d calcNormal() {
        return Util.triNormal(this.v[0].p, this.v[1].p, this.v[2].p);
    }

    public SpeedModifier getSpeedModifier() {
        return this.d_speedMod;
    }

    public void updateSpeedModifier(KB kb) {
        SpeedModifier modifier = null;
        for (Blockage blkg : this.d_blockages) {
            if (!blkg.isActive() || modifier != null && blkg.getSpeedModifier().compareTo(modifier) >= 0) continue;
            modifier = blkg.getSpeedModifier();
        }
        if (modifier == null) {
            modifier = this.node.getSpeedModifier();
        }
        if (!this.d_speedMod.equals(modifier)) {
            boolean preBlocking = this.isBlocking();
            this.d_speedMod = modifier;
            boolean postBlocking = this.isBlocking();
            kb.markTriSpeedModifierDirty(Collections.singleton(this), preBlocking != postBlocking);
        }
    }

    public boolean isBlocking() {
        return this.d_speedMod.isBlocking();
    }

    public boolean isImpeding() {
        return this.d_speedMod.isImpeding();
    }

    public boolean isImpeding(double maxVel) {
        return this.d_speedMod.isImpeding(maxVel);
    }

    public double project2dLength(double len2d) {
        double rise = this.actualSlope * len2d;
        return Math.sqrt(len2d * len2d + rise * rise);
    }

    public double getArea() {
        return Util.triArea(this.v[0].p, this.v[1].p, this.v[2].p);
    }

    public Point3d getCenter() {
        return this.center;
    }

    public Vector3d getNormal() {
        return this.normal;
    }

    public Plane3d getPlane() {
        return this.plane;
    }

    public double getSlope(KB kb) {
        return this.node.stairData != null ? this.node.stairData.slope : 0.0;
    }

    public AABox getBoundingBox() {
        return new AABox(this.v[0].p, this.v[1].p, this.v[2].p);
    }

    public boolean hasVert(Vertex vert) {
        assert (vert != null);
        return vert == this.v[0] || vert == this.v[1] || vert == this.v[2];
    }

    public boolean containsExact(Point3d p) {
        Point3d t1 = this.v[0].p;
        Point3d t2 = this.v[1].p;
        Point3d t3 = this.v[2].p;
        return PreciseGeom.orient2d(t1.x, t1.y, t2.x, t2.y, p.x, p.y) >= 0.0 && PreciseGeom.orient2d(t2.x, t2.y, t3.x, t3.y, p.x, p.y) >= 0.0 && PreciseGeom.orient2d(t3.x, t3.y, t1.x, t1.y, p.x, p.y) >= 0.0;
    }

    public PointTest test(Point3d p, double tol) {
        boolean onEdge = false;
        for (int m = 0; m < 3; ++m) {
            double side = this.eu[m].whichSide(p, tol);
            if (side < 0.0) {
                return PointTest.OUTSIDE;
            }
            onEdge |= side == 0.0;
        }
        return onEdge ? PointTest.ON_EDGE : PointTest.INSIDE;
    }

    public String toString() {
        return "TRI[" + this.v[0].p + "," + this.v[1].p + "," + this.v[2].p + "]" + (Object)((Object)this.terrain);
    }

    public static enum Terrain {
        OPEN("level"),
        STAIR("stair"),
        RAMP("ramp");

        public final String description;

        private Terrain(String description) {
            this.description = description;
        }

        public boolean isOpen() {
            return this.equals((Object)OPEN);
        }

        public boolean isStair() {
            return this.equals((Object)STAIR);
        }

        public boolean isRamp() {
            return this.equals((Object)RAMP);
        }
    }

    public static enum PointTest {
        INSIDE(true),
        ON_EDGE(true),
        OUTSIDE(false);

        public final boolean positive;

        private PointTest(boolean positive) {
            this.positive = positive;
        }
    }
}

