/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import common.data.SpeedInSmoke;
import inferno.data2.value.IFunction1d;
import inferno.data2.value.PiecewiseFunction1d;
import java.io.Serializable;
import java.util.Objects;
import thunderheadeng.units.UnitDouble;

public class SpeedInSmokeSim
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final SpeedInSmoke.Mode mode;
    public final UnitDouble customFuncVisThreshold;
    public final SpeedInSmoke.FuncType customFuncVisType;
    public final IFunction1d customFuncVis;
    public static SpeedInSmokeSim DEFAULT = new SpeedInSmokeSim(SpeedInSmoke.Data.DEFAULT);

    public SpeedInSmokeSim(SpeedInSmoke.Mode mode, UnitDouble customFuncVisThreshold, SpeedInSmoke.FuncType customFuncVisType, IFunction1d customFuncVis) {
        this.mode = mode;
        this.customFuncVisThreshold = customFuncVisThreshold;
        this.customFuncVisType = customFuncVisType;
        this.customFuncVis = customFuncVis;
    }

    public SpeedInSmokeSim(SpeedInSmoke.Data interop) {
        this.mode = interop.mode;
        this.customFuncVisThreshold = interop.customFuncVisThreshold;
        this.customFuncVisType = interop.customFuncVisType;
        this.customFuncVis = interop.customFuncVis != null ? PiecewiseFunction1d.fromPacked(interop.customFuncVis.xyValues, interop.customFuncVis.extrapolate) : null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customFuncVis, this.customFuncVisThreshold, this.customFuncVisType, this.mode});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpeedInSmokeSim other = (SpeedInSmokeSim)obj;
        return Objects.equals(this.customFuncVis, other.customFuncVis) && Objects.equals(this.customFuncVisThreshold, other.customFuncVisThreshold) && this.customFuncVisType == other.customFuncVisType && this.mode == other.mode;
    }

    public String toString() {
        return "SpeedInSmokeSim [mode=" + (Object)((Object)this.mode) + ", customFuncVisThreshold=" + this.customFuncVisThreshold + ", customFuncVisType=" + (Object)((Object)this.customFuncVisType) + ", customFuncVis=" + this.customFuncVis + "]";
    }
}

