/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.sim.OccAgent;
import java.util.function.Predicate;

public class OccPriority {
    public static double HIGHEST = OccPriority.init(Integer.MAX_VALUE, 1.0);

    public static double init(int level, double conflictResolve) {
        if (conflictResolve == 1.0) {
            conflictResolve -= 1.0E-9;
        }
        return (double)level + conflictResolve * 0.5;
    }

    public static int compareLevels(double agg1, double agg2) {
        return OccPriority.getLevel(agg2) - OccPriority.getLevel(agg1);
    }

    public static int compare(OccAgent occ1, double agg1, Predicate<OccAgent> raisedPriorityFilter1, OccAgent occ2, double agg2, Predicate<OccAgent> raisedPriorityFilter2) {
        int level2;
        int level1 = OccPriority.getLevel(agg1);
        if (level1 == (level2 = OccPriority.getLevel(agg2))) {
            boolean lowered2;
            boolean lowered1 = OccPriority.lower(agg1) == agg1;
            boolean bl = lowered2 = OccPriority.lower(agg2) == agg2;
            if (lowered1 == lowered2) {
                return 0;
            }
            if (lowered1) {
                return raisedPriorityFilter2.test(occ1) ? 1 : 0;
            }
            return raisedPriorityFilter1.test(occ2) ? -1 : 0;
        }
        return level2 - level1;
    }

    private static <T> boolean contains(T[] vals, T val) {
        for (T v : vals) {
            if (v != val) continue;
            return true;
        }
        return false;
    }

    public static int compareStrict(double agg1, double agg2) {
        return (int)Math.signum(agg2 - agg1);
    }

    public static double raise(double agg) {
        double newVal = agg + 0.5;
        double ceil = Math.floor(agg) + 1.0;
        return newVal < ceil ? newVal : agg;
    }

    public static double lower(double agg) {
        double newVal = agg - 0.5;
        double floor = Math.floor(agg);
        return newVal >= floor ? newVal : agg;
    }

    public static int getLevel(double priority) {
        return (int)priority;
    }

    public static double getScale(double priority) {
        priority = OccPriority.lower(priority);
        return (priority - Math.floor(priority)) * 2.0;
    }

    public static boolean isLocallyHighest(double priority) {
        return OccPriority.raise(priority) == priority;
    }
}

