/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.Mesh;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.sim.DoorQueue;
import javax.vecmath.Vector3d;

public final class DoorDir
extends Enum<DoorDir> {
    public static final /* enum */ DoorDir POSITIVE = new DoorDir();
    public static final /* enum */ DoorDir NEGATIVE = new DoorDir();
    private static final /* synthetic */ DoorDir[] $VALUES;

    public static DoorDir[] values() {
        return (DoorDir[])$VALUES.clone();
    }

    public static DoorDir valueOf(String name) {
        return Enum.valueOf(DoorDir.class, name);
    }

    public DoorDir opposite() {
        switch (this) {
            case POSITIVE: {
                return NEGATIVE;
            }
            case NEGATIVE: {
                return POSITIVE;
            }
        }
        throw new IllegalArgumentException("Unknown direction.");
    }

    public static DoorDir getExitDir(ANode door) {
        assert (door.doorQueue != null);
        return DoorDir.getExitDir(door.doorQueue);
    }

    public static DoorDir getExitDir(DoorQueue dq) {
        return dq.getExitDir();
    }

    public static DoorDir get(ANode door, Tri enterTri) {
        if (!door.doorQueue.isInternal()) {
            ANode dstNode;
            ANode aNode = dstNode = enterTri != null ? enterTri.node : null;
            if (dstNode == door.doorQueue.getR1()) {
                return POSITIVE;
            }
            if (dstNode == door.doorQueue.getR2()) {
                return NEGATIVE;
            }
            assert (false);
            return POSITIVE;
        }
        for (int m = 0; m < 3; ++m) {
            WingedEdgeUse eu = enterTri.eu[m];
            if (eu.wedge.getDoorNode() != door) continue;
            return eu.dir == 1 ? POSITIVE : NEGATIVE;
        }
        assert (false);
        return POSITIVE;
    }

    public static DoorDir get(ANode door, Vector3d dir) {
        if (door.getDoorEdges().isEmpty()) {
            return POSITIVE;
        }
        if (door.getDoorEdges().size() == 1) {
            return door.getDoorEdges().get(0).getDir(dir);
        }
        double[] counts = new double[DoorDir.values().length];
        for (WingedEdge e : door.getDoorEdges()) {
            DoorDir d = e.getDir(dir);
            int n = d.ordinal();
            counts[n] = counts[n] + Mesh.length2d(e);
        }
        double maxCount = counts[0];
        int ix = 0;
        for (int m = 1; m < counts.length; ++m) {
            if (!(counts[m] > maxCount)) continue;
            maxCount = counts[m];
            ix = m;
        }
        return DoorDir.values()[ix];
    }

    public static ANode getSource(ANode door, DoorDir dir) {
        assert (door != null);
        assert (door.isDoor());
        if (door.doorQueue != null) {
            return door.doorQueue.src(dir);
        }
        WingedEdge we = door.getDoorEdges().get(0);
        return POSITIVE == dir ? we.t2.node : we.t1.node;
    }

    public static ANode getDest(ANode door, DoorDir dir) {
        assert (door != null);
        assert (door.isDoor());
        if (door.doorQueue != null) {
            return door.doorQueue.dest(dir);
        }
        WingedEdge we = door.getDoorEdges().get(0);
        return POSITIVE == dir ? we.t1.node : we.t2.node;
    }

    static {
        $VALUES = new DoorDir[]{POSITIVE, NEGATIVE};
    }
}

