/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.IAnimSrc;
import inferno.data2.Material;
import inferno.data2.Mesh;
import inferno.data2.SpeedModifier;
import inferno.data2.Tri;
import inferno.sim.KB;
import java.io.Serializable;
import javax.vecmath.Color4f;

public class Blockage
implements Serializable,
IAnimSrc {
    static final long serialVersionUID = 1L;
    public final int id;
    public final String name;
    public final long resultsId;
    public final DisplayType displayType;
    public final int[] tris;
    public final long cadGeomId;
    public final Material material;
    public final Color4f color;
    private boolean d_active;
    private SpeedModifier d_speedMod;

    public Blockage(int id, String name, long resultsId, int[] triIds, DisplayType displayType, Material material, Color4f color, long cadGeomId) {
        this.id = id;
        this.name = name;
        this.resultsId = resultsId;
        this.tris = triIds;
        this.displayType = displayType;
        this.material = material;
        this.color = color;
        this.cadGeomId = cadGeomId;
        this.d_speedMod = SpeedModifier.IDENTITY;
        this.d_active = false;
    }

    public SpeedModifier getSpeedModifier() {
        return this.d_speedMod;
    }

    public void setSpeedModifier(KB kb, Mesh m, SpeedModifier smod) {
        if (this.d_speedMod.equals(smod = smod.clampToCutoff())) {
            return;
        }
        this.d_speedMod = smod;
        if (this.d_active) {
            this.updateTris(kb, m);
        }
    }

    public boolean isImpeding() {
        return this.isActive() && this.d_speedMod.isImpeding();
    }

    public void setActive(KB kb, Mesh mesh, boolean active) {
        if (this.d_active == active) {
            return;
        }
        this.d_active = active;
        this.updateTris(kb, mesh);
    }

    private void updateTris(KB kb, Mesh m) {
        for (int id : this.tris) {
            Tri t = m.getTris()[id];
            t.updateSpeedModifier(kb);
        }
    }

    public boolean isActive() {
        return this.d_active;
    }

    public static enum DisplayType {
        NONE("none"),
        SIMPLE("simple"),
        CAD_GEOM("cad");

        public final String name;

        private DisplayType(String name) {
            this.name = name;
        }
    }
}

