/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.Occupant;
import inferno.data2.TriPoint;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import java.io.Serializable;
import java.util.Set;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.util.Filters;

public class AttractorSim
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int id;
    public final String name;
    public final TriPoint location;
    public final double influenceRadius;
    public BehaviorSim behavior;
    public final Awareness awareness;
    public final Set<ANode> rooms;
    private double d_influence;

    public AttractorSim(int id, String name, BehaviorSim behavior, Awareness awareness, TriPoint location, double influenceRadius, double initInfluence, Set<ANode> rooms) {
        this.id = id;
        this.name = name;
        this.location = location;
        this.behavior = behavior;
        this.awareness = awareness;
        this.influenceRadius = influenceRadius;
        this.rooms = rooms;
        this.d_influence = initInfluence;
    }

    public AABox getBounds() {
        return new BoundingSphere(this.location.p, this.influenceRadius).toAABox();
    }

    public double getInfluence() {
        return this.d_influence;
    }

    public void setInfluence(double influence) {
        this.d_influence = influence;
    }

    public double getProbabilityOfInfluence(Occupant occ, boolean idle) {
        return this.d_influence * occ.getAttractorSusceptibility(idle, this);
    }

    public boolean isVisible(KB kb, Occupant occ) {
        switch (this.awareness) {
            case ROOM_ONLY: {
                return occ.curNode == this.location.tri.node;
            }
            case LINE_OF_SIGHT: {
                return occ.loc.distanceSquared(this.location.p) <= this.influenceRadius * this.influenceRadius && !kb.getMesh().isPathObstructed(occ.tri, occ.loc, this.location.tri, this.location.p, 0.0, Filters.acceptAll());
            }
            case GLOBAL: {
                return true;
            }
            case ROOMS: {
                return this.rooms.contains(occ.curNode);
            }
        }
        assert (false);
        return false;
    }

    public String toString() {
        return this.name;
    }

    public static enum Awareness {
        LINE_OF_SIGHT,
        ROOM_ONLY,
        ROOMS,
        GLOBAL;

    }
}

