/*
 * Decompiled with CFR 0.152.
 */
package fpserver;

import fpserver.Api;
import fpserver.IPacket;
import fpserver.IServer;
import fpserver.Prob;
import inferno.data2.Occupant;
import inferno.sim.Engine;
import inferno.sim.EngineOp;
import inferno.sim.OccAgent;
import inferno.sim.ai.AiUtil;
import inferno.sim.ai.IAiCore;
import inferno.sim.ai.ReqAssistedByAiCore;
import inferno.sim.ai.SevereInjuryAiCore;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import thunderheadeng.util.Pair;

public class SetAi {
    private static Map<SetAiArg, Object> getDefaultArgs() {
        HashMap<SetAiArg, Object> props = new HashMap<SetAiArg, Object>();
        for (SetAiArg prop : SetAiArg.values()) {
            if (prop.defVal == null) continue;
            props.put(prop, prop.defVal);
        }
        return props;
    }

    public static Map<SetAiArg, Object> procArgs(List<String> args) throws Api.ApiException {
        int m;
        Map<SetAiArg, Object> argMap = SetAi.getDefaultArgs();
        try {
            for (m = 0; m < args.size(); ++m) {
                String arg = args.get(m);
                if (arg.equalsIgnoreCase(SetAiArg.NAME.argSwitch)) {
                    argMap.put(SetAiArg.NAME, args.get(++m));
                    continue;
                }
                if (arg.equalsIgnoreCase(SetAiArg.ROOM.argSwitch)) {
                    argMap.put(SetAiArg.ROOM, args.get(++m));
                    continue;
                }
                if (!arg.equalsIgnoreCase(SetAiArg.ID.argSwitch)) continue;
                Integer id = null;
                try {
                    id = Integer.parseInt(args.get(++m));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (id == null) continue;
                argMap.put(SetAiArg.ID, id);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new Api.ApiException(String.format("Missing argument after %s%n", args.get(m - 1)));
        }
        return argMap;
    }

    public static int setAiCore(Engine e, Function<OccAgent, ? extends IAiCore> newAiCore, String nameFilter, Integer idFilter, String roomFilter) {
        ArrayList<OccAgent> affectedAgents = new ArrayList<OccAgent>();
        for (OccAgent agent : e.getKB().getActiveAgents()) {
            Occupant occ = agent.getOcc();
            if (idFilter != null && !idFilter.equals(occ.id) || nameFilter != null && !nameFilter.equals(occ.name) || roomFilter != null && !roomFilter.equals(agent.getLoc().tri.node.name) || agent.isControlled()) continue;
            affectedAgents.add(agent);
        }
        e.pushOp(new EngineOp.SetAi(newAiCore, affectedAgents));
        return affectedAgents.size();
    }

    public static class Operation
    implements Api.IOperation<Integer> {
        private long d_tbegin;

        @Override
        public Integer getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return -1;
        }

        @Override
        public Integer performOp(Api api, IServer server, IPacket recvPacket, List<String> rawArgs, Prob prob) throws Api.ApiException {
            this.d_tbegin = System.nanoTime();
            Map<SetAiArg, Object> args = SetAi.procArgs(rawArgs);
            Function<OccAgent, IAiCore> newAiCore = null;
            String selector = rawArgs.remove(0);
            if (selector.equalsIgnoreCase("default")) {
                newAiCore = AiUtil::newCore;
            } else if (selector.equalsIgnoreCase("assisted")) {
                newAiCore = agent -> new ReqAssistedByAiCore();
            } else if (selector.equalsIgnoreCase("severe")) {
                newAiCore = agent -> new SevereInjuryAiCore();
            } else {
                throw new Api.ApiException(String.format("Unknown selector: %s%n", selector));
            }
            return SetAi.setAiCore(prob.getEngine(), newAiCore, (String)args.get((Object)SetAiArg.NAME), (Integer)args.get((Object)SetAiArg.ID), (String)args.get((Object)SetAiArg.ROOM));
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, Integer response, OutputStream out) throws IOException {
            DataOutputStream strmBin = new DataOutputStream(out);
            strmBin.writeInt(response);
            strmBin.flush();
            double ms = (double)(System.nanoTime() - this.d_tbegin) / 1000000.0;
            return new Pair<Integer, String>(0, String.format("set_ai completed in %.3f ms", ms));
        }
    }

    public static enum SetAiArg {
        NAME("-name", null),
        ID("-id", null),
        ROOM("-room", null);

        public final String argSwitch;
        public final Object defVal;

        private SetAiArg(String argSwitch, Object defVal) {
            this.argSwitch = argSwitch;
            this.defVal = defVal;
        }
    }
}

