@echo off

:: This batch file creates variations of a Pathfinder model.
:: Usage is:
::
::		montecarlo_createcases.bat myModel.pth 20
::
:: Where model.pth is the name of the pathfinder model PTH file
:: and twenty is the number of cases to generate. Variations will
:: be placed into a new sub-folder where the PTH file is stored.
::
:: Additional filtering options are available with the format 
:: -include=Foo\Bar -exclude_pos=Baz
::
:: If this script is not located in a Pathfinder install folder,
:: you will likely need to edit JRE_ROOT.

SET ROOT=%~dp0
SET ROOT=%ROOT:~0,-1%

SET JVM_ARGS=
SET JVM_ARGS=%JVM_ARGS% -cp "%ROOT%\pathfinder.jar"
SET JVM_ARGS=%JVM_ARGS% -Djava.library.path="%ROOT%;%ROOT%\lib;%ROOT%\lib\rlm;%ROOT%\lib\vtk-6.3.0"
SET JVM_ARGS=%JVM_ARGS% -Dpicocli.ansi=true

"%ROOT%\jre\bin\java.exe" %JVM_ARGS%  montecarlo.Run %*