/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.mv;

import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jscience.physics.units.SI;
import results.Intl;
import results.api.Events;
import results.api.UnitType;
import results.nativebuffered.Geometry;
import results.nativebuffered.mv.ResultsSceneView;
import results.nativebuffered.session.Session;
import results.nativebuffered.session.SessionMediator;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiToolBar;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IBindable;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Pair;
import thunderheadeng.util.RWProp;

public class MVViewProps
implements IEventObserver,
IBindable {
    private static final double FLOOR_ANIMATE_TIME = 1.3;
    private final SessionMediator d_mediator;
    private final guiComboBox<ViewMode> d_viewCombo;
    private final ValueField<UnitDouble> d_wallHeightFld;
    private final ValueField<UnitDouble> d_floorSepFld;

    public MVViewProps(SessionMediator mediator, ResultsSceneView sceneView) {
        this.d_mediator = mediator;
        guiComboBox<ViewMode> cb = new guiComboBox<ViewMode>((Collection<ViewMode>)Arrays.asList(ViewMode.values()));
        cb.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 4628717168143122938L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                ViewMode mode = (ViewMode)((Object)value);
                this.setText(mode.desc);
                this.setIcon(mode.icon);
                return this;
            }
        });
        cb.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            ViewMode mode = (ViewMode)((Object)((Object)cb.getSelectedItem()));
            mode.apply(this.d_mediator.getSession());
        });
        cb.setMaximumSize(cb.getPreferredSize());
        this.d_viewCombo = cb;
        Function<RWProp, ValueField> newField = prop -> {
            ValueField<UnitDouble> fld = ValueFields.udFld(mediator.getUnit(UnitType.LENGTH), UnitDoubleVR.above(0.0, SI.METER, true));
            fld.setColumns(8);
            fld.setMaximumSize(fld.getPreferredSize());
            fld.addValueCommitListener(e -> {
                UnitDouble udval = (UnitDouble)fld.getValue();
                Double dval = udval == null ? 3.4028234663852886E38 : udval.get(Geometry.LU);
                this.d_mediator.getSession().set(prop, dval);
                SwingUtilities.invokeLater(fld::selectAll);
            });
            return fld;
        };
        this.d_wallHeightFld = newField.apply(Session.WALL_HEIGHT);
        this.d_wallHeightFld.setNullAllowed(true);
        ValueFields.getFormat(this.d_wallHeightFld).alias(null, Intl.intl("<full>"));
        this.d_floorSepFld = newField.apply(Session.FLOOR_SEP);
        this.d_floorSepFld.addValueCommitListener(e -> sceneView.animateFloors(1.3));
        this.sync();
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    @Override
    public void connect() {
        this.d_mediator.getEvents().addObserver(this);
    }

    @Override
    public void disconnect() {
        this.d_mediator.getEvents().removeObserver(this);
    }

    private void sync() {
        this.syncViewMode();
        this.syncFloorSettings();
    }

    private void syncViewMode() {
        IListenerStripper listeners = guiUtil.stripListeners(this.d_viewCombo);
        ViewMode mode = ViewMode.find(this.d_mediator.getSession());
        if (mode != null) {
            this.d_viewCombo.setSelectedItem((Object)mode);
        }
        listeners.restore();
    }

    private void syncFloorSettings() {
        BiConsumer<ValueField, RWProp> sync = (f, prop) -> {
            IListenerStripper listeners = guiUtil.stripListeners(f::addValueCommitListener, f::getValueCommitListeners, f::removeValueCommitListener);
            double dval = (Double)this.d_mediator.getSession().get(prop);
            UnitDouble udval = f == this.d_wallHeightFld && dval == 3.4028234663852886E38 ? null : new UnitDouble(dval, Geometry.LU);
            f.setValue(udval);
            listeners.restore();
        };
        sync.accept(this.d_wallHeightFld, Session.WALL_HEIGHT);
        sync.accept(this.d_floorSepFld, Session.FLOOR_SEP);
    }

    public guiToolBar createViewPropsToolBar() {
        guiToolBar tb = new guiToolBar();
        tb.add(new guiLabel(Intl.intl("View Mode:")));
        tb.addSpace(6);
        tb.add(this.d_viewCombo);
        return tb;
    }

    public guiToolBar createFloorSettingsToolBar() {
        guiToolBar tb = new guiToolBar();
        tb.add(new guiLabel(Intl.intl("Floor Separation:")));
        tb.addSpace(6);
        tb.add(this.d_floorSepFld);
        tb.addSpace(6);
        tb.add(new guiLabel(Intl.intl("Wall Height:")));
        tb.addSpace(6);
        tb.add(this.d_wallHeightFld);
        return tb;
    }

    @Override
    public void update(thunderheadeng.util.Events events) {
        Session session;
        IEventRecord<Session> sevts = events.getEvents(Session.class, new Class[0]);
        if (sevts.isChanged(session = this.d_mediator.getSession(), (Object)Events.PATHFINDER_RESULTS_ATTACHED) || sevts.isChanged(session, (Object)Events.PATHFINDER_RESULTS_DETACHED)) {
            this.sync();
        } else if (sevts.isChanged(session, Session.DRAW_MATERIALS) || sevts.isChanged(session, Session.DRAW_OUTLINES) || sevts.isChanged(session, Session.DRAW_WIREFRAME)) {
            this.syncViewMode();
        } else if (sevts.isChanged(session, Session.FLOOR_SEP) || sevts.isChanged(session, Session.WALL_HEIGHT)) {
            this.syncFloorSettings();
        }
    }

    private static enum ViewMode {
        MATERIALS(Intl.intl("Textured"), "merlin/icons/textures.png", ViewMode.options(false, false, true)),
        MATERIALS_OUTLINE(Intl.intl("Textured+Outlines"), "merlin/icons/textures.png", ViewMode.options(false, true, true)),
        NO_MATERIALS(Intl.intl("Colors Only"), "merlin/icons/shaded.png", ViewMode.options(false, false, false)),
        NO_MATERIALS_OUTLINE(Intl.intl("Colors+Outlines"), "merlin/icons/shaded.png", ViewMode.options(false, true, false)),
        WIREFRAME(Intl.intl("Wireframe"), "merlin/icons/wireframe.png", ViewMode.options(true, false, false));

        public final String desc;
        public final Icon icon;
        public final Consumer<Session> apply;
        public final Predicate<Session> find;

        private ViewMode(String desc, String iconLoc, Pair<Consumer<Session>, Predicate<Session>> options) {
            this(desc, guiUtil.loadIcon(iconLoc), options);
        }

        private ViewMode(String desc, Icon icon, Pair<Consumer<Session>, Predicate<Session>> options) {
            this.desc = desc;
            this.icon = icon;
            this.apply = (Consumer)options.v1;
            this.find = (Predicate)options.v2;
        }

        public void apply(Session session) {
            this.apply.accept(session);
        }

        public static ViewMode find(Session session) {
            for (ViewMode mode : ViewMode.values()) {
                if (!mode.find.test(session)) continue;
                return mode;
            }
            return null;
        }

        private static Pair<Consumer<Session>, Predicate<Session>> options(boolean wireframe, boolean outlines, boolean materials) {
            Consumer<Session> apply = o -> {
                o.set(Session.DRAW_WIREFRAME, wireframe);
                o.set(Session.DRAW_MATERIALS, materials);
                o.set(Session.DRAW_OUTLINES, outlines);
            };
            Predicate<Session> test = s -> s.get(Session.DRAW_MATERIALS) == materials && s.get(Session.DRAW_OUTLINES) == outlines && s.get(Session.DRAW_WIREFRAME) == wireframe;
            return new Pair<Consumer<Session>, Predicate<Session>>(apply, test);
        }
    }
}

