/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools.queues;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.vecmath.Point3d;
import merlin.MerlinApp;
import merlin.builders.queues.QueueServiceBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.mv.ModelView;
import merlin.mv.tools.queues.QueueElementTool;
import results.nativebuffered.Geometry;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.units.UnitPoint3D;

public class QueueServiceTool
extends QueueElementTool<QueueServiceBuilder> {
    private boolean d_p0Set = false;

    public QueueServiceTool(ModelView mv) {
        super(mv, (IToolFunction<? extends CursorTool>)new Func());
        this.resetSnap();
    }

    private void resetSnap() {
        this.setSnapInfo(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(IEgressOccupiable.class, GeomType.FACE));
    }

    private void setSnapToAny() {
        this.setSnapInfo(SnapMode.ANY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocation() {
        Point3d p1 = this.getP1().referenceSnap;
        Point3d p2 = this.getView().screenToWorld(this.getP1().referenceSnapSc, 1.0);
        GeomUtil.FindResult room = null;
        MerlinData md = MerlinApp.getApp().getData();
        md.beginRead();
        try {
            room = GeomUtil.findRoom(MerlinApp.getApp().getData(), p1, p2, 0);
        }
        finally {
            md.endRead();
        }
        if (room != null) {
            ((QueueServiceBuilder)this.props()).setDestination(new UnitPoint3D(room.p, Geometry.LU), room.room, room.faceNormal);
            this.d_p0Set = true;
        } else {
            ((QueueServiceBuilder)this.props()).setDestination(new UnitPoint3D(p1, Geometry.LU), null, GeomConstants.VEC3D_ZPOS);
        }
    }

    private static class Func
    extends AToolFunction<QueueServiceTool> {
        private Func() {
        }

        @Override
        public Cursor getCursor(QueueServiceTool tool) {
            return null;
        }

        @Override
        public void mousePressed(QueueServiceTool tool, MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            tool.updateLocation();
            tool.setSnapToAny();
        }

        @Override
        public void mouseReleased(QueueServiceTool tool, MouseEvent e) {
            if (e.getButton() == 3) {
                tool.cancel();
                return;
            }
            if (!tool.d_p0Set || e.getButton() != 1) {
                return;
            }
            if (((QueueServiceBuilder)tool.props()).isValid()) {
                ((QueueServiceBuilder)tool.props()).commit(e.getComponent());
                tool.finish();
            }
            tool.d_p0Set = false;
            tool.resetSnap();
        }

        @Override
        public void mouseDragged(QueueServiceTool tool, MouseEvent e) {
        }

        @Override
        public void mouseMoved(QueueServiceTool tool, MouseEvent e) {
            tool.updateLocation();
        }
    }
}

