/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Observable;
import javax.vecmath.Point3d;
import merlin.geom.Geometry;
import merlin.manip.TranslateManip;
import merlin.mv.ModelView;
import merlin.mv.tools.ATransformTool;
import thunderheadeng.scene3d.nativebuffered.GenericActor;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.units.UnitPoint3D;

public class TranslateTool
extends ATransformTool<TranslateManip> {
    private UnitPoint3D d_p1;
    private UnitPoint3D d_p2;
    private boolean d_p1Committed;
    private boolean d_p2Committed;
    private final TranslateDisp d_disp = new TranslateDisp();

    public TranslateTool(ModelView mv) {
        super(mv, new Func());
    }

    public IDisplayable getDisplay() {
        return this.d_disp;
    }

    @Override
    public void update(Observable o, Object arg) {
        UnitPoint3D moveVec;
        if (((TranslateManip)this.props()).aPropChanged(TranslateManip.TRANSFORM_CHANGED) && this.d_p1Committed && (moveVec = ((TranslateManip)this.props()).getMoveVec()) != null) {
            UnitPoint3D p2 = this.d_p1.add(moveVec);
            this.setP2(p2, this.d_p2Committed);
        }
        super.update(o, arg);
    }

    @Override
    public void reset() {
        this.d_p2 = null;
        this.d_p1 = null;
        this.d_p2Committed = false;
        this.d_p1Committed = false;
        this.d_disp.update();
    }

    private void setP1(UnitPoint3D base, boolean commit) {
        this.d_p1 = base;
        this.d_p1Committed = commit;
        this.d_disp.update();
    }

    private void setP2(UnitPoint3D base, boolean commit) {
        this.d_p2 = base;
        this.d_p2Committed = commit;
        UnitPoint3D move = this.d_p2.sub(this.d_p1);
        ((TranslateManip)this.props()).setMoveVec(move);
        this.d_disp.update();
    }

    protected static class Func
    extends ATransformTool.Func<TranslateManip, TranslateTool> {
        protected Func() {
        }

        @Override
        public void mouseExited(TranslateTool tool, MouseEvent e) {
            if (!tool.d_p1Committed) {
                tool.setP1(null, false);
            }
        }

        @Override
        public void mouseMoved(TranslateTool tool, MouseEvent e) {
            if (!tool.d_p1Committed) {
                tool.setP1(tool.getFirstPoint(false), false);
            } else {
                UnitPoint3D nextPoint = tool.getNextPoint(tool.d_p1, tool.getP1().referenceSnap, tool.getP1().isSnapped());
                tool.setP2(nextPoint, false);
            }
        }

        @Override
        public void mousePressed(TranslateTool tool, MouseEvent e) {
            if (e.getButton() == 1) {
                if (!tool.d_p1Committed) {
                    tool.setP1(tool.getFirstPoint(true), true);
                } else {
                    UnitPoint3D nextPoint = tool.getNextPoint(tool.d_p1, tool.getP0().referenceSnap, tool.getP0().isSnapped());
                    tool.setP2(nextPoint, true);
                }
            }
        }

        @Override
        public void mouseReleased(TranslateTool tool, MouseEvent e) {
            int pressedButton = e.getButton();
            if (pressedButton == 1) {
                ((TranslateManip)tool.props()).pause();
                if (tool.dragAboveTolerance(0)) {
                    UnitPoint3D nextPoint = tool.getNextPoint(tool.d_p1, tool.getP1().referenceSnap, tool.getP1().isSnapped());
                    tool.setP2(nextPoint, true);
                }
                if (((TranslateManip)tool.props()).canTransform()) {
                    ((TranslateManip)tool.props()).transform(e.getComponent());
                }
                ((TranslateManip)tool.props()).resume();
            }
        }
    }

    public class TranslateDisp
    extends GenericActor {
        private static final long serialVersionUID = -4908039094195248434L;

        public TranslateDisp() {
            this.setPointSize(10.0);
            this.setLineWidth(2.0);
        }

        public void update() {
            this.resetData();
            if (TranslateTool.this.d_p1 != null) {
                Point3d p1 = TranslateTool.this.d_p1.getPoint3dValue(Geometry.LENGTH_UNIT);
                this.addPoint(p1, Color.RED);
                if (TranslateTool.this.d_p2 != null) {
                    this.addLine(p1, TranslateTool.this.d_p2.getPoint3dValue(Geometry.LENGTH_UNIT), Color.RED);
                }
            }
            this.finalizeData();
            TranslateTool.this.repaintSurface();
        }
    }
}

