/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.util.Arrays;
import java.util.Observable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import merlin.geom.Geometry;
import merlin.manip.RotateManip;
import merlin.manip.TranslateManip;
import merlin.mv.ModelView;
import merlin.mv.tools.ATransformTool;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.GenericActor;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.theUtil;

public class RotateTool
extends ATransformTool<RotateManip> {
    private final RotateDisp d_display = new RotateDisp();
    private static final int STEP_SETBASE = 0;
    private static final int STEP_SETANGLEBASE = 1;
    private static final int STEP_SETANGLE = 2;
    private static final int STEP_TRANSFORM = 3;
    private Vector3d d_angleBase = null;
    private int d_step = 0;
    private boolean d_angleBaseCommitted = false;
    private boolean d_baseCommitted = false;
    private boolean d_angleCommitted = false;

    public RotateTool(ModelView mv) {
        super(mv, new Func());
    }

    public IDisplayable getDisplay() {
        return this.d_display;
    }

    @Override
    public void activate() {
        super.activate();
        Camera cam = this.getView().getCamera();
        Vector3d axis = cam.getViewVector();
        axis.negate();
        axis.normalize();
        ((RotateManip)this.props()).setRotateAxis(axis);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (((RotateManip)this.props()).aPropChanged(TranslateManip.TRANSFORM_CHANGED)) {
            this.d_display.update();
        }
        super.update(o, arg);
    }

    @Override
    public void reset() {
        this.d_angleBase = null;
        this.d_angleCommitted = false;
        this.d_baseCommitted = false;
        this.d_angleBaseCommitted = false;
        this.d_step = 0;
        this.d_display.update();
    }

    private void setBase(UnitPoint3D base, boolean commit) {
        this.d_baseCommitted = base != null && commit;
        int n = this.d_step = base != null ? 1 : 0;
        if (base == null) {
            ((RotateManip)this.props()).setBaseToCenter();
        } else {
            ((RotateManip)this.props()).setBase(base);
        }
    }

    private void setAngleBase(Vector3d angleBase, boolean commit) {
        this.d_angleBase = angleBase;
        this.d_angleBaseCommitted = commit && angleBase != null;
        this.d_step = this.d_angleBase != null ? 2 : 1;
        this.d_display.update();
    }

    private void setAngle(UnitDouble angle, boolean commit) {
        this.d_angleCommitted = angle != null && commit;
        int n = this.d_step = angle == null ? 2 : 3;
        if (angle == null) {
            angle = new UnitDouble(0.0, NonSI.DEGREE_ANGLE);
        }
        ((RotateManip)this.props()).setAngle(angle);
    }

    private Vector3d getAngleBase(UnitPoint3D p1, Point3d p2) {
        Vector3d axis = ((RotateManip)this.props()).getAxis();
        Point3d p1a = p1.getPoint3dValue(Geometry.LENGTH_UNIT);
        Plane3d plane = new Plane3d(axis, p1a);
        CursorTool.Ray pickRay = this.getPickRay(p2);
        Point3d isect = Inter3D.linePlaneIntersection(pickRay.begin, pickRay.dir, plane, 1.0E-6);
        if (isect == null || p1a.epsilonEquals(isect, 1.0E-6)) {
            return null;
        }
        return Util3D.vectorN(p1a, isect);
    }

    private void updateAngleBase(boolean commit) {
        this.setAngleBase(this.getAngleBase(((RotateManip)this.props()).getBase(), this.getP1().referenceSnap), commit);
    }

    private UnitDouble getAngle(UnitPoint3D p1, Point3d p2) {
        Vector3d axis = ((RotateManip)this.props()).getAxis();
        Vector3d angleBase = this.d_angleBase;
        Point3d p1a = p1.getPoint3dValue(Geometry.LENGTH_UNIT);
        Plane3d plane = new Plane3d(axis, p1a);
        CursorTool.Ray pickRay = this.getPickRay(p2);
        Point3d isect = Inter3D.linePlaneIntersection(pickRay.begin, pickRay.dir, plane, 1.0E-6);
        if (isect == null || p1a.epsilonEquals(isect, 1.0E-6)) {
            return null;
        }
        double angle = Util3D.angle(angleBase, Util3D.vectorN(p1a, isect), axis);
        return new UnitDouble(angle, SI.RADIAN);
    }

    private void updateAngle(boolean commit) {
        UnitDouble angle = this.getAngle(((RotateManip)this.props()).getBase(), this.getP1().referenceSnap);
        this.setAngle(angle, commit);
    }

    protected static class Func
    extends ATransformTool.Func<RotateManip, RotateTool> {
        protected Func() {
        }

        @Override
        public void mouseExited(RotateTool tool, MouseEvent e) {
            if (!tool.d_baseCommitted) {
                tool.setBase(null, false);
            }
        }

        @Override
        public void mouseMoved(RotateTool tool, MouseEvent e) {
            if (!tool.d_baseCommitted) {
                tool.setBase(tool.getFirstPoint(false), false);
            } else if (!tool.d_angleBaseCommitted) {
                tool.updateAngleBase(false);
            } else {
                tool.updateAngle(tool.d_angleCommitted);
            }
        }

        @Override
        public void mousePressed(RotateTool tool, MouseEvent e) {
            if (e.getButton() == 1) {
                if (!tool.d_baseCommitted) {
                    tool.setBase(tool.getFirstPoint(true), true);
                } else if (!tool.d_angleBaseCommitted) {
                    tool.setAngleBase(tool.getAngleBase(((RotateManip)tool.props()).getBase(), tool.getP0().referenceSnap), true);
                } else {
                    UnitDouble angle = tool.getAngle(((RotateManip)tool.props()).getBase(), tool.getP0().referenceSnap);
                    tool.setAngle(angle, true);
                }
            }
        }

        @Override
        public void mouseReleased(RotateTool tool, MouseEvent e) {
            int pressedButton = e.getButton();
            if (pressedButton == 1) {
                ((RotateManip)tool.props()).pause();
                if (tool.d_baseCommitted && !tool.d_angleBaseCommitted && tool.dragAboveTolerance(0)) {
                    tool.updateAngleBase(true);
                }
                if (((RotateManip)tool.props()).canTransform()) {
                    ((RotateManip)tool.props()).transform(e.getComponent());
                }
                ((RotateManip)tool.props()).resume();
            }
        }
    }

    public class RotateDisp
    extends GenericActor {
        private static final long serialVersionUID = -2577306930324410585L;

        public RotateDisp() {
            this.setPointSize(10.0);
            this.setLineWidth(2.0);
        }

        private Point3d getInfP2(Point3d p1, Vector3d dir) {
            View v = RotateTool.this.getView();
            Box3d frustum = v.getFrustum();
            for (Point3d[] face : frustum.getFaces()) {
                Point3d isect;
                double t;
                Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(face), true);
                if (plane == null || Double.isNaN(t = Inter3D.linePlaneIntersectionT(p1, dir, plane, 1.0E-6)) || theUtil.le0(t, 1.0E-6) || !Inter3D.pointInPoly(1.0E-6, isect = Util3D.linePoint(p1, dir, t), face)) continue;
                return isect;
            }
            Vector3d dirn = Util3D.normalize(dir);
            dirn.scale(1.0E20);
            return Util3D.add(p1, (Tuple3d)dirn);
        }

        public void update() {
            this.resetData();
            if (RotateTool.this.d_step > 0) {
                Point3d base = ((RotateManip)RotateTool.this.props()).getBase().getPoint3dValue(Geometry.LENGTH_UNIT);
                this.addPoint(base, Color.RED);
                if (RotateTool.this.d_step > 1) {
                    Vector3d dir = new Vector3d(RotateTool.this.d_angleBase);
                    dir.normalize();
                    Point3d p2 = this.getInfP2(base, dir);
                    this.addLine(base, p2, Color.RED);
                    if (RotateTool.this.d_step > 2) {
                        Vector3d axis = ((RotateManip)RotateTool.this.props()).getAxis();
                        assert (axis != null);
                        double angle = ((RotateManip)RotateTool.this.props()).getAngle().getValue(Geometry.ANGLE_UNIT);
                        AxisAngle4d aa = new AxisAngle4d(axis, angle);
                        Matrix4d mat = new Matrix4d();
                        mat.set(aa);
                        mat.transform(dir);
                        p2 = this.getInfP2(base, dir);
                        this.addLine(base, p2, Color.GREEN);
                        double angleRadius = 1.0;
                        View view = RotateTool.this.getView();
                        angleRadius = view.screenToWorld(25.0, base);
                        Vector3d localX = RotateTool.this.d_angleBase;
                        Vector3d localZ = ((RotateManip)RotateTool.this.props()).getAxis();
                        Vector3d localY = Util3D.cross(localZ, localX);
                        Matrix4d xform = Util.translateMat(base.x, base.y, base.z);
                        Matrix4d arcXform = new Matrix4d(localX.x, localY.x, localZ.x, 0.0, localX.y, localY.y, localZ.y, 0.0, localX.z, localY.z, localZ.z, 0.0, 0.0, 0.0, 0.0, 1.0);
                        xform.mul(arcXform);
                        Arc2D.Double arc = ShapeUtil.newCircularArc(0.0, 0.0, angleRadius, 0.0, angle, angle >= 0.0);
                        ShapeGeom geom = new ShapeGeom((Shape)arc, xform);
                        for (LineSeg seg : GeomUtil.convertToLineSegs(0.1, geom)) {
                            this.addLine(seg.p1, seg.p2, Color.BLUE);
                        }
                    }
                }
            }
            this.finalizeData();
            RotateTool.this.repaintSurface();
        }
    }
}

