/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.event.KeyEvent;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.builders.WallSubBuilder;
import merlin.mv.ModelView;
import merlin.mv.tools.ANewTwoPointTool;

public class NewWallSubTool
extends ANewTwoPointTool<WallSubBuilder> {
    public NewWallSubTool(ModelView mv) {
        super(mv);
    }

    @Override
    protected int getTolMode() {
        return 0;
    }

    @Override
    protected String getShapeName() {
        return Intl.intl("Wall");
    }

    @Override
    protected String getOnePointMessage(Point3d p1) {
        return String.format(Intl.intl("Wall - First point: %s"), this.toString(p1));
    }

    @Override
    protected String getTwoPointMessage(Point3d p1, Point3d p2) {
        double width = p2.distance(p1);
        return String.format(Intl.intl("Wall - Second point: %s - length=%s"), this.toString(p2), this.toString(width));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.pauseRepaint();
        super.keyPressed(e);
        if (e.getKeyCode() == 16) {
            ((WallSubBuilder)this.props()).setWidth(-Math.abs(((WallSubBuilder)this.props()).getWidth()));
        }
        this.resumeRepaint(true);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.pauseRepaint();
        super.keyReleased(e);
        if (e.getKeyCode() == 16) {
            ((WallSubBuilder)this.props()).setWidth(Math.abs(((WallSubBuilder)this.props()).getWidth()));
        }
        this.resumeRepaint(true);
    }
}

