/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import merlin.builders.CorridorBuilder;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.mv.ModelView;
import merlin.mv.displays.GeomDispMgr;
import merlin.mv.tools.MerlinTool;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IsectInfo;

public class NewCorrTool1Pt<T extends CorridorBuilder>
extends MerlinTool<T> {
    private GeomDispMgr.Display d_lastDisplay = null;

    public NewCorrTool1Pt(ModelView mv) {
        super(mv, new Func());
        this.setSnapInfo(SnapMode.FILTERED_TWO_PASS, new SnapFilter());
    }

    @Override
    public void activate() {
        super.activate();
    }

    @Override
    public void deactivate() {
        this.pauseRepaint();
        this.removeLastDisplay();
        super.deactivate();
        this.resumeRepaint();
    }

    @Override
    protected void propsChanged(T props, Object arg) {
        if (((CorridorBuilder)this.props()).aPropChanged(CorridorBuilder.COMPLETED)) {
            this.finish();
            return;
        }
        this.updateDisplay();
    }

    @Override
    public void cancel() {
        ((CorridorBuilder)this.props()).cancel();
        super.cancel();
    }

    private void updateP1(Iterable<IsectInfo> isects) {
        ((CorridorBuilder)this.props()).pause();
        ((CorridorBuilder)this.props()).setPoint(0, null, true);
        ((CorridorBuilder)this.props()).setPoint(1, null, true);
        for (IsectInfo ii : isects) {
            ((CorridorBuilder)this.props()).setPoint(0, ii.isectPoint, true);
            if (!((CorridorBuilder)this.props()).isValid()) continue;
            break;
        }
        ((CorridorBuilder)this.props()).resume();
        this.repaintSurface();
    }

    private boolean isOnePoint() {
        return !this.isDragging();
    }

    private boolean isTwoPoint() {
        return this.isDragging();
    }

    private void removeLastDisplay() {
        if (this.d_lastDisplay != null) {
            this.getModelView().getToolScenes()[0].removeSceneObjects(this.d_lastDisplay);
            this.d_lastDisplay = null;
            this.repaintSurface();
        }
    }

    private void updateDisplay() {
        this.pauseRepaint();
        this.removeLastDisplay();
        if (((CorridorBuilder)this.props()).build() != null) {
            GeomDispMgr.Display disp = new GeomDispMgr.Display(((ModelView)this.getModelView()).getDisplayProps(), ((CorridorBuilder)this.props()).build());
            this.getModelView().getToolScenes()[0].addSceneObjects(disp);
            this.d_lastDisplay = disp;
            this.repaintSurface();
        }
        this.resumeRepaint();
    }

    protected static class Func<PropT extends CorridorBuilder>
    extends AToolFunction<NewCorrTool1Pt<PropT>> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(NewCorrTool1Pt<PropT> tool) {
            return null;
        }

        @Override
        public void mouseMoved(NewCorrTool1Pt<PropT> tool, MouseEvent e) {
            ((NewCorrTool1Pt)tool).updateP1(tool.getP1().snaps);
        }

        @Override
        public void mousePressed(NewCorrTool1Pt<PropT> tool, MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            ((NewCorrTool1Pt)tool).updateP1(tool.getP0().snaps);
        }

        @Override
        public void mouseDragged(NewCorrTool1Pt<PropT> tool, MouseEvent e) {
            if (!tool.isDragging(1)) {
                return;
            }
            ((CorridorBuilder)tool.props()).pause();
            for (IsectInfo ii : tool.getP1().snaps) {
                ((CorridorBuilder)tool.props()).setPoint(1, ii.isectPoint, true);
                if (!((CorridorBuilder)tool.props()).isValid()) continue;
                break;
            }
            ((CorridorBuilder)tool.props()).resume();
        }

        @Override
        public void mouseReleased(NewCorrTool1Pt<PropT> tool, MouseEvent e) {
            ((CorridorBuilder)tool.props()).pause();
            if (!CursorTool.aboveTolerance(0, tool.getP1().referenceSnapSc, tool.getP0().referenceSnapSc)) {
                ((CorridorBuilder)tool.props()).setPoint(1, null, true);
            }
            ((CorridorBuilder)tool.props()).finish(e.getComponent());
            ((CorridorBuilder)tool.props()).resume();
        }
    }

    private class SnapFilter
    extends DefaultFilter {
        public SnapFilter() {
            super(new Class[]{IEgressOccupiable.class}, new GeomType[]{GeomType.FACE_EDGE, GeomType.FACE_VERTEX, GeomType.FACE});
        }

        @Override
        public boolean acceptPickObjType(Class type) {
            return super.acceptPickObjType(type) && !EgressCorridor.class.isAssignableFrom(type);
        }
    }
}

