/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressBlockage;
import merlin.data.egress.geom.EgressRoom;
import merlin.mv.ModelView;
import merlin.mv.tools.AMerlinTool;
import merlin.mv.tools.RoomToolUtil;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class NewBlockageTool
extends AMerlinTool
implements MouseHistory.IListener {
    private final MouseHistory d_points;
    private final GeomDisplay d_display;

    public NewBlockageTool(ModelView mv, MerlinData md) {
        super(mv, (IToolFunction<? extends CursorTool>)new Func(md));
        this.setCancelOnRightClick(false);
        this.d_points = new MouseHistory();
        this.d_points.setDuplicatesAllowed(false);
        this.d_display = new GeomDisplay(mv.getDisplayProps(), new ImportedGeom(""));
        this.d_points.addListener(this);
    }

    @Override
    public void activate() {
        super.activate();
        this.getModelView().getToolScenes()[0].addObjects(this.d_display);
    }

    @Override
    public void deactivate() {
        this.getModelView().getToolScenes()[0].removeObjects(this.d_display);
        super.deactivate();
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        this.updateDisplay();
    }

    protected void updateDisplay() {
        List<Point3d> points = this.d_points.getAllPoints();
        IGeom geom = EmptyGeom.INSTANCE;
        IPropsSrc props = DisplayGeom.EMPTY.props;
        if (points.size() > 1) {
            geom = new PolyLine(points.toArray(new Point3d[points.size()]));
            props = new UniformProps(new IPrimProps.Edge(Color.GREEN, 3.0, IPrimProps.DEF_STIPPLE, 0));
        }
        ImportedGeom ig = (ImportedGeom)this.d_display.getSource();
        ig.setGeom(GeomNodeUtil.newNode(geom));
        ig.setDisplayProps(props);
        this.d_display.update();
    }

    @Override
    public void reset() {
        this.d_points.reset();
        this.updateDisplay();
        super.reset();
    }

    @Override
    public void finish() {
        final List<Point3d> points = this.d_points.getCommittedPoints();
        if (points.size() >= 3) {
            AMerlinOp op = new AMerlinOp(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(MerlinApp app, MerlinData md) {
                    Map<EgressRoom, List<LineSeg>> projMap;
                    int m;
                    md.beginRead();
                    try {
                        ArrayList<RoomToolUtil.Projection> projections = new ArrayList<RoomToolUtil.Projection>();
                        for (m = 0; m < points.size(); ++m) {
                            Point3d p1 = (Point3d)points.get(m);
                            Point3d p2 = (Point3d)points.get((m + 1) % points.size());
                            RoomToolUtil.project(MerlinApp.getApp().getData(), p1, p2, projections);
                        }
                        projMap = RoomToolUtil.convertToMap(projections);
                    }
                    finally {
                        md.endRead();
                    }
                    if (projMap.isEmpty()) {
                        return;
                    }
                    final Point2d[] points2d = new Point2d[points.size()];
                    for (m = 0; m < points.size(); ++m) {
                        Point3d p3d = (Point3d)points.get(m);
                        points2d[m] = new Point2d(p3d.x, p3d.y);
                    }
                    md.beginWrite();
                    Undo.begin(Intl.intl("Add Blockage"));
                    try {
                        EgressRoom.IFaceClassifier classifier = new EgressRoom.IFaceClassifier(){

                            @Override
                            public boolean test(Model model, Collection<Face> faces) {
                                Point3d p;
                                if (faces.isEmpty()) {
                                    return false;
                                }
                                Iterator<Face> it = faces.iterator();
                                Face nonVertFace = it.next();
                                while (it.hasNext()) {
                                    Face face = it.next();
                                    if (theUtil.eq0(face.plane.z, 1.0E-6)) continue;
                                    nonVertFace = face;
                                    break;
                                }
                                if ((p = model.findPointInFace(nonVertFace)) == null) {
                                    return false;
                                }
                                return Inter2D.pointInSimplePoly(1.0E-6, new Point2d(p.x, p.y), points2d);
                            }
                        };
                        String blockageName = md.blockageNameGen.getCurrentName();
                        boolean blockageAdded = false;
                        Undo.insertUndoEntry_restore(md, projMap.keySet());
                        md.selection.clear();
                        for (Map.Entry<EgressRoom, List<LineSeg>> entry : projMap.entrySet()) {
                            int fid;
                            EgressRoom room = entry.getKey();
                            try {
                                fid = room.subdivide(classifier, (Collection<? extends ICurve>)entry.getValue(), 0.0);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                continue;
                            }
                            if (fid == -1) continue;
                            EgressBlockage blockage = new EgressBlockage(room, blockageName, fid);
                            room.addBlockage(blockage);
                            blockageAdded = true;
                            md.selection.select(blockage);
                        }
                        if (blockageAdded) {
                            md.blockageNameGen.nextName();
                        }
                    }
                    finally {
                        Undo.end(md);
                        md.endWrite();
                    }
                }
            };
            UIHook.run(null, "NewBlockageTool.finish", op, 4);
        }
        this.reset();
        super.finish();
    }

    @Override
    public void cancel() {
        this.reset();
        super.cancel();
    }

    protected static class Func
    extends AToolFunction<NewBlockageTool> {
        private final MerlinData d_data;

        public Func(MerlinData md) {
            this.d_data = md;
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getSnapInfo(NewBlockageTool tool) {
            return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(new Class[]{EgressRoom.class}){

                @Override
                public boolean acceptPickObject(Object obj) {
                    return super.acceptPickObject(obj) && ((EgressRoom)obj).getModificationsAllowed();
                }
            });
        }

        @Override
        public Cursor getCursor(NewBlockageTool tool) {
            return null;
        }

        @Override
        public void mousePressed(NewBlockageTool tool, MouseEvent e) {
            tool.d_points.mousePressed(tool, e, this.filter(tool.getP1()));
            tool.updateStatusMessage();
        }

        @Override
        public void mouseReleased(NewBlockageTool tool, MouseEvent e) {
            if (e.getButton() == 3) {
                if (tool.d_points.committedSize() >= 3) {
                    System.out.println("Constructing poly " + tool.d_points.committedSize());
                    tool.finish();
                } else {
                    tool.cancel();
                }
                return;
            }
            tool.d_points.mouseReleased(tool, e, this.filter(tool.getP1()));
            tool.updateStatusMessage();
        }

        @Override
        public void mouseDragged(NewBlockageTool tool, MouseEvent e) {
            tool.d_points.mouseDragged(tool, e, this.filter(tool.getP1()));
            tool.updateStatusMessage();
        }

        @Override
        public void mouseMoved(NewBlockageTool tool, MouseEvent e) {
            tool.d_points.mouseMoved(tool, e, this.filter(tool.getP1()));
            tool.updateStatusMessage();
        }

        private CursorTool.SnapInfo filter(CursorTool.SnapInfo p) {
            if (!p.isSnapped()) {
                return null;
            }
            return p;
        }

        @Override
        public String getStatusMessage(NewBlockageTool tool) {
            List<Point3d> points = tool.d_points.getAllPoints();
            if (points.size() < 1) {
                return "";
            }
            return String.format("Blockage - Point %d: %s", tool.d_points.committedSize() + 1, tool.toString(points.get(points.size() - 1)));
        }
    }
}

