/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.MerlinApp;
import merlin.builders.AttractorBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.mv.ModelView;
import merlin.mv.tools.MerlinTool;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.units.UnitDouble;

public class NewAttractorTool
extends MerlinTool<AttractorBuilder> {
    private boolean d_p0Set = false;

    public NewAttractorTool(ModelView mv) {
        super(mv, (IToolFunction<? extends CursorTool>)new Func());
        this.resetSnap();
    }

    private void resetSnap() {
        this.setSnapInfo(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(IEgressOccupiable.class, GeomType.FACE));
    }

    private void setSnapToAny() {
        this.setSnapInfo(SnapMode.ANY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocation() {
        Point3d p1 = this.getP1().referenceSnap;
        Point3d p2 = this.getView().screenToWorld(this.getP1().referenceSnapSc, 1.0);
        GeomUtil.FindResult room = null;
        MerlinData md = MerlinApp.getApp().getData();
        md.beginRead();
        try {
            room = GeomUtil.findRoom(MerlinApp.getApp().getData(), p1, p2, 0);
        }
        finally {
            md.endRead();
        }
        if (room != null) {
            ((AttractorBuilder)this.props()).setLocation(room.room, room.faceNormal, room.p);
            this.d_p0Set = true;
        } else {
            ((AttractorBuilder)this.props()).setLocation(null, GeomConstants.VEC3D_ZPOS, p1);
        }
    }

    @Override
    protected void propsChanged(AttractorBuilder props, Object arg) {
        if (((AttractorBuilder)this.props()).aPropChanged(AttractorBuilder.COMPLETED)) {
            this.finish();
            return;
        }
    }

    private static class Func
    extends AToolFunction<NewAttractorTool> {
        private Func() {
        }

        @Override
        public Cursor getCursor(NewAttractorTool tool) {
            return null;
        }

        @Override
        public void mouseMoved(NewAttractorTool tool, MouseEvent e) {
            tool.updateLocation();
        }

        @Override
        public void mousePressed(NewAttractorTool tool, MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            tool.updateLocation();
            tool.setSnapToAny();
        }

        @Override
        public void mouseReleased(NewAttractorTool tool, MouseEvent e) {
            if (e.getButton() == 3) {
                tool.cancel();
                return;
            }
            if (!tool.d_p0Set || e.getButton() != 1) {
                return;
            }
            if (((AttractorBuilder)tool.props()).isValid()) {
                ((AttractorBuilder)tool.props()).create(e.getComponent());
            }
            tool.d_p0Set = false;
            tool.resetSnap();
        }

        @Override
        public void mouseDragged(NewAttractorTool tool, MouseEvent e) {
            if (!tool.isDragging(1)) {
                return;
            }
            if (tool.d_p0Set && tool.dragAboveTolerance(0)) {
                Point3d p0 = ((AttractorBuilder)tool.props()).get(Attractor.LOCATION);
                Vector3d roomNorm = ((AttractorBuilder)tool.props()).get(Attractor.ROOM_NORMAL);
                Plane3d plane = new Plane3d(roomNorm, p0);
                CursorTool.Ray ray = tool.getPickRay();
                Point3d isect = Inter3D.rayPlaneIntersection(ray.begin, ray.dir, plane, 1.0E-6);
                if (isect != null) {
                    double dist = p0.distance(isect);
                    ((AttractorBuilder)tool.props()).set(Attractor.INFLUENCE_RADIUS, new UnitDouble(dist, Geometry.LENGTH_UNIT));
                }
            }
        }
    }
}

