/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.geom.EgressBlockage;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.geom.IMerlinGeomSrc;
import merlin.mv.ModelView;
import merlin.mv.Snappers.GridSnapper;
import merlin.mv.displays.AgentRenderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickConfig;
import thunderheadeng.scene3d.picking.IPickRoot;
import thunderheadeng.scene3d.picking.IPickSession;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.theUtil;

public class MerlinPickRoot
implements IPickRoot {
    private static final Class[] PICK_PREFS = new Class[]{IHandle.class, IBehaviorAction.class, Attractor.class, IQueueElement.class, OccTarget.class, EgressBlockage.class, IEgressConnector.class, EgressCorridor.class, IEgressComp.class};
    private final MerlinData d_data;
    private final ModelView d_mv;
    private final AgentRenderer d_renderer;

    public MerlinPickRoot(MerlinData md, ModelView mv, AgentRenderer renderer) {
        this.d_data = md;
        this.d_mv = mv;
        this.d_renderer = renderer;
    }

    @Override
    public IPickSession beginPicking() {
        return new Session();
    }

    private static class EgressConfig
    implements IPickConfig {
        private EgressConfig() {
        }

        @Override
        public ConvexHull getClippingRegion() {
            return new ConvexHull(new Plane3d[0]);
        }
    }

    private static class ImportConfig
    implements IPickConfig {
        private final ConvexHull d_clip;

        public ImportConfig(ConvexHull ch) {
            this.d_clip = ch;
        }

        @Override
        public ConvexHull getClippingRegion() {
            return this.d_clip;
        }
    }

    private class Session
    implements IPickSession {
        private final boolean d_importWireframe;
        private final Camera d_camera;

        private Session() {
            this.d_importWireframe = MerlinPickRoot.this.d_mv.isImportWireframe();
            this.d_camera = MerlinPickRoot.this.d_mv.getMainView().getCamera();
        }

        @Override
        public IPickConfig[] getPickConfigs() {
            ArrayList<IPickConfig> configs = new ArrayList<IPickConfig>();
            configs.add(new EgressConfig());
            boolean allVisible = true;
            ArrayList<ImportConfig> floorConfigs = new ArrayList<ImportConfig>();
            for (Floor floor : ((MerlinPickRoot)MerlinPickRoot.this).d_data.floors.getMembers(Floor.class)) {
                if (!floor.isVisible()) continue;
                ConvexHull clip = ((MerlinPickRoot)MerlinPickRoot.this).d_data.floors.getClippingRegion(floor);
                floorConfigs.add(new ImportConfig(clip));
                allVisible &= clip.acceptsAll();
            }
            if (allVisible) {
                configs.add(new ImportConfig(new ConvexHull(new Plane3d[0])));
            } else {
                configs.addAll(floorConfigs);
            }
            return theUtil.toArray(configs, IPickConfig.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void find(IPickConfig config, ITest<AABox> test, IResult<IPickable> result) {
            boolean filterByFloor;
            if (config instanceof EgressConfig) {
                filterByFloor = false;
                result.mark(MerlinPickRoot.this.d_renderer, Containment.INTERSECTS);
            } else {
                filterByFloor = true;
            }
            final IResult<IPickable> baseResult = result;
            IResult<IDisplayableGeomSrc> fresult = new IResult<IDisplayableGeomSrc>(){

                @Override
                public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                    if (obj instanceof IPickable && filterByFloor == Session.this.isFloorFilteredGeom(MerlinPickRoot.this.d_data, obj)) {
                        baseResult.mark((IPickable)((Object)obj), ctmt);
                    }
                }
            };
            MerlinPickRoot.this.d_data.beginRead();
            try {
                ((MerlinPickRoot)MerlinPickRoot.this).d_data.geomLocation.getLocator().find(test, (IResult<? super IDisplayableGeomSrc>)fresult, 0);
            }
            finally {
                MerlinPickRoot.this.d_data.endRead();
            }
        }

        @Override
        public boolean isVisible(IPickConfig config, Object o) {
            if (MerlinPickRoot.this.d_mv.getManipMgr().isManipulating() && (o instanceof IHandle || MerlinPickRoot.this.d_mv.getManipMgr().isManipulating(o))) {
                return false;
            }
            return MerlinPickRoot.this.d_data.isVisible(o);
        }

        @Override
        public boolean isWireframe(IPickConfig config, Object o) {
            return this.d_importWireframe && ((MerlinPickRoot)MerlinPickRoot.this).d_data.hierarchy.isDescendent(((MerlinPickRoot)MerlinPickRoot.this).d_data.sceneGeom, o);
        }

        @Override
        public boolean isOcclusionTarget(Object o) {
            if (o instanceof IHandle) {
                if (MerlinPickRoot.this.d_mv.getManipMgr().getCurrentManipObj() instanceof EgressAgent) {
                    return false;
                }
            } else if (o instanceof GridSnapper) {
                return this.d_camera instanceof PerspectiveCamera;
            }
            return !(o instanceof ISnapConstraint);
        }

        @Override
        public boolean isOcclusionSource(Object o) {
            return !(o instanceof IHandle);
        }

        @Override
        public int compare(Object o1, Object o2) {
            int diff = this.getClassPreference(o1) - this.getClassPreference(o2);
            if (diff == 0) {
                // empty if block
            }
            return diff;
        }

        private int getClassPreference(Object obj) {
            for (int m = 0; m < PICK_PREFS.length; ++m) {
                if (!PICK_PREFS[m].isInstance(obj)) continue;
                return m;
            }
            return PICK_PREFS.length;
        }

        private double getVolume(Object o) {
            if (o instanceof IMerlinGeomSrc) {
                AABox bounds = ((IMerlinGeomSrc)o).getBounds();
                return bounds != null ? bounds.volume(2.220446049250313E-16) : Double.MAX_VALUE;
            }
            return Double.MAX_VALUE;
        }

        public boolean isFloorFilteredGeom(MerlinData md, Object object) {
            return object instanceof IMerlinGeomSrc && md.hierarchy.isDescendent(md.sceneGeom, object) || md.hierarchy.isDescendent(md.behaviors, object) || md.hierarchy.isDescendent(md.elevators, object);
        }

        @Override
        public void pickPoints(IPickable obj, IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
            obj.pickPoints(isects, filter, rayBegin, rayEnd, rayDirN, tester);
        }

        @Override
        public void pickBox(IPickable obj, IBoxCollector result, IIsectFilter filter, ConvexHull region) {
            obj.pickBox(result, filter, region);
        }
    }
}

