/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import merlin.MerlinApp;
import merlin.actions.TransformAction;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.geom.Geometry;
import merlin.manip.ATransformManip;
import merlin.manip.TranslateManip;
import merlin.mv.ModelView;
import merlin.mv.tools.MerlinTool;
import merlin.util.MerlinProps;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.units.UnitPoint3D;

public abstract class ATransformTool<T extends ATransformManip>
extends MerlinTool<T> {
    public ATransformTool(ModelView mv, Func<T, ? extends ATransformTool<T>> func) {
        super(mv, func);
    }

    @Override
    public void cancel() {
        ((ATransformManip)this.props()).cancel();
        this.reset();
        super.cancel();
    }

    @Override
    public void finish() {
        this.reset();
        super.finish();
    }

    @Override
    public void activate() {
        super.activate();
        ((ATransformManip)this.props()).pause();
        ((ATransformManip)this.props()).setNumCopies(0);
        MerlinData md = MerlinApp.getApp().getData();
        Set<IMerlinObj> sel = TransformAction.getValidObjs(md);
        ((ATransformManip)this.props()).setSelection(sel);
        ((ATransformManip)this.props()).resume();
    }

    @Override
    public void deactivate() {
        ((ATransformManip)this.props()).setSelection(Collections.EMPTY_SET);
        super.deactivate();
    }

    @Override
    protected void propsChanged(T props, Object arg) {
        if (((MerlinProps)props).aPropChanged(ATransformManip.OBJS_TRANSFORMED, TranslateManip.CANCELLED)) {
            this.finish();
        }
    }

    private void updateCopyMode(int modifiers) {
        boolean copyMode = (modifiers & 0x80) == 128;
        int numCopies = copyMode ? 1 : 0;
        ((ATransformManip)this.props()).setNumCopies(numCopies);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.pauseRepaint();
        super.keyPressed(e);
        this.updateCopyMode(e.getModifiersEx());
        this.resumeRepaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.pauseRepaint();
        super.keyReleased(e);
        this.updateCopyMode(e.getModifiersEx());
        this.resumeRepaint();
    }

    protected UnitPoint3D getFirstPoint(boolean p0) {
        Point3d p;
        if (p0) {
            p = this.getP0().referenceSnap;
            if (this.getP0().isSnapped()) {
                return new UnitPoint3D(p, Geometry.LENGTH_UNIT);
            }
        } else {
            p = this.getP1().referenceSnap;
            if (this.getP1().isSnapped()) {
                return new UnitPoint3D(p, Geometry.LENGTH_UNIT);
            }
        }
        CursorTool.Ray pickRay = this.getPickRay(p);
        Point3d mid = Util3D.add(pickRay.begin, (Tuple3d)Util3D.scale(pickRay.dir, 0.5));
        return new UnitPoint3D(mid, Geometry.LENGTH_UNIT);
    }

    protected UnitPoint3D getNextPoint(UnitPoint3D p1, Point3d p2, boolean pointSnapped) {
        Camera cam = this.getView().getCamera();
        if (cam instanceof PerspectiveCamera && pointSnapped) {
            return new UnitPoint3D(p2, Geometry.LENGTH_UNIT);
        }
        Vector3d viewVec = cam.getViewVector();
        viewVec.normalize();
        viewVec.negate();
        Plane3d plane = new Plane3d(viewVec, p1.getPoint3dValue(Geometry.LENGTH_UNIT));
        CursorTool.Ray pickRay = this.getPickRay(p2);
        Point3d isect = Inter3D.linePlaneIntersection(pickRay.begin, pickRay.dir, plane, 1.0E-6);
        assert (isect != null);
        return new UnitPoint3D(isect, Geometry.LENGTH_UNIT);
    }

    protected static class Func<PropT extends ATransformManip, ToolT extends ATransformTool<PropT>>
    extends AToolFunction<ToolT> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(ToolT tool) {
            return null;
        }

        @Override
        public void mousePressed(ToolT tool, MouseEvent e) {
        }

        @Override
        public void mouseReleased(ToolT tool, MouseEvent e) {
        }

        @Override
        public void mouseMoved(ToolT tool, MouseEvent e) {
        }

        @Override
        public void mouseDragged(ToolT tool, MouseEvent e) {
            ((CursorTool)tool).mouseMoved(e);
        }
    }
}

