/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.queues;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicArrowButton;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.CompElementActions;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.gui.SetChooser;
import merlin.gui.stat.CompactCurvePnl;
import merlin.mv.gui.SelectionEditorPanel;
import thunderheadeng.gui.DropDownButton;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theUtil;

public class QueueObjectPanel {
    private final SelectionEditorPanel.EditorPanel d_queuePnl = new QueueObjectSect();
    private final SelectionEditorPanel.EditorPanel d_queueProps;
    private final SelectionEditorPanel.EditorPanel d_addQElemPnl;
    private final SelectionEditorPanel.EditorPanel d_queueServicePnl;
    private final SelectionEditorPanel.EditorPanel d_queuePathPnl;
    public static final int s_addServIx = 0;
    public static final int s_addPathIx = 1;
    public static final int s_addNodeIx = 2;

    public QueueObjectPanel(MerlinData md, guiAction[] qElemActions) {
        this.d_queueProps = new QueuePropertySect(md);
        this.d_addQElemPnl = new AddQueueElementSect(qElemActions);
        this.d_queueServicePnl = new QueueServiceEditSect();
        this.d_queuePathPnl = new QueuePathEditSect(md);
    }

    public SelectionEditorPanel.EditorPanel getQueueInfoPnl() {
        return this.d_queuePnl;
    }

    public SelectionEditorPanel.EditorPanel getQueuePropPnl() {
        return this.d_queueProps;
    }

    public SelectionEditorPanel.EditorPanel getAddQueueElemPnl() {
        return this.d_addQElemPnl;
    }

    public SelectionEditorPanel.EditorPanel getQueueServiceEditPnl() {
        return this.d_queueServicePnl;
    }

    public SelectionEditorPanel.EditorPanel getQueuePathEditPnl() {
        return this.d_queuePathPnl;
    }

    private static class AddQueueElementSect
    extends AQueueSect {
        private static final long serialVersionUID = -1016560368548757555L;
        private final guiAction[] d_actions;
        private final DropDownButton d_button;
        private final guiLabel d_addLbl;
        private final Map<guiAction, String> d_actionToShortDesc;
        private final guiAction d_addServAction;
        private final guiAction d_addPathAction;
        private final guiAction d_addNodeAction;

        public AddQueueElementSect(guiAction[] actions) {
            this.d_actions = actions;
            this.d_addServAction = actions[0];
            this.d_addPathAction = actions[1];
            this.d_addNodeAction = actions[2];
            this.d_button = new DropDownButton(actions);
            this.d_actionToShortDesc = new HashMap<guiAction, String>(actions.length);
            Arrays.stream(actions).forEach(action -> this.d_actionToShortDesc.put((guiAction)action, (String)action.getValue("ShortDescription")));
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.d_rowSpace = 1;
            this.d_addLbl = new guiLabel(Intl.intl("Add Element:"));
            gbh.addRow(this.d_addLbl, this.d_button);
        }

        @Override
        protected void updateBinding(Collection<ICompElement> objs) {
            super.updateBinding(objs);
            this.setEnabled(this.shouldEnable(objs));
            if (!this.isEnabled()) {
                return;
            }
            ICompElement selection = objs.iterator().next();
            ArrayList<guiAction> actionsToShow = new ArrayList<guiAction>();
            if (selection instanceof QueueObject || selection instanceof QueueService) {
                actionsToShow.add(this.d_addServAction);
                actionsToShow.add(this.d_addPathAction);
            } else if (selection instanceof QueuePath) {
                actionsToShow.add(this.d_addServAction);
                actionsToShow.add(this.d_addPathAction);
                actionsToShow.add(this.d_addNodeAction);
            } else if (selection instanceof QueuePathNode) {
                actionsToShow.add(this.d_addNodeAction);
            }
            this.d_button.updateAvailableActions(actionsToShow);
            Stream.of(this.d_actions).forEach(a -> {
                a.setEnabled(true);
                a.putValue("ShortDescription", this.d_actionToShortDesc.get(a));
            });
        }

        private boolean shouldEnable(Collection<ICompElement> objs) {
            return objs.size() == 1;
        }
    }

    private static class QueuePropertySect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 1L;

        public QueuePropertySect(MerlinData md) {
            SetChooser<OccProfile> profileChooser = new SetChooser<OccProfile>(md, Intl.intl("Accepted Profiles"), Intl.intl("none"), 0, md.profiles, OccProfile.class, Predicates.alwaysTrue());
            this.addConnection(new SelectionEditorPanel.SetPropConnection<OccProfile>(QueueObject.RESTRICTED_PROFILES, profileChooser, true));
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.d_rowSpace = 1;
            gbh.addRow(Intl.intl("Accepted Profiles:"), profileChooser);
        }
    }

    private static class QueueServiceEditSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -8909820651890573265L;

        public QueueServiceEditSect() {
            CompactCurvePnl servTimePnl = new CompactCurvePnl(Intl.intl("Service Time:"), 1);
            this.addConnection(new SelectionEditorPanel.CurveConn<IDistributedVal<UnitDouble>>(QueueService.PROP_TIME, servTimePnl));
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.d_rowSpace = 1;
            gbh.addRow(Intl.intl("Service Time:"), servTimePnl);
        }
    }

    private static class QueuePathEditSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -322309099661378044L;

        public QueuePathEditSect(MerlinData md) {
            CompactCurvePnl spaceAmt = new CompactCurvePnl(Intl.intl("Custom Occupant Spacing:"), 0);
            this.addConnection(new SelectionEditorPanel.CurveConn<IDistributedVal<UnitDouble>>(QueuePath.CUSTOM_SPACING, spaceAmt));
            guiMultiStateCheckBox ckFollowPath = new guiMultiStateCheckBox(Intl.intl("Force Follow Path"));
            this.addConnection(new SelectionEditorPanel.BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(QueuePath.FOLLOW_PATH), ckFollowPath));
            SetChooser<OccProfile> profileChooser = new SetChooser<OccProfile>(md, Intl.intl("Accepted Profiles"), Intl.intl("none"), 0, md.profiles, OccProfile.class, Predicates.alwaysTrue());
            this.addConnection(new SelectionEditorPanel.SetPropConnection<OccProfile>(QueueObject.RESTRICTED_PROFILES, profileChooser, true));
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.d_rowSpace = 1;
            gbh.addRow(Intl.intl("Occupant Spacing:"), spaceAmt);
            gbh.addRow(ckFollowPath);
            gbh.addRow(Intl.intl("Accepted Profiles:"), profileChooser);
        }
    }

    public static class QueueObjectSect
    extends AQueueSect {
        private static final long serialVersionUID = -8650270417389716294L;
        private final guiLabel d_queueLbl = new guiLabel(Intl.intl("Queue:"));
        private final guiLabel d_queueElemLbl;
        private final guiTextField d_queueFld = new guiTextField();
        private final guiTextField d_queueElemFld;
        private final JButton d_leftBtn;
        private final JButton d_rightBtn;
        private final SelectionEditorPanel.NamePropConnection d_queueConn;
        private final SelectionEditorPanel.NamePropConnection d_queueElemConn;

        public QueueObjectSect() {
            Dimension dim = new Dimension(150, this.d_queueFld.getPreferredSize().height);
            this.d_queueFld.setPreferredSize(dim);
            this.d_queueConn = new SelectionEditorPanel.NamePropConnection(this.d_queueFld);
            this.addConnection(this.d_queueConn);
            this.d_queueElemLbl = new guiLabel(Intl.intl("Element:"));
            this.d_queueElemFld = new guiTextField();
            this.d_queueElemFld.setPreferredSize(dim);
            this.d_queueElemFld.setEditable(false);
            this.d_queueElemConn = new SelectionEditorPanel.NamePropConnection(this.d_queueElemFld);
            this.addConnection(this.d_queueElemConn);
            this.d_leftBtn = new BasicArrowButton(7);
            this.d_rightBtn = new BasicArrowButton(3);
            guiPanel btnPnl = new guiPanel(new FlowLayout(0, 1, 0));
            btnPnl.add(this.d_leftBtn);
            btnPnl.add(this.d_rightBtn);
            this.d_leftBtn.addActionListener(new ChangeAction(-1));
            this.d_rightBtn.addActionListener(new ChangeAction(1));
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.d_rowSpace = 1;
            gbh.addRow(this.d_queueLbl, this.d_queueFld, 2);
            gbh.addRow(this.d_queueElemLbl, this.d_queueElemFld, btnPnl);
        }

        @Override
        protected void updateBinding(Collection<ICompElement> objs) {
            int elemix;
            super.updateBinding(objs);
            this.d_queueConn.bind(this.d_queues);
            this.d_queueElemConn.bind(this.d_qElems);
            this.d_queueFld.setEditable(this.d_qElems.isEmpty());
            this.d_queueElemFld.setEditable(!this.d_qElems.isEmpty());
            this.d_queueElemLbl.setVisible(!this.d_qElems.isEmpty());
            boolean scrollEnabled = this.d_queues.size() == 1 && this.getQueue().getMembers().size() > 1 && this.d_qElems.size() == 1;
            this.d_leftBtn.setVisible(scrollEnabled);
            this.d_rightBtn.setVisible(scrollEnabled);
            if (scrollEnabled && (elemix = this.getElemIx()) >= 0) {
                this.d_leftBtn.setEnabled(elemix > 0);
                this.d_rightBtn.setEnabled(elemix < this.getQueue().getMembers().size() - 1);
            }
        }

        private int getElemIx() {
            int ix = 0;
            for (IQueueElement elem : this.getQueue().getMembers(IQueueElement.class)) {
                if (elem == this.getQueueElem()) {
                    return ix;
                }
                ++ix;
            }
            return -1;
        }

        private IQueueElement getQueueElement(int ix) {
            int m = 0;
            for (IQueueElement elem : this.getQueue().getMembers(IQueueElement.class)) {
                if (m == ix) {
                    return elem;
                }
                ++m;
            }
            return null;
        }

        private class ChangeAction
        implements ActionListener {
            private final int direction;

            public ChangeAction(int direction) {
                this.direction = direction;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int currix = QueueObjectSect.this.getElemIx();
                int nextix = currix + this.direction;
                if (nextix < 0 || nextix >= QueueObjectSect.this.getQueue().getMembers().size()) {
                    return;
                }
                IQueueElement nextAction = QueueObjectSect.this.getQueueElement(nextix);
                if (nextAction != null) {
                    MerlinApp.getApp().getData().selection.set(nextAction);
                }
            }
        }
    }

    private static abstract class AQueueSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 2455527731919202073L;
        protected Collection<QueueObject> d_queues;
        protected Collection<IQueueElement> d_qElems;
        protected Collection<QueuePathNode> d_pathNodes;

        private AQueueSect() {
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            MerlinData md = MerlinApp.getApp().getData();
            this.d_pathNodes = theUtil.filter(objs, QueuePathNode.class);
            LinkedHashSet<QueuePath> elems = new LinkedHashSet<QueuePath>(theUtil.filter(objs, QueuePath.class));
            elems.addAll(theUtil.filter(objs, QueueService.class));
            for (QueuePathNode node : this.d_pathNodes) {
                elems.add((QueuePath)((IQueueElement)md.hierarchy.getParent(node)));
            }
            this.d_qElems = elems;
            LinkedIdentityHashSet<QueueObject> queues = new LinkedIdentityHashSet<QueueObject>((Collection<QueueObject>)theUtil.filter(objs, QueueObject.class));
            for (IQueueElement qElem : this.d_qElems) {
                queues.add((QueueObject)MerlinApp.getApp().getData().hierarchy.getParent(qElem));
            }
            this.d_queues = queues;
            super.bind(this.d_queues);
            this.updateBinding(objs);
        }

        protected QueueObject getQueue() {
            return this.d_queues.isEmpty() ? null : this.d_queues.iterator().next();
        }

        protected IQueueElement getQueueElem() {
            return this.d_qElems.isEmpty() ? null : this.d_qElems.iterator().next();
        }

        protected QueuePathNode getQueuePathNode() {
            return this.d_pathNodes.isEmpty() ? null : this.d_pathNodes.iterator().next();
        }

        protected void updateBinding(Collection<ICompElement> objs) {
        }
    }
}

