/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.propConnections;

import java.util.Collection;
import merlin.actions.CompElementActions;
import merlin.actions.Undo;
import merlin.data.ICompElement;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.util.MerlinUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.IMaterial;

public class MaterialProp
extends CompElementActions.DefProp<ICompElement, IMaterial> {
    public MaterialProp() {
        super(MerlinData.MATERIAL);
    }

    @Override
    public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
        return super.get(md, CompElementActions.flattenToLocallyDefined(this.getProp(), objs));
    }

    private IMaterial[] getMats(MerlinData md, Object prop, ICompElement obj) {
        IMaterial[] mats = (IMaterial[])obj.getProperty(prop);
        if (mats.length > 1 && MerlinUtil.isUniform(mats)) {
            mats = new IMaterial[]{mats[0]};
        }
        return mats;
    }

    @Override
    protected Object get(MerlinData md, Object prop, ICompElement obj) {
        IMaterial[] mats = this.getMats(md, prop, obj);
        if (mats.length == 0) {
            return null;
        }
        if (mats.length == 1) {
            return mats[0];
        }
        return ICompElement.NON_UNIFORM;
    }

    @Override
    public void set(MerlinData md, Collection<? extends ICompElement> objs, IMaterial newVal) {
        super.set(md, CompElementActions.flattenToLocallyDefined(this.getProp(), objs), newVal);
    }

    @Override
    protected void set(MerlinData md, Object prop, ICompElement obj, IMaterial newVal) {
        IMaterial[] oldMats = this.getMats(md, prop, obj);
        if (oldMats.length == 1 && oldMats[0] == newVal) {
            return;
        }
        if (obj.getPropTypes(1).contains(ImportedGeom.PROP_GEOM)) {
            IGeomNode newGeom = (IGeomNode)obj.getProperty(ImportedGeom.PROP_GEOM);
            newGeom = ImportedGeom.finalizeTexCoords(newGeom, MaterialProp.needsTexCoords(newVal));
            obj.setProperty(ImportedGeom.PROP_GEOM, newGeom);
        }
        obj.setProperty(prop, new IMaterial[]{newVal});
    }

    private static boolean needsTexCoords(IMaterial mat) {
        if (mat == null) {
            return false;
        }
        return mat.getAttributes().hasTexture();
    }

    @Override
    protected void saveState(MerlinData md, Object prop, Collection<? extends ICompElement> objs, IMaterial newVal) {
        Undo.insertUndoEntry_propRestore(md, objs, ImportedGeom.PROP_DISPLAY_PROPS);
        Undo.insertUndoEntry_propRestore(md, objs, ImportedGeom.PROP_GEOM);
    }
}

