/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import merlin.Intl;
import merlin.data.MerlinData;
import merlin.manip.TranslateManip;
import merlin.mv.gui.ATransformPanel;
import merlin.mv.gui.LocationPanel;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitPoint3D;

public class TranslatePanel
extends ATransformPanel<TranslateManip> {
    private static final long serialVersionUID = 5852514131150857287L;
    private final MoveVecPanel d_moveVecPanel = new MoveVecPanel();

    public TranslatePanel(MerlinData data) {
        super(data, Integer.MAX_VALUE);
        this.addSeparator();
        this.addSection(this.d_moveVecPanel);
        this.addCompletionPanel();
    }

    @Override
    protected String getXformName() {
        return Intl.intl("Move");
    }

    private static class MoveVecPanel
    extends LocationPanel<TranslateManip> {
        private static final long serialVersionUID = -5114545946641091222L;

        public MoveVecPanel() {
            super(Intl.intl("Move X"), Intl.intl("Move Y"), Intl.intl("Move Z"), TranslateManip.TRANSFORM_CHANGED, TranslateManip.CANCELLED, TranslateManip.OBJS_TRANSFORMED);
        }

        @Override
        protected void updateFromProps(TranslateManip props) {
            UnitPoint3D moveVec = props.getMoveVec();
            if (moveVec != null) {
                this.setValue(moveVec);
            } else {
                this.setValue(new UnitPoint3D(0.0, 0.0, 0.0, SI.METER));
            }
        }

        @Override
        protected void updateToProps(TranslateManip props) {
            props.setMoveVec(this.getValue());
        }
    }
}

