/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.CompElementActions;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.Behavior;
import merlin.data.value.IFunction1d;
import merlin.gui.DiscreteChooser;
import merlin.gui.DistributionEditor;
import merlin.gui.value.Function1dEditorFactory;
import merlin.gui.value.IValEditor;
import merlin.gui.value.MultiValEditor;
import merlin.mv.gui.SelectionEditorPanel;
import merlin.util.Property;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;

public class OccSourcePanel {
    private SelectionEditorPanel.EditorPanel d_flowRatePnl = new SelectionEditorPanel.EditorPanel();
    private SelectionEditorPanel.EditorPanel d_masterPanel1;
    private SelectionEditorPanel.EditorPanel d_masterPanel2;
    private SelectionEditorPanel.EditorPanel d_masterPanel3;
    private CompPanel d_componentPanel;

    public OccSourcePanel(MerlinData md) {
        GridBagHelper gb = new GridBagHelper(this.d_flowRatePnl);
        IValEditor<IFunction1d> flowRate = Function1dEditorFactory.nullable(OccSourceObj.PROP_FLOW_RATE, false, "", null, () -> (IFunction1d)OccSourceObj.PROP_FLOW_RATE.defVal, 3);
        gb.addRow(flowRate);
        DistributionEditor<OccProfile> profilesDistEd = new DistributionEditor<OccProfile>(md, Intl.intl("Profile"), md.profiles, OccProfile.class, null);
        DistributionEditor<Behavior> behaviorsDistEd = new DistributionEditor<Behavior>(md, Intl.intl("Behavior"), md.behaviors, Behavior.class, null);
        guiComboBox<String> cbEnforceFlowRate = new guiComboBox<String>((Collection<String>)Arrays.asList(Intl.intl("Yes"), Intl.intl("No")));
        Dimension d = cbEnforceFlowRate.getPreferredSize();
        cbEnforceFlowRate.setPreferredSize(new Dimension(d.width + 5, d.height));
        guiLabel enforceFlowrateLbl = new guiLabel(Intl.intl("Enforce Flow Rate:"));
        enforceFlowrateLbl.setToolTipText(Intl.intl("If true occupants will be created even if there is not enough free space"));
        this.d_componentPanel = new CompPanel(md);
        guiLabel groupTemplateLbl = new guiLabel(Intl.intl("Movement Group Template:"));
        DistributionEditor<OccGroupTypeObj> groupTemplateDistEd = new DistributionEditor<OccGroupTypeObj>(md, Intl.intl("Movement Group Template"), md.occGroupTypes, OccGroupTypeObj.class, null);
        this.d_masterPanel1 = new SelectionEditorPanel.EditorPanel();
        this.d_masterPanel2 = new SelectionEditorPanel.EditorPanel();
        this.d_masterPanel3 = new SelectionEditorPanel.EditorPanel();
        gb = new GridBagHelper(this.d_masterPanel1);
        gb.addRow(Intl.intl("Flow Rate:"), this.d_flowRatePnl);
        gb.addRow(enforceFlowrateLbl, cbEnforceFlowRate);
        gb = new GridBagHelper(this.d_masterPanel2);
        gb.d_rowSpace = 1;
        gb.addRow(Intl.intl("Profile:"), profilesDistEd);
        gb.addRow(Intl.intl("Behavior:"), behaviorsDistEd);
        gb.addRow(new guiLabel(Intl.intl("Component:")), this.d_componentPanel);
        gb.finalizeRows();
        gb = new GridBagHelper(this.d_masterPanel3);
        gb.addRow(groupTemplateLbl, groupTemplateDistEd);
        this.d_masterPanel1.addConnection(new OccSourceFlowrateConn((MultiValEditor)flowRate.getComponent()));
        this.d_masterPanel1.addConnection(new BoolConn(new CompElementActions.DefProp(OccSourceObj.PROP_ENFORCE_FLOWRATE), cbEnforceFlowRate, Intl.intl("Yes"), Intl.intl("No"), Intl.intl("Set Enforce Flow Rate")));
        this.d_masterPanel2.addConnection(new SelectionEditorPanel.DistributionConn(new CompElementActions.DefProp(OccSourceObj.PROP_PROFILE_DIST), profilesDistEd, Intl.intl("Set Occupant Source Profile Distribution")));
        this.d_masterPanel2.addConnection(new SelectionEditorPanel.DistributionConn(new CompElementActions.DefProp(OccSourceObj.PROP_BEHAVIOR_DIST), behaviorsDistEd, Intl.intl("Set Occupant Source Behavior Distribution")));
        this.d_masterPanel2.addConnection(new OccSourceCompConn((Object)new CompElementActions.DefProp(OccSourceObj.PROP_COMPONENT), this.d_componentPanel));
        groupTemplateDistEd.setExtraObjs(data -> Collections.singleton(data.occGroupTypes.NO_GROUP_TYPE));
        this.d_masterPanel3.addConnection(new SelectionEditorPanel.DistributionConn(new CompElementActions.DefProp(OccSourceObj.PROP_GROUP_TEMPLATE_DIST), groupTemplateDistEd, Intl.intl("Set Occupant Source Movement Group Template Distribution")));
    }

    public List<SelectionEditorPanel.EditorPanel> getPanels() {
        return Arrays.asList(this.d_masterPanel1, this.d_masterPanel2, this.d_masterPanel3);
    }

    private static class BoolConn
    extends SelectionEditorPanel.ASinglePropConnection<guiComboBox<String>> {
        private String yes;
        private String no;
        private String undoStr;

        public BoolConn(Object prop, guiComboBox<String> control, String yes, String no, String undoStr) {
            super(prop, control);
            this.yes = yes;
            this.no = no;
            this.undoStr = undoStr;
            control.addActionListener(e -> this.onControlChanged());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<String> comp) {
            String val = comp.getSelectedItem();
            Urn<Boolean> urn = val.equals(this.yes) ? new Urn<Boolean>(true) : new Urn<Boolean>(false);
            SelectionEditorPanel.setPropRecursive(this.undoStr, (CompElementActions.IObjectProp)prop, objs, urn);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<String> comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val == ICompElement.NON_UNIFORM || val == ICompElement.NOT_SUPPORTED) {
                comp.setSelectedItem(null);
            } else if (val instanceof IUrn) {
                Boolean value = (Boolean)((IUrn)val).getValue(new Random());
                if (value.booleanValue()) {
                    comp.setSelectedItem(this.yes);
                } else {
                    comp.setSelectedItem(this.no);
                }
            }
            comp.setModified(false);
        }
    }

    private static class OccSourceFlowrateConn
    extends SelectionEditorPanel.ASinglePropConnection<MultiValEditor<IFunction1d>> {
        public OccSourceFlowrateConn(MultiValEditor<IFunction1d> comp) {
            super(new CompElementActions.DefProp(OccSourceObj.PROP_FLOW_RATE), comp);
            comp.addValueListener(e -> this.onControlChanged());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, MultiValEditor<IFunction1d> comp) {
            IFunction1d sourceFlowrate = (IFunction1d)comp.getValue();
            if (sourceFlowrate == null) {
                return;
            }
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Occ Source Flowrate"), (CompElementActions.IObjectProp)prop, objs, sourceFlowrate);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, MultiValEditor<IFunction1d> comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val instanceof IFunction1d) {
                comp.setValue((IFunction1d)val);
            } else if (val == ICompElement.NON_UNIFORM || val == ICompElement.NOT_SUPPORTED) {
                comp.setValue(null);
            }
            comp.setModified(false);
        }
    }

    private static class OccSourceCompConn
    extends SelectionEditorPanel.ASinglePropConnection<CompPanel> {
        public OccSourceCompConn(Object prop, CompPanel control) {
            super(prop, control);
            Runnable action = () -> this.onControlChanged();
            control.componentChooser.addCommitAction(action);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, CompPanel comp) {
            IEgressComp val = comp.getValue();
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Occupant Source Component"), (CompElementActions.IObjectProp)prop, objs, val);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, CompPanel comp) {
            Property<IEgressComp> property;
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (Objects.equals(val, ICompElement.NON_UNIFORM)) {
                property = Property.nonUniform();
            } else {
                IEgressComp component = (IEgressComp)val;
                property = Property.of(component);
            }
            boolean enable = true;
            for (ICompElement iCompElement : objs) {
                if (!(iCompElement instanceof OccSourceObj) || !((OccSourceObj)iCompElement).getType().equals((Object)OccSourceObj.OccSourceType.REGION)) continue;
                enable = false;
                break;
            }
            comp.setValue(property);
            comp.setEnabled(enable);
            comp.setModified(false);
        }
    }

    private static class CompPanel
    extends guiPanel {
        private static final long serialVersionUID = -5264040439448268249L;
        private final DiscreteChooser<IEgressComp> componentChooser;

        public CompPanel(MerlinData md) {
            Predicate<Object> filter = new TypeFilter(EgressDoor.class);
            filter = Predicates.or(filter, OccSourceObj.occsAllowedFilter());
            this.componentChooser = new DiscreteChooser<IEgressComp>(md, Intl.intl("Select Component"), IEgressComp.class, null);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.componentChooser);
        }

        public IEgressComp getValue() {
            return this.componentChooser.getObj();
        }

        public void setValue(Property<IEgressComp> property) {
            this.componentChooser.setObj(property);
        }
    }
}

