/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.util.Observable;
import javax.swing.JButton;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.builders.OccTargetBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.Geometry;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditCommand;
import merlin.gui.MerlinUDF;
import merlin.gui.guiUtil;
import merlin.mv.gui.RoomLocPanel;
import org.jscience.physics.units.NonSI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.units.UnitPoint3D;

public class NewOccTargetPanel
extends APropEditPanel<OccTargetBuilder> {
    private static final long serialVersionUID = 1L;
    private final MerlinUDF d_orientFld;
    private final guiDoubleField d_priorityFld;

    public NewOccTargetPanel(MerlinData md) {
        super(OccTarget.ORIENT, OccTarget.PRIORITY);
        guiLabel orientLbl = guiUtil.lbl(Intl.intl("Orientation:"), "<html>" + Intl.intl("The orientation of the occupant when they occupy this target.<br>This is an angle relative to the +X axis."));
        this.d_orientFld = this.initValueField(new MerlinUDF(7, UnitDoubleVR.between(-360.0, 360.0, NonSI.DEGREE_ANGLE, true, true)), new IPropEditCommand[0]);
        this.d_orientFld.setColumns(8);
        guiLabel priorityLbl = guiUtil.lbl(Intl.intl("Priority:"), "<html>" + Intl.intl("Defines a priority that can optionally be used by occupants to prioritize some<br>targets over others."));
        this.d_priorityFld = this.initValueField(new guiDoubleField(0.0), new IPropEditCommand[0]);
        this.d_priorityFld.setColumns(8);
        guiPanel waypointLocPnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(waypointLocPnl);
        gb.addRow(Intl.intl("Location:"), new RoomLocPanel<OccTargetBuilder>((props, room, normal, loc) -> props.setLocation((IEgressOccupiable)room, (Vector3d)normal, loc.getPoint3dValue(Geometry.LENGTH_UNIT)), props -> new UnitPoint3D(props.get(OccTarget.LOCATION), Geometry.LENGTH_UNIT), OccTarget.LOCATION));
        guiPanel propPnl = new guiPanel();
        gb = new GridBagHelper(propPnl);
        gb.d_rowSpace = 1;
        gb.addRow(orientLbl, this.d_orientFld, 1.0);
        gb.addRow(priorityLbl, this.d_priorityFld, 1.0);
        this.addSection(waypointLocPnl);
        this.addSeparator();
        this.addSection(propPnl);
        this.addSeparator();
        this.addSection(new CreatePanel());
    }

    @Override
    protected void updateFromProps(OccTargetBuilder props) {
        this.d_orientFld.setValue(props.get(OccTarget.ORIENT));
        this.d_priorityFld.setValue(props.get(OccTarget.PRIORITY));
    }

    @Override
    protected void updateToProps(OccTargetBuilder props) {
        props.set(OccTarget.ORIENT, this.d_orientFld.getValue());
        props.set(OccTarget.PRIORITY, this.d_priorityFld.getValue());
    }

    private static class CreatePanel
    extends APropEditPanel<OccTargetBuilder> {
        private static final long serialVersionUID = 1L;
        private final JButton d_createBtn = this.initButton(new JButton(Intl.intl("Create")), (c, hardValidate) -> {
            if (!this.validateData(hardValidate, hardValidate)) {
                return;
            }
            ((OccTargetBuilder)this.props()).create(c);
        });

        public CreatePanel() {
            super(new Object[0]);
            this.add(this.d_createBtn);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.d_createBtn.setEnabled(((OccTargetBuilder)this.props()).isValid());
        }
    }
}

