/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.builders.CorridorBuilder;
import merlin.builders.CorridorUtil;
import merlin.data.egress.geom.EgressCorridor;
import merlin.geom.Geometry;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditCommand;
import merlin.gui.MerlinUDF;
import merlin.mv.gui.LocationPanel;
import merlin.util.MerlinProps;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;

public class NewCorridorPanel<T extends CorridorBuilder>
extends APropEditPanel<T> {
    private static final long serialVersionUID = 77256124568028896L;
    private CorridorBuilder.Mode d_mode;

    public NewCorridorPanel(CorridorBuilder.Mode mode, List<? extends APropEditPanel<T>> addnlPanels, List<? extends ITermInfo> termInfos) {
        super(new Object[0]);
        this.d_mode = mode;
        ArrayList<APropEditPanel<T>> panels = new ArrayList<APropEditPanel<T>>();
        if (this.d_mode == CorridorBuilder.Mode.ONE_POINT) {
            panels.add(new Loc1Panel());
        } else {
            panels.add(new Loc1Panel(Intl.intl("X1"), Intl.intl("Y1"), Intl.intl("Z1")));
            panels.add(new Loc2Panel());
        }
        panels.add(null);
        panels.add(new WidthPanel());
        for (APropEditPanel<T> aPropEditPanel : addnlPanels) {
            panels.add(null);
            panels.add(aPropEditPanel);
        }
        if (this.d_mode == CorridorBuilder.Mode.ONE_POINT) {
            panels.add(null);
            panels.add(new TerminationPanel(termInfos));
        }
        panels.add(null);
        panels.add(new CreatePanel());
        for (APropEditPanel<Object> aPropEditPanel : panels) {
            if (aPropEditPanel == null) {
                this.addSeparator();
                continue;
            }
            this.addSection(aPropEditPanel);
        }
    }

    private static UnitPoint3D convert(Point3d p) {
        return p == null ? null : new UnitPoint3D(p.x, p.y, p.z, Geometry.LENGTH_UNIT);
    }

    private static Point3d convert(UnitPoint3D p) {
        return p == null ? null : p.getValue(Geometry.LENGTH_UNIT);
    }

    protected List<ATermInfo<? extends CorridorUtil.ITermCriteria, guiUnitDoubleField>> getTermInfos() {
        return Arrays.asList(new RunTerm(), new RiseTerm(), new LengthTerm());
    }

    private class TerminationPanel
    extends APropEditPanel<T> {
        private static final long serialVersionUID = 5191817556612448019L;
        private final List<? extends ITermInfo> d_termInfos;
        private final List<guiRadioButton> d_rButtons;

        public TerminationPanel(List<? extends ITermInfo> termInfos) {
            super(CorridorBuilder.TERM_CRITERIA_CHANGED);
            this.d_termInfos = termInfos;
            this.d_rButtons = new ArrayList<guiRadioButton>(termInfos.size());
            for (ITermInfo iTermInfo : termInfos) {
                guiRadioButton btn = this.initButton(new guiRadioButton(iTermInfo.getDesc()), new IPropEditCommand[0]);
                this.d_rButtons.add(btn);
                LinkStatus.link((AbstractButton)btn, new Component[]{iTermInfo.getComponent()});
                if (!(iTermInfo.getComponent() instanceof guiValueField)) continue;
                this.initValueField((guiValueField)iTermInfo.getComponent(), new IPropEditCommand[0]);
            }
            new guiButtonGroup(this.d_rButtons.toArray(new guiRadioButton[this.d_rButtons.size()]));
            this.d_rButtons.get(0).setSelected(true);
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 3;
            int n = (int)Math.ceil(Math.sqrt(this.d_termInfos.size()));
            int numCols = (int)Math.ceil((double)this.d_termInfos.size() / (double)n);
            assert (n * numCols >= this.d_termInfos.size());
            int remaining = this.d_termInfos.size();
            for (int row = 0; row < n; ++row) {
                int offset = this.d_termInfos.size() - remaining;
                int count = Math.min(remaining, numCols);
                for (int col = 0; col < count; ++col) {
                    gb.d_colSpace = 9;
                    gb.addCol((Component)this.d_rButtons.get(offset + col), new Object[0]);
                    gb.d_colSpace = 3;
                    gb.addCol((Component)this.d_termInfos.get(offset + col).getComponent(), new Object[0]);
                }
                gb.nextRow();
                remaining -= count;
            }
        }

        @Override
        protected void updateToProps(T props) {
            assert (((CorridorBuilder)props).getMode() == CorridorBuilder.Mode.ONE_POINT);
            CorridorUtil.ITermCriteria term = null;
            for (int m = 0; m < this.d_rButtons.size(); ++m) {
                if (!this.d_rButtons.get(m).isSelected()) continue;
                term = (CorridorUtil.ITermCriteria)this.d_termInfos.get(m).save(NewCorridorPanel.this);
                break;
            }
            if (term != null) {
                ((CorridorBuilder)props).setTermCriteria(term);
            }
        }

        @Override
        protected void updateFromProps(T props) {
            assert (((CorridorBuilder)props).getMode() == CorridorBuilder.Mode.ONE_POINT);
            CorridorUtil.ITermCriteria term = ((CorridorBuilder)props).getTermCriteria();
            for (int m = 0; m < this.d_termInfos.size(); ++m) {
                ITermInfo ti = this.d_termInfos.get(m);
                if (!ti.getType().isInstance(term)) continue;
                this.d_rButtons.get(m).setSelected(true);
                ti.load(term);
            }
        }
    }

    protected static class LengthTerm
    extends ATermInfo<CorridorUtil.LengthTermCrit, guiUnitDoubleField> {
        public LengthTerm() {
            super(CorridorUtil.LengthTermCrit.class, new MerlinUDF(5.0, DoubleVR.above(0.0, false), SI.METER), Intl.intl("Total Length:"));
            ((guiUnitDoubleField)this.getComponent()).setColumns(6);
        }

        @Override
        public CorridorUtil.LengthTermCrit save(NewCorridorPanel<?> pnl) {
            return new CorridorUtil.LengthTermCrit(((UnitDouble)((guiUnitDoubleField)this.getComponent()).getValue()).getValue(Geometry.LENGTH_UNIT));
        }

        @Override
        public void load(CorridorUtil.LengthTermCrit crit) {
            ((guiUnitDoubleField)this.getComponent()).setValue(new UnitDouble(crit.d_maxLength, Geometry.LENGTH_UNIT));
        }
    }

    protected static class RunTerm
    extends ATermInfo<CorridorUtil.RunTermCrit, guiUnitDoubleField> {
        public RunTerm() {
            super(CorridorUtil.RunTermCrit.class, new MerlinUDF(5.0, DoubleVR.above(0.0, false), SI.METER), Intl.intl("Total Run:"));
            ((guiUnitDoubleField)this.getComponent()).setColumns(6);
        }

        @Override
        public CorridorUtil.RunTermCrit save(NewCorridorPanel<?> pnl) {
            return new CorridorUtil.RunTermCrit(((UnitDouble)((guiUnitDoubleField)this.getComponent()).getValue()).getValue(Geometry.LENGTH_UNIT));
        }

        @Override
        public void load(CorridorUtil.RunTermCrit crit) {
            ((guiUnitDoubleField)this.getComponent()).setValue(new UnitDouble(crit.d_maxRun, Geometry.LENGTH_UNIT));
        }
    }

    protected static class RiseTerm
    extends ATermInfo<CorridorUtil.RiseTermCrit, guiUnitDoubleField> {
        public RiseTerm() {
            super(CorridorUtil.RiseTermCrit.class, new MerlinUDF(3.0, DoubleVR.above(0.0, false), SI.METER), Intl.intl("Total Rise:"));
            ((guiUnitDoubleField)this.getComponent()).setColumns(6);
        }

        @Override
        public CorridorUtil.RiseTermCrit save(NewCorridorPanel<?> pnl) {
            return new CorridorUtil.RiseTermCrit(((UnitDouble)((guiUnitDoubleField)this.getComponent()).getValue()).getValue(Geometry.LENGTH_UNIT));
        }

        @Override
        public void load(CorridorUtil.RiseTermCrit crit) {
            ((guiUnitDoubleField)this.getComponent()).setValue(new UnitDouble(crit.d_rise, Geometry.LENGTH_UNIT));
        }
    }

    protected static abstract class ATermInfo<T extends CorridorUtil.ITermCriteria, CompT extends JComponent>
    implements ITermInfo<T, CompT> {
        private final Class<T> d_type;
        private final CompT d_component;
        private final String d_desc;

        public ATermInfo(Class<T> type, CompT component, String desc) {
            this.d_type = type;
            this.d_component = component;
            this.d_desc = desc;
        }

        @Override
        public Class<T> getType() {
            return this.d_type;
        }

        @Override
        public CompT getComponent() {
            return this.d_component;
        }

        @Override
        public String getDesc() {
            return this.d_desc;
        }
    }

    protected static interface ITermInfo<TermT extends CorridorUtil.ITermCriteria, CompT extends JComponent> {
        public CompT getComponent();

        public void load(TermT var1);

        public TermT save(NewCorridorPanel<?> var1);

        public Class<TermT> getType();

        public String getDesc();
    }

    private class WidthPanel
    extends APropEditPanel<T> {
        private static final long serialVersionUID = 2533143350567124026L;
        private final guiUnitDoubleField d_width;
        private final guiUnitDoubleField d_door1Width;
        private final guiUnitDoubleField d_door2Width;

        public WidthPanel() {
            super(CorridorBuilder.WIDTH_CHANGED, CorridorBuilder.DOOR1_WIDTH_CHANGED, CorridorBuilder.DOOR2_WIDTH_CHANGED);
            this.d_width = this.initValueField(new MerlinUDF(48.0, NonSI.INCH), new IPropEditCommand[0]);
            this.d_door1Width = this.initValueField(new MerlinUDF(1.0, NonSI.INCH), new IPropEditCommand[0]);
            this.d_door1Width.aliasValue(EgressCorridor.DOOR_STAIR_WIDTH, Intl.intl("WIDTH"), "");
            this.d_door1Width.setValue(EgressCorridor.DOOR_STAIR_WIDTH);
            this.d_door2Width = this.initValueField(new MerlinUDF(1.0, NonSI.INCH), new IPropEditCommand[0]);
            this.d_door2Width.aliasValue(EgressCorridor.DOOR_STAIR_WIDTH, Intl.intl("WIDTH"), "");
            this.d_door2Width.setValue(EgressCorridor.DOOR_STAIR_WIDTH);
            this.d_width.setColumns(9);
            this.d_door1Width.setColumns(9);
            this.d_door2Width.setColumns(9);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Width:"), this.d_width);
            gb.addRow(Intl.intl("Door1 Width:"), this.d_door1Width);
            gb.addRow(Intl.intl("Door2 Width:"), this.d_door2Width);
        }

        @Override
        protected void updateToProps(T props) {
            ((MerlinProps)props).pause();
            ((CorridorBuilder)props).setWidth((UnitDouble)this.d_width.getValue());
            ((CorridorBuilder)props).setDoor1Width((UnitDouble)this.d_door1Width.getValue());
            ((CorridorBuilder)props).setDoor2Width((UnitDouble)this.d_door2Width.getValue());
            ((MerlinProps)props).resume();
        }

        @Override
        protected void updateFromProps(T props) {
            this.d_width.setValue(((CorridorBuilder)props).getWidth());
            this.d_door1Width.setValue(((CorridorBuilder)props).getDoor1Width());
            this.d_door2Width.setValue(((CorridorBuilder)props).getDoor2Width());
        }
    }

    private class Loc2Panel
    extends LocationPanel<T> {
        private static final long serialVersionUID = -7287101301568951894L;

        public Loc2Panel() {
            super(Intl.intl("X2"), Intl.intl("Y2"), Intl.intl("Z2"), CorridorBuilder.POINT_SET);
        }

        @Override
        public void updateFromProps(T props) {
            assert (((CorridorBuilder)props).getMode() == CorridorBuilder.Mode.TWO_POINT);
            UnitPoint3D p2 = NewCorridorPanel.convert(((CorridorBuilder)props).getPoint(2));
            if (p2 != null) {
                this.setValue(p2);
            }
        }

        @Override
        public void updateToProps(T props) {
            assert (((CorridorBuilder)props).getMode() == CorridorBuilder.Mode.TWO_POINT);
            UnitPoint3D p2 = this.getValue();
            ((CorridorBuilder)props).setPoint(2, NewCorridorPanel.convert(p2), true);
        }
    }

    private class Loc1Panel
    extends LocationPanel<T> {
        private static final long serialVersionUID = -3100574267636535930L;

        public Loc1Panel() {
            this(Intl.intl("X"), Intl.intl("Y"), Intl.intl("Z"));
        }

        public Loc1Panel(String x, String y, String z) {
            super(x, y, z, CorridorBuilder.POINT_SET);
        }

        @Override
        public void updateFromProps(T props) {
            UnitPoint3D p0 = NewCorridorPanel.convert(((CorridorBuilder)props).getPoint(0));
            if (p0 != null) {
                this.setValue(p0);
            }
        }

        @Override
        public void updateToProps(T props) {
            ((CorridorBuilder)props).setPoint(0, NewCorridorPanel.convert(this.getValue()), true);
        }
    }

    private class CreatePanel
    extends APropEditPanel<T> {
        private static final long serialVersionUID = -2778841604605314061L;
        private final JButton d_createButton;

        public CreatePanel() {
            super(CorridorBuilder.VALIDITY_CHANGES);
            this.d_createButton = new JButton(Intl.intl("Create"));
            this.d_createButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((CorridorBuilder)CreatePanel.this.props()).finish(CreatePanel.this.d_createButton);
                }
            });
            this.add(this.d_createButton);
        }

        @Override
        public void updateFromProps(T props) {
            this.d_createButton.setEnabled(((CorridorBuilder)props).isValid());
        }

        @Override
        public void updateToProps(T props) {
        }
    }
}

