/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.util.Observable;
import java.util.function.BiFunction;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.builders.AttractorBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.geom.Geometry;
import merlin.gui.APropEditPanel;
import merlin.gui.AttractorBehaviorChooser;
import merlin.gui.IPropEditCommand;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.gui.RoomChooser;
import merlin.gui.guiUtil;
import merlin.gui.stat.CompactCurvePnl;
import merlin.mv.gui.RoomLocPanel;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Pair;

public class NewAttractorPanel
extends APropEditPanel<AttractorBuilder> {
    private static final long serialVersionUID = 1L;
    private final guiPanel d_locPnl;
    private final JSeparator d_locSep;
    private final guiComboBox<Attractor.Awareness> d_awarenessCB;
    private final guiLabel d_radiusLbl;
    private final MerlinUDF d_radiusFld;
    private final MerlinUDF d_influenceFld;
    private final MerlinComboBox<Behavior> d_behaviorsCB;
    private final guiLabel d_waitTimeLbl;
    private final CompactCurvePnl d_waitTimeFld;
    private final guiLabel d_waitRadiusLbl;
    private final MerlinUDF d_waitRadiusFld;
    private final guiLabel d_roomsLbl;
    private final RoomChooser d_roomsChooser;

    public NewAttractorPanel(MerlinData md) {
        super(Attractor.INFLUENCE_RADIUS, Attractor.BEHAVIOR, Attractor.WAIT_TIME, Attractor.WAIT_RADIUS, Attractor.INFLUENCE, Attractor.AWARENESS);
        BiFunction<String, String, guiLabel> lbl = (desc, tt) -> guiUtil.lbl(desc, tt);
        this.d_awarenessCB = this.initComboBox(guiUtil.newCombo(awareness -> new Pair<String, String>(guiUtil.encodeToHtmlLabel(awareness.name), guiUtil.encodeToHtmlLabel(awareness.desc)), Attractor.Awareness.values()));
        this.d_radiusLbl = lbl.apply(Intl.intl("Influence Radius:"), Intl.intl("The maximum distance at which the attractor will influence occupants."));
        this.d_radiusFld = this.initValueField(new MerlinUDF(0, DoubleVR.above(0.0, true)), new IPropEditCommand[0]);
        this.d_radiusFld.setColumns(8);
        this.d_influenceFld = this.initValueField(new MerlinUDF(10, DoubleVR.above(0.0, true)), new IPropEditCommand[0]);
        this.d_influenceFld.setColumns(8);
        this.d_roomsLbl = lbl.apply(Intl.intl("Rooms:"), Intl.intl("The rooms in which an occupant is aware of the attractor."));
        this.d_roomsChooser = new RoomChooser(md);
        this.d_roomsChooser.addPropertyChangeListener("edit", e -> {
            if (((Boolean)e.getNewValue()).booleanValue()) {
                this.componentModified(this.d_roomsChooser, true);
            }
        });
        this.d_behaviorsCB = this.initComboBox(new AttractorBehaviorChooser(md));
        this.d_waitTimeFld = new CompactCurvePnl(Intl.intl("Wait Time"), 1, UnitDoubleVR.above(0.0, SI.SECOND, true));
        this.d_waitTimeLbl = lbl.apply(Intl.intl("Wait Time:"), Intl.intl("The amount of time to wait at the attractor."));
        this.d_waitRadiusFld = this.initValueField(new MerlinUDF(0, DoubleVR.above(0.0, false)), new IPropEditCommand[0]);
        this.d_waitRadiusFld.setColumns(8);
        this.d_waitRadiusLbl = guiUtil.lbl(Intl.intl("Wait Area Radius:"), Intl.intl("Defines the radius of the wait area for the attractor."));
        this.d_locPnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(this.d_locPnl);
        gb.addRow(Intl.intl("Location:"), new RoomLocPanel<AttractorBuilder>((props, room, normal, loc) -> props.setLocation((IEgressOccupiable)room, (Vector3d)normal, loc.getPoint3dValue(Geometry.LENGTH_UNIT)), props -> new UnitPoint3D(props.get(Attractor.LOCATION), Geometry.LENGTH_UNIT), Attractor.LOCATION));
        guiPanel propsPnl = new guiPanel();
        gb = new GridBagHelper(propsPnl);
        gb.d_rowSpace = 1;
        gb.addRow(lbl.apply(Intl.intl("Awareness:"), Intl.intl("Defines how an occupant becomes aware of the attractor.")), this.d_awarenessCB, 1.0);
        gb.addRow(this.d_radiusLbl, this.d_radiusFld, 1.0);
        gb.addRow(this.d_roomsLbl, this.d_roomsChooser, 1.0);
        gb.addRow(lbl.apply(Intl.intl("Influence:"), "<html>" + Intl.intl("The influence of this attractor. This is multiplied by an<br>occupant's susceptibility to attractors to create a probability<br>that this attractor will influence the occupant.")), this.d_influenceFld, 1.0);
        guiPanel behaviorPnl = new guiPanel();
        gb = new GridBagHelper(behaviorPnl);
        gb.d_rowSpace = 1;
        guiLabel behaviorLbl = lbl.apply(Intl.intl("Behavior:"), Intl.intl("The behavior that occupants will use when influenced by this attractor."));
        gb.addRow(behaviorLbl, this.d_behaviorsCB, 1.0);
        gb.addRow(this.d_waitRadiusLbl, this.d_waitRadiusFld, 1.0);
        gb.addRow(this.d_waitTimeLbl, this.d_waitTimeFld, 1.0);
        this.addSection(this.d_locPnl);
        this.d_locSep = this.addSeparator();
        this.addSection(propsPnl);
        this.addSeparator();
        this.addSection(behaviorPnl);
        this.addSeparator();
        this.addSection(new CreatePanel());
        this.d_waitTimeFld.addValueListener(e -> this.getUpdateToCommand().updateProp(this.d_waitTimeFld, true));
    }

    @Override
    protected void updateFromProps(AttractorBuilder props) {
        this.d_awarenessCB.setSelectedItem((Object)props.get(Attractor.AWARENESS));
        boolean locVis = Attractor.requiresLocation(props);
        this.d_locPnl.setVisible(locVis);
        this.d_locSep.setVisible(locVis);
        boolean radiusVis = props.get(Attractor.AWARENESS) == Attractor.Awareness.LINE_OF_SIGHT;
        this.d_radiusLbl.setVisible(radiusVis);
        this.d_radiusFld.setVisible(radiusVis);
        this.d_radiusFld.setValue(props.get(Attractor.INFLUENCE_RADIUS));
        this.d_influenceFld.setValue(props.get(Attractor.INFLUENCE));
        this.d_behaviorsCB.setSelectedItem(props.get(Attractor.BEHAVIOR));
        boolean waitTimeVis = props.get(Attractor.BEHAVIOR) == Attractor.WAIT_AT_ATTRACTOR_BEHAVIOR;
        this.d_waitRadiusLbl.setVisible(waitTimeVis);
        this.d_waitRadiusFld.setVisible(waitTimeVis);
        this.d_waitRadiusFld.setValue(props.get(Attractor.WAIT_RADIUS));
        this.d_waitTimeLbl.setVisible(waitTimeVis);
        this.d_waitTimeFld.setVisible(waitTimeVis);
        this.d_waitTimeFld.setValue(props.get(Attractor.WAIT_TIME));
        this.d_roomsChooser.setObjs(props.get(Attractor.ROOMS));
        boolean roomsVis = props.get(Attractor.AWARENESS) == Attractor.Awareness.ROOMS;
        this.d_roomsLbl.setVisible(roomsVis);
        this.d_roomsChooser.setVisible(roomsVis);
    }

    @Override
    protected void updateToProps(AttractorBuilder props) {
        props.set(Attractor.AWARENESS, this.d_awarenessCB.getSelectedItem());
        props.set(Attractor.INFLUENCE_RADIUS, this.d_radiusFld.getValue());
        props.set(Attractor.INFLUENCE, this.d_influenceFld.getValue());
        props.set(Attractor.BEHAVIOR, this.d_behaviorsCB.getSelectedItem());
        props.set(Attractor.WAIT_RADIUS, this.d_waitRadiusFld.getValue());
        props.set(Attractor.WAIT_TIME, this.d_waitTimeFld.getValue());
        props.set(Attractor.ROOMS, this.d_roomsChooser.getObjs());
    }

    private static class CreatePanel
    extends APropEditPanel<AttractorBuilder> {
        private static final long serialVersionUID = 1L;
        private final JButton d_createBtn = this.initButton(new JButton(Intl.intl("Create")), (c, hardValidate) -> {
            if (!this.validateData(hardValidate, hardValidate)) {
                return;
            }
            ((AttractorBuilder)this.props()).create(c);
        });

        public CreatePanel() {
            super(new Object[0]);
            this.add(this.d_createBtn);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.d_createBtn.setEnabled(((AttractorBuilder)this.props()).isValid());
        }
    }
}

