/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.util.Collection;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressComp;
import merlin.mv.displays.IMerlinDispMgr;
import merlin.mv.displays.NavMeshTriDisplay;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Sets;

public class NavMeshTriDispMgr
implements IMerlinDispMgr<Object> {
    private final MerlinData d_data;
    private final NavMeshTriDisplay d_display;
    private boolean d_visible = false;
    private boolean d_dirty = true;

    public NavMeshTriDispMgr(MerlinData data, ModelScene scene) {
        this.d_data = data;
        this.d_display = new NavMeshTriDisplay();
        this.d_display.setVisible(this.d_visible);
        scene.addRenderableObjects(this.d_display);
    }

    public void setVisible(boolean visible) {
        if (visible == this.d_visible) {
            return;
        }
        this.d_visible = visible;
        this.update();
        this.d_display.setVisible(this.d_visible);
    }

    public void setSelected(boolean selected) {
    }

    @Override
    public void update(Events events) {
        for (EventChannel<MerlinData> eventChannel : events.getAffectedChannels(MerlinData.class, new Class[0])) {
            if (!eventChannel.containsChange(MerlinData.MESH_CHANGED)) continue;
            this.d_dirty = true;
            break;
        }
        for (EventChannel<IMerlinObj> eventChannel : events.getAffectedChannels(IEgressComp.class, new Class[0])) {
            if (!eventChannel.getAddedObjs().isEmpty() || !eventChannel.getRemovedObjs().isEmpty()) {
                this.d_dirty = true;
                continue;
            }
            IdentityHashSet<Object> irrChanges = Sets.fromArrayIHS(MerlinData.SELECTION_CHANGED);
            if (eventChannel.areChangesExclusiveTo(irrChanges)) continue;
            this.d_dirty = true;
        }
        this.update();
    }

    @Override
    public void updateAll() {
        this.d_dirty = true;
        this.update();
    }

    public void update() {
        if (this.d_dirty) {
            if (this.d_visible) {
                this.regenerateDisplay();
            } else {
                this.d_display.resetData();
            }
        }
    }

    private void regenerateDisplay() {
        this.d_display.regenerateDisplay(this.d_data);
        this.d_dirty = false;
    }

    public Object getSelectionObj() {
        return null;
    }

    @Override
    public Predicate<Object> getFilter() {
        return Filters.rejectAll();
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }

    @Override
    public void removeAll() {
    }

    @Override
    public void addDisplays(Collection<? extends Object> objs) {
    }

    @Override
    public void updateDisplays(Collection<? extends Object> objs) {
    }

    @Override
    public void removeDisplays(Collection<? extends Object> objs) {
    }

    @Override
    public void removeFromScene(Collection<? extends Object> obj) {
    }

    @Override
    public void addToScene(Collection<? extends Object> obj) {
    }

    @Override
    public void setTransform(Matrix4d xform) {
    }
}

