/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.Snappers;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theObservable;

public class GridSnapper
extends theObservable
implements IMerlinGeomSrc {
    private UnitDouble d_spacing;
    private boolean d_visible = true;
    private boolean d_originOnly = false;

    public GridSnapper(UnitDouble spacing) {
        this.d_spacing = spacing;
    }

    public void setOriginOnly(boolean originOnly) {
        this.d_originOnly = originOnly;
        this.changed();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void changed() {
        this.setChanged();
        this.tryFireNotification();
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_visible = visible;
        this.changed();
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    public void setSpacing(UnitDouble spacing) {
        this.d_spacing = spacing;
        this.changed();
    }

    public UnitDouble getSpacing() {
        return this.d_spacing;
    }

    @Override
    public AABox getBounds() {
        return null;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.EMPTY_NODE;
    }

    @Override
    public void setGeom(IGeomNode geom) {
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull region) {
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        boolean edges = filter.acceptGeomType(this, GeomType.EDGE);
        boolean verts = filter.acceptGeomType(this, GeomType.VERTEX);
        if (!edges && !verts) {
            return;
        }
        int axis = Util3D.getClosestAxis(rayDirN);
        if (edges) {
            this.getClosestPoints(isects, GeomType.EDGE, axis, rayBegin, rayEnd, rayDirN);
        }
        if (verts) {
            this.getClosestPoints(isects, GeomType.VERTEX, axis, rayBegin, rayEnd, rayDirN);
        }
    }

    private void getClosestPoints(IIsectCollector isects, GeomType type, int axis, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN) {
        switch (axis) {
            case 0: {
                isects.addInfinite(this, this.getXPlaneSnapPoint(type, rayBegin, rayEnd, rayDirN), type, null);
                break;
            }
            case 1: {
                isects.addInfinite(this, this.getYPlaneSnapPoint(type, rayBegin, rayEnd, rayDirN), type, null);
                break;
            }
            case 2: {
                isects.addInfinite(this, this.getZPlaneSnapPoint(type, rayBegin, rayEnd, rayDirN), type, null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Point3d getXPlaneSnapPoint(GeomType snapType, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN) {
        Point3d isect = new Point3d();
        if (!Inter3D.lineXPlaneIntersection(isect, rayBegin, rayDirN, 0.0, 0.0)) {
            return null;
        }
        Point2d localSnap = this.getPlaneSnapPoint(snapType, isect.y, isect.z);
        return localSnap == null ? null : new Point3d(isect.x, localSnap.x, localSnap.y);
    }

    public Point3d getYPlaneSnapPoint(GeomType snapType, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN) {
        Point3d isect = new Point3d();
        if (!Inter3D.lineYPlaneIntersection(isect, rayBegin, rayDirN, 0.0, 0.0)) {
            return null;
        }
        Point2d localSnap = this.getPlaneSnapPoint(snapType, isect.x, isect.z);
        return localSnap == null ? null : new Point3d(localSnap.x, isect.y, localSnap.y);
    }

    public Point3d getZPlaneSnapPoint(GeomType snapType, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN) {
        Point3d isect = new Point3d();
        if (!Inter3D.lineZPlaneIntersection(isect, rayBegin, rayDirN, 0.0, 0.0)) {
            return null;
        }
        Point2d localSnap = this.getPlaneSnapPoint(snapType, isect.x, isect.y);
        return localSnap == null ? null : new Point3d(localSnap.x, localSnap.y, isect.z);
    }

    private Point2d getPlaneSnapPoint(GeomType snapType, double x, double y) {
        double y2;
        double spacing = this.getSpacing().getValue(Geometry.LENGTH_UNIT);
        double x2 = this.d_originOnly ? 0.0 : (double)Math.round(x / spacing) * spacing;
        double d = y2 = this.d_originOnly ? 0.0 : (double)Math.round(y / spacing) * spacing;
        if (snapType == GeomType.VERTEX) {
            return new Point2d(x2, y2);
        }
        double dx = x - x2;
        double xDistSq = dx * dx;
        double dy = y - y2;
        double yDistSq = dy * dy;
        if (xDistSq <= yDistSq) {
            return new Point2d(x2, y);
        }
        return new Point2d(x, y2);
    }
}

