/*
 * Decompiled with CFR 0.152.
 */
package merlin.manip;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.TransformAction;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.geom.EgressRoom;
import merlin.util.MerlinProps;
import merlin.util.MerlinUtil;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public abstract class ATransformManip
extends MerlinProps {
    public static final Object SEL_CHANGED = "ATransformManip.SEL_CHANGED";
    public static final Object OBJS_TRANSFORMED = "ATransformManip.OBJS_TRANSFORMED";
    public static final Object CANCELLED = "ATransformManip.CANCELLED";
    public static final Object TRANSFORM_CHANGED = "ATransformManip.TRANSFORM_CHANGED";
    public static final Object COPY_MODE_CHANGED = "ATransformManip.COPY_MODE_CHANGED";
    public static final Object RANDOMIZE_AGENT_COPIES = "RANDOMIZE_AGENT_COPIES";
    private Collection<? extends IMerlinObj> d_selection = Collections.EMPTY_SET;
    private int d_copies = 0;
    private boolean d_randomizeAgentCopies = true;

    public abstract boolean canTransform();

    protected abstract void reset();

    protected abstract ITransform getXform(int var1);

    protected abstract String getActionName();

    public void setSelection(Collection<? extends IMerlinObj> objs) {
        if (!this.lock()) {
            return;
        }
        this.d_selection = objs;
        this.firePropChanged(SEL_CHANGED);
        this.release();
    }

    public Collection<? extends IMerlinObj> getSelection() {
        return this.d_selection;
    }

    public void setNumCopies(int numCopies) {
        if (this.d_copies == numCopies || !this.lock()) {
            return;
        }
        this.d_copies = numCopies;
        this.firePropChanged(COPY_MODE_CHANGED);
        this.release();
    }

    public int getNumCopies() {
        return this.d_copies;
    }

    public void setRandomizeAgentCopies(boolean randomize) {
        if (this.d_randomizeAgentCopies == randomize || !this.lock()) {
            return;
        }
        this.d_randomizeAgentCopies = randomize;
        this.firePropChanged(RANDOMIZE_AGENT_COPIES);
        this.release();
    }

    public boolean getRandomizeAgentCopies() {
        return this.d_randomizeAgentCopies;
    }

    public void cancel() {
        this.reset();
        this.firePropChanged(CANCELLED);
    }

    public void transform(Component c) {
        if (this.d_selection.isEmpty()) {
            this.reset();
            return;
        }
        final TransformInfo[] xforms = new TransformInfo[this.d_copies > 0 ? this.d_copies : 1];
        for (int m = 0; m < xforms.length; ++m) {
            xforms[m] = this.getXform(m).getInfo();
        }
        final String actionName = this.getActionName();
        final ArrayList<? extends IMerlinObj> objs = new ArrayList<IMerlinObj>(this.d_selection);
        final int numCopies = this.d_copies;
        final boolean randomizeAgentCopies = this.d_randomizeAgentCopies;
        this.reset();
        AMerlinOp op = new AMerlinOp(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(MerlinApp app, MerlinData data) {
                data.beginWrite();
                try {
                    String name = numCopies > 0 ? Intl.intl("Copy") + "/" + actionName : actionName;
                    Undo.begin(name);
                    ArrayList newRooms = new ArrayList();
                    List<List<IMerlinObj>> copies = TransformAction.transform(MerlinApp.getApp(), data, newRooms::add, objs, numCopies, xforms);
                    if (numCopies > 0 && randomizeAgentCopies) {
                        for (List<IMerlinObj> objs2 : copies) {
                            for (EgressAgent agent : MerlinUtil.flatten(objs2, EgressAgent.class)) {
                                agent.newProfileSeed();
                            }
                        }
                    }
                    data.updateTopology();
                    newRooms.forEach(EgressRoom::cleanupModel);
                    Undo.end(data);
                }
                finally {
                    data.endWrite();
                }
            }
        };
        UIHook.run(c, "ATransformManip.transform", op, 4);
        this.firePropChanged(OBJS_TRANSFORMED);
    }
}

