/*
 * Decompiled with CFR 0.152.
 */
package merlin.io;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.io.MerlinOIS;
import merlin.io.MerlinOOS;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.IWarning;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.WarningReport;

public class MerlinIO {
    public static final int FS_OPTIONS = 3;
    public static final int TECI_VERSION = 18;
    private boolean d_topologyResetNeeded = false;

    public boolean isTopologyResetNeeded() {
        return this.d_topologyResetNeeded;
    }

    public static void writeModel(String filename, MerlinData md) throws IOException {
        try (MerlinOOS oos = new MerlinOOS(new BufferedOutputStream(new FileOutputStream(filename)));){
            oos.writeModel(md);
        }
    }

    public OpenResult openModel(Component parent, String filename, Consumer<TaskProgress> showSkippableProgress, MerlinOIS.DecisionMaker decisions) throws IOException, CancelledException, BadVersionException {
        MerlinOIS ois = null;
        try {
            int option;
            FileInputStream fis = new FileInputStream(filename);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ois = new MerlinOIS(bis, showSkippableProgress);
            if (!ois.canOpenVersion()) {
                String msg = String.format(Intl.intl("The file was made with an old version of %s."), "Pathfinder");
                throw new BadVersionException(msg, false);
            }
            if (ois.isNewer() && (option = JOptionPane.showConfirmDialog(parent, String.format(Intl.intl("This file was created with %s, which is newer\nthan this version.  Would you like to try to open it anyway?\nNOTE: Some newer features may be lost if the file is resaved."), "Pathfinder " + ois.getRevision()), String.format(Intl.intl("Newer %s File"), "Pathfinder"), 0)) != 0) {
                throw new CancellationException();
            }
            MerlinData md = ois.readModel(decisions);
            this.d_topologyResetNeeded = ois.isTopologyResetNeeded();
            OpenResult openResult = new OpenResult(md, ois.getWarnings());
            return openResult;
        }
        catch (CancellationException e) {
            throw new CancelledException();
        }
        catch (Throwable t) {
            if (ois != null && ois.isNewer()) {
                String msg = String.format(Intl.intl("The file was made with a newer version of %s."), "Pathfinder");
                throw new BadVersionException(msg, true);
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static class BadVersionException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final boolean tooNew;

        public BadVersionException(String msg, boolean tooNew) {
            super(msg);
            this.tooNew = tooNew;
        }
    }

    public static class OpenResult {
        public final MerlinData data;
        public final WarningReport<? extends IWarning> warnings;

        public OpenResult(MerlinData data, WarningReport<? extends IWarning> warnings) {
            this.data = data;
            this.warnings = warnings;
        }
    }

    public static enum Version {
        VER_ALPHA(0),
        VER_0001,
        VER_0002,
        VER_0003,
        VER_0004,
        VER_0005,
        VER_0006,
        VER_0007,
        VER_0008,
        VER_0009("2009.1.0408"),
        VER_0010,
        VER_0011,
        VER_0012("2009.2.1018"),
        VER_0013("Internal"),
        VER_0014("Internal"),
        VER_0015,
        VER_0016("up to 2011.0.0214 (Beta)"),
        VER_0017,
        VER_0018("up through 2011.0.0419 (Beta)"),
        VER_0019,
        VER_0020,
        VER_0021,
        VER_0022,
        VER_0023,
        VER_0024,
        VER_0025,
        VER_0026("2012.1.0802"),
        VER_0027,
        VER_0028,
        VER_0029,
        VER_0030("2013.1.0730"),
        VER_0031,
        VER_0032("2013.1.1011"),
        VER_0033,
        VER_0100,
        VER_0101,
        VER_0102,
        VER_0103,
        VER_0104,
        VER_0105,
        VER_0106,
        VER_0107,
        VER_0108,
        VER_0109,
        VER_0110,
        VER_0111,
        VER_0112,
        VER_0113,
        VER_0114,
        VER_0115,
        VER_0116,
        VER_0117,
        VER_0118,
        VER_0119,
        VER_0120,
        VER_0121,
        VER_0122,
        VER_0123,
        VER_0124,
        VER_0125,
        VER_0126,
        VER_0127,
        VER_0128,
        VER_0129,
        VER_0130,
        VER_0131,
        VER_0132,
        VER_0133,
        VER_0134,
        VER_0135,
        VER_0136,
        VER_0137,
        VER_0138,
        VER_0139,
        VER_0140,
        VER_0141,
        VER_0142,
        VER_0143,
        VER_0144,
        VER_0145,
        VER_0146,
        VER_0147,
        VER_0148,
        VER_0149;

        public final String version;
        public final int num;

        private Version() throws InvalidParameterException {
            this(null, null);
        }

        private Version(Integer num) {
            this(null, num);
        }

        private Version(String version) throws InvalidParameterException {
            this(version, null);
        }

        private Version(String version, Integer num) {
            this.version = version;
            this.num = num != null ? num : Version.parseNum(this.name());
        }

        private static int parseNum(String name) throws InvalidParameterException {
            int idBegin = name.length();
            for (int m = idBegin - 1; m >= 0; --m) {
                if (Character.isDigit(name.charAt(m))) continue;
                idBegin = m + 1;
                break;
            }
            if (idBegin >= name.length()) {
                throw new InvalidParameterException();
            }
            return Integer.parseInt(name.substring(idBegin));
        }

        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }

        public boolean isPrior(Version version) {
            return this.num < version.num;
        }

        public boolean isPrior(int version) {
            return this.num < version;
        }

        public boolean isVersion(Version version) {
            return this.num == version.num;
        }

        public boolean isVersion(int version) {
            return this.num == version;
        }

        public boolean isLater(Version version) {
            return this.num > version.num;
        }

        public boolean isLater(int version) {
            return this.num > version;
        }

        public static Version getVersion(int num) {
            for (Version ver : Version.values()) {
                if (ver.num != num) continue;
                return ver;
            }
            return null;
        }
    }
}

