/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import merlin.Intl;
import merlin.data.value.ConstVariant;
import merlin.data.value.DiscreteVariant;
import merlin.data.value.IVariant;
import merlin.gui.value.DefaultVarEditorPnl;
import merlin.gui.value.IVariantEditor;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class UDVarEditor
implements IVariantEditor<UnitDouble> {
    private final guiFormattedFld<UnitDouble> d_protoField;

    public UDVarEditor(guiFormattedFld<UnitDouble> protoField) {
        this.d_protoField = protoField;
        ((guiFormattedFld.Formatter)this.d_protoField.getFormatter()).setNullAllowed(true);
    }

    @Override
    public String describe(IVariant<UnitDouble> variant) {
        if (variant instanceof ConstVariant) {
            return String.format(Intl.intl("Always %s"), Global.format((UnitDouble)((ConstVariant)variant).value));
        }
        if (variant instanceof DiscreteVariant) {
            DiscreteVariant dvar = (DiscreteVariant)variant;
            return String.format(Intl.intl("t(0) = %s, ..."), MerlinUtil.format((UnitDouble)dvar.initVal, this.getUnitType()));
        }
        return "";
    }

    private IUnitSrc getUnitType() {
        UnitDoubleFormat udFormat = (UnitDoubleFormat)this.d_protoField.getFormat();
        return udFormat.getUnitType();
    }

    @Override
    public guiPanel getEditorPanel(IUnitSrc timeUnit) {
        return DefaultVarEditorPnl.newPnl(timeUnit, UnitDouble.class, this.d_protoField);
    }

    @Override
    public void load(guiPanel editorPanel, IVariant<UnitDouble> variant) {
        DefaultVarEditorPnl epnl = (DefaultVarEditorPnl)editorPanel;
        epnl.load(variant);
    }

    @Override
    public IVariant<UnitDouble> save(guiPanel editorPanel) {
        DefaultVarEditorPnl epnl = (DefaultVarEditorPnl)editorPanel;
        return epnl.save();
    }
}

