/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.data.value.DiscreteVariant;
import merlin.data.value.IVariant;
import merlin.data.value.VariantUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;

public class DefaultVarEditorPnl<ValType>
extends guiPanel {
    private static final long serialVersionUID = 1L;
    private final Map<ValType, String> d_discreteVals;
    private final guiFormattedFld<ValType> d_valFld;
    private final guiComboBox<ValType> d_discreteValCB;
    private final guiTable d_table;

    protected DefaultVarEditorPnl(IUnitSrc timeUnit, Class<ValType> valType, guiFormattedFld<ValType> valFld, final Map<ValType, String> discreteVals) {
        this.d_discreteVals = discreteVals;
        String[] headers = new String[]{Intl.intl("Time"), Intl.intl("Value")};
        Class tblValType = discreteVals.size() > 0 ? AliasedVal.class : valType;
        guiTableEditor ed = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, new Class[]{UnitDouble.class, tblValType}), 30);
        this.d_table = ed.getTable();
        this.d_table.setNullValuesAllowed(false);
        this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(timeUnit.getUnit()));
        if (discreteVals.size() > 0) {
            DefaultListCellRenderer comboBoxRenderer = new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    String alias = (String)discreteVals.get(value);
                    if (alias != null) {
                        this.setText(alias);
                    }
                    return this;
                }
            };
            this.d_table.setColumnOptions(1, this.toValues(discreteVals));
            this.d_discreteValCB = new guiComboBox<ValType>(discreteVals.keySet());
            this.d_discreteValCB.setRenderer(comboBoxRenderer);
            this.d_valFld = null;
        } else {
            assert (valFld != null);
            this.d_discreteValCB = null;
            this.d_valFld = valFld;
            if (UnitDouble.class.isAssignableFrom(valType)) {
                UnitDoubleFormat udFormat = (UnitDoubleFormat)this.d_valFld.getFormat();
                this.d_table.getColumnModel().getColumn(1).setCellEditor(new guiTable.UnitDoubleEditor(udFormat.getUnitType().getUnit()));
            }
        }
        this.d_table.autoSizeColumns(500);
        this.d_table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.d_table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, Math.min(500, this.d_table.getPreferredSize().height)));
        GridBagHelper gb = new GridBagHelper(this);
        JComponent initComp = this.d_valFld != null ? this.d_valFld : this.d_discreteValCB;
        gb.addRow(Intl.intl("Initial Value:"), initComp, 0);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Timed Values")));
        gb.addRow(ed, new double[]{1.0, 1.0}, new int[]{0, 0});
        gb.finalizeRows();
    }

    private List<AliasedVal<ValType>> toValues(Map<ValType, String> map) {
        ArrayList<AliasedVal<ValType>> values = new ArrayList<AliasedVal<ValType>>(map.size());
        for (Map.Entry<ValType, String> entry : map.entrySet()) {
            values.add(new AliasedVal<ValType>(entry.getKey(), entry.getValue()));
        }
        return values;
    }

    public static <ValType> DefaultVarEditorPnl<ValType> newPnl(IUnitSrc timeUnit, Map<ValType, String> discreteVals) {
        assert (!discreteVals.isEmpty());
        Class<?> valType = discreteVals.keySet().iterator().next().getClass();
        return new DefaultVarEditorPnl(timeUnit, valType, null, discreteVals);
    }

    public static <ValType> DefaultVarEditorPnl<ValType> newPnl(IUnitSrc timeUnit, Class<ValType> valType, guiFormattedFld<ValType> initValEditor) {
        return new DefaultVarEditorPnl<ValType>(timeUnit, valType, initValEditor, Collections.EMPTY_MAP);
    }

    private ValType getValue(int row) {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        Object val = model.getValueAt(row, 1);
        return (ValType)(val instanceof AliasedVal ? ((AliasedVal)val).value : val);
    }

    private void setValue(int row, ValType value) {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        Object val = !this.d_discreteVals.isEmpty() ? new AliasedVal<ValType>(value, this.d_discreteVals.get(value)) : value;
        model.setValueAt(val, row, 1);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        Predicate<Object> filter = Filters.acceptAll();
        if (this.d_valFld != null && this.d_valFld.getFilter() != null) {
            filter = this.d_valFld.getFilter();
        }
        if (filter != Filters.acceptAll()) {
            int col = 1;
            int numRows = this.d_table.getModel().getRowCount();
            for (int m = 0; m < numRows; ++m) {
                ValType val = this.getValue(m);
                if (filter.test(val)) continue;
                if (showWarn) {
                    String msg = String.format(Intl.intl("Error in table at row %d, col %d:%n%s"), m + 1, col + 1, filter.toString());
                    JOptionPane.showMessageDialog(this, msg, Intl.intl("Invalid Value"), 2);
                }
                return false;
            }
        }
        return true;
    }

    public void load(IVariant<ValType> var) {
        if (var == null) {
            if (this.d_valFld != null) {
                this.d_valFld.setValue(null);
            } else {
                this.d_discreteValCB.setSelectedIndex(-1);
            }
        } else {
            ValType initValue = VariantUtil.getInitialValue(var);
            List<DiscreteVariant.Entry<ValType>> entries = VariantUtil.getDiscreteValues(var, false);
            if (this.d_valFld != null) {
                this.d_valFld.setValue(initValue);
            } else {
                this.d_discreteValCB.setSelectedItem(initValue);
            }
            guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
            for (int i = 0; i < entries.size(); ++i) {
                DiscreteVariant.Entry<ValType> scriptEvent = entries.get(i);
                model.setValueAt(scriptEvent.t, i, 0);
                this.setValue(i, scriptEvent.val);
            }
        }
        this.setModified(false);
    }

    public IVariant<ValType> save() {
        ValType initVal = this.d_valFld != null ? this.d_valFld.getValue() : this.d_discreteValCB.getSelectedItem();
        if (initVal == null && !this.isNullAllowed()) {
            return null;
        }
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int rows = model.getRowCount();
        ArrayList scriptEvents = new ArrayList(rows);
        for (int i = 0; i < rows; ++i) {
            ValType val;
            UnitDouble t = (UnitDouble)model.getValueAt(i, 0);
            if (t == null || (val = this.getValue(i)) == null && !this.isNullAllowed()) continue;
            scriptEvents.add(new DiscreteVariant.Entry<ValType>(t, val));
        }
        return VariantUtil.newVariant(initVal, scriptEvents);
    }

    private boolean isNullAllowed() {
        return this.d_valFld == null && this.d_discreteVals.containsKey(null);
    }

    private static class AliasedVal<ValType>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final ValType value;
        public final String alias;

        public AliasedVal(ValType value, String alias) {
            this.value = value;
            this.alias = alias;
        }

        public String toString() {
            return this.alias;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof AliasedVal && Objects.equals(((AliasedVal)obj).value, this.value);
        }
    }
}

