/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.JComponent;
import merlin.gui.value.IValEditor;
import thunderheadeng.gui.guiPanel;

public abstract class AValEditor<T>
extends guiPanel
implements IValEditor<T>,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private final Class<T> d_type;
    private T d_value;
    private boolean d_modified = false;

    public AValEditor(Class<T> type) {
        this.d_type = type;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Class<T> getType() {
        return this.d_type;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
        super.setModified(modified);
    }

    @Override
    public boolean isModified() {
        return this.d_modified || super.isModified();
    }

    protected <T2> T2 registerEd(T2 editor) {
        if (editor instanceof Component) {
            ((Component)editor).addPropertyChangeListener("value", this);
        } else if (editor instanceof IValEditor) {
            ((IValEditor)editor).addValueListener(this);
        }
        return editor;
    }

    protected <T2> T2 unregisterEd(T2 editor) {
        if (editor instanceof Component) {
            ((Component)editor).removePropertyChangeListener("value", this);
        } else if (editor instanceof IValEditor) {
            ((IValEditor)editor).removeValueListener(this);
        }
        return editor;
    }

    @Override
    public void setValue(T value) {
        if (Objects.equals(value, this.d_value)) {
            return;
        }
        T oldVal = this.d_value;
        this.d_value = value;
        this.loadValue(this.d_value);
        this.setModified(true);
        this.fireValueChange(oldVal, this.d_value);
    }

    @Override
    public T getValue() {
        return this.d_value;
    }

    protected abstract void loadValue(T var1);

    protected abstract T saveValue();

    protected void updateValue() {
        if (this.validateData(false, false)) {
            this.setValue(this.saveValue());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateValue();
    }

    protected void fireValueChange(T oldValue, T newValue) {
        this.firePropertyChange("value", oldValue, newValue);
    }
}

