/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.mv.ModelView;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.TeciProps;

public class SnapshotDialog
extends guiDialog {
    private static final long serialVersionUID = 8572283065869303522L;
    private final ModelView d_mv;
    private final JRadioButton d_snapshotButton;
    private final JRadioButton d_povrayButton;
    private final JCheckBox d_antiAlias;
    private final JCheckBox d_shadows;
    private final JCheckBox d_povFile;
    private final TitleSeparator d_exportTypeTitle;
    private guiFileChooser d_filenameChooser;
    private final guiPanel d_dlgPanel;
    private final guiTextField d_filenameField;
    private final JButton d_filenameButton;
    private guiIntField d_widthField;
    private guiIntField d_heightField;
    private final JButton d_useWindowSizeButton;
    private ExampleFileFilter d_filterJpeg;
    private ExampleFileFilter d_filterPng;
    private ExampleFileFilter d_filterBmp;
    private ExampleFileFilter d_filterTiff;
    private ExampleFileFilter d_filterTarga;
    private ExampleFileFilter d_filterGif;
    private ExampleFileFilter d_filterPpm;

    public SnapshotDialog(JFrame owner, ModelView mv) {
        super((Window)owner, Intl.intl("Snapshot Properties"), 9);
        this.d_mv = mv;
        this.d_dlgPanel = super.getDialogPane();
        this.d_dlgPanel.setLayout(new GridBagLayout());
        this.d_filenameField = new guiTextField("");
        this.d_filenameButton = new JButton(Intl.intl("Browse") + "...");
        this.d_snapshotButton = new JRadioButton(Intl.intl("PyroSim"));
        this.d_povrayButton = new JRadioButton(Intl.intl("POV-Ray"));
        this.d_antiAlias = new JCheckBox(Intl.intl("Anti-alias"));
        this.d_shadows = new JCheckBox(Intl.intl("Shadows"));
        this.d_povFile = new JCheckBox(Intl.intl("Export POV File"));
        this.d_exportTypeTitle = new TitleSeparator(Intl.intl("Render Program"));
        this.d_filenameChooser = new guiFileChooser();
        this.d_widthField = new guiIntField();
        this.d_heightField = new guiIntField();
        this.d_useWindowSizeButton = new JButton(Intl.intl("Use window size"));
        this.d_filterJpeg = new ExampleFileFilter("jpg", "JPEG");
        this.d_filterPng = new ExampleFileFilter("png", "PNG");
        this.d_filterBmp = new ExampleFileFilter("bmp", "BMP");
        this.d_filterTiff = new ExampleFileFilter("tif", "TIFF");
        this.d_filterTarga = new ExampleFileFilter("tga", "TARGA");
        this.d_filterGif = new ExampleFileFilter("gif", "GIF");
        this.d_filterPpm = new ExampleFileFilter("ppm", "PPM");
        this.setInitialProperties();
        this.d_filenameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotDialog.this.d_filenameChooser.setSelectedFile(new File(SnapshotDialog.this.d_filenameField.getText()));
                SnapshotDialog.this.d_filenameChooser.ensureFileIsVisible(new File(SnapshotDialog.this.d_filenameField.getText()));
                int returnVal = SnapshotDialog.this.d_filenameChooser.showSaveDialog(MerlinApp.getApp().getActiveFrame());
                if (returnVal == 0) {
                    File f = SnapshotDialog.this.d_filenameChooser.getSelectedFile();
                    String file = f.getAbsolutePath();
                    SnapshotDialog.this.d_filenameField.setText(file);
                    SnapshotDialog.this.d_filenameField.setToolTipText(file);
                }
            }
        });
        this.buildPanel();
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        if (result == 1) {
            MerlinApp.getApp().beginWaitCursor();
            if (this.d_snapshotButton.isSelected()) {
                this.takeShot();
            } else {
                this.runPOV();
            }
            MerlinApp.getApp().endWaitCursor();
        }
        return result;
    }

    private void buildPanel() {
        guiLabel filenameL = new guiLabel(Intl.intl("File") + ":");
        guiLabel sizeL = new guiLabel(Intl.intl("Size") + ":");
        guiLabel pyroSimL = new guiLabel(Intl.intl("(fast, medium quality)"));
        guiLabel povrayL = new guiLabel(Intl.intl("(slow, high quality)"));
        guiLabel x = new guiLabel("x");
        guiPanel filenamePanel = new guiPanel(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(filenamePanel, filenameL, 0, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(filenamePanel, this.d_filenameField, 1, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(filenamePanel, this.d_filenameButton, 2, row, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        guiPanel sizePanel = new guiPanel(new GridBagLayout());
        row = 0;
        GridBagUtil.add(sizePanel, sizeL, 0, ++row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, this.d_widthField, 1, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, x, 2, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, this.d_heightField, 3, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, this.d_useWindowSizeButton, 4, row, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        guiPanel progPanel = new guiPanel(new GridBagLayout());
        row = 0;
        GridBagUtil.add(progPanel, this.d_exportTypeTitle, 0, row, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(progPanel, this.d_snapshotButton, 0, ++row, 1, 1, 0, 12, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(progPanel, pyroSimL, 1, row, 1, 1, 0, 6, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(progPanel, this.d_povrayButton, 0, ++row, 1, 1, 0, 12, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(progPanel, povrayL, 1, row, 1, 1, 0, 6, 2, 0, 0, 0.0, 0.0, 17);
        guiPanel povPanel = new guiPanel(new GridBagLayout());
        row = 0;
        GridBagUtil.add(povPanel, this.d_antiAlias, 0, row, 1, 1, 0, 24, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(povPanel, this.d_shadows, 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(povPanel, this.d_povFile, 2, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        row = 0;
        GridBagUtil.add(this.d_dlgPanel, filenamePanel, 0, ++row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this.d_dlgPanel, sizePanel, 0, ++row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
    }

    private void setInitialProperties() {
        MerlinApp app = MerlinApp.getApp();
        Dimension d = this.d_filenameField.getPreferredSize();
        int height = d.height;
        this.d_filenameField.setPreferredSize(new Dimension(200, height));
        this.d_filenameField.setEditable(false);
        String f = MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF);
        String absFile = app.getPrefs().getString(MerlinPrefs.LastScreenShotAbsoluteProp);
        if (!absFile.equals("")) {
            this.d_filenameField.setText(absFile);
        } else if (f != null) {
            this.d_filenameField.setText(f + "\\snapshot.png");
        } else {
            f = Application.getApp().getInstallDir();
            this.d_filenameField.setText(f + "\\snapshot.png");
        }
        this.d_filenameField.setToolTipText(this.d_filenameField.getText());
        if (app.getPrefs().getBoolean(MerlinPrefs.LastScreenShotPyroButton)) {
            Dimension maxSize = this.d_mv.getScreenshotGenerator().getMaximumSize();
            this.d_widthField.setValueRange(IntVR.between(1, maxSize.width, true, true));
            this.d_heightField.setValueRange(IntVR.between(1, maxSize.height, true, true));
        } else {
            this.d_widthField.setValueRange(IntVR.between(1, 5000000, true, true));
            this.d_heightField.setValueRange(IntVR.between(1, 5000000, true, true));
        }
        this.d_widthField.setColumns(5);
        this.d_heightField.setColumns(5);
        this.fillSizeFromView();
        try {
            int ssWidth = app.getPrefs().getInt(MerlinPrefs.LastScreenShotWidth);
            int ssHeight = app.getPrefs().getInt(MerlinPrefs.LastScreenShotHeight);
            this.d_widthField.setValue(ssWidth);
            this.d_heightField.setValue(ssHeight);
        }
        catch (NumberFormatException ssWidth) {
            // empty catch block
        }
        this.d_useWindowSizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotDialog.this.fillSizeFromView();
            }
        });
        boolean pyroButton = app.getPrefs().getBoolean(MerlinPrefs.LastScreenShotPyroButton);
        this.d_snapshotButton.setSelected(pyroButton);
        this.d_povrayButton.setSelected(!pyroButton);
        this.d_antiAlias.setSelected(app.getPrefs().getBoolean(MerlinPrefs.POVScreenShotAntiAlias));
        this.d_antiAlias.setEnabled(!pyroButton);
        this.d_shadows.setSelected(app.getPrefs().getBoolean(MerlinPrefs.POVScreenShotShadows));
        this.d_shadows.setEnabled(!pyroButton);
        this.d_povFile.setSelected(app.getPrefs().getBoolean(MerlinPrefs.POVScreenShotPOVFile));
        this.d_povFile.setEnabled(!pyroButton);
        this.d_filenameChooser.setCurrentDirectory(new File(f));
        if (pyroButton) {
            this.d_filenameChooser.addChoosableFileFilter(this.d_filterBmp);
            this.d_filterJpeg.addExtension("jif");
            this.d_filterJpeg.addExtension("jpeg");
            this.d_filterJpeg.addExtension("jpe");
            this.d_filenameChooser.addChoosableFileFilter(this.d_filterJpeg);
            this.d_filenameChooser.addChoosableFileFilter(this.d_filterPng);
            this.d_filterTarga.addExtension("targa");
            this.d_filenameChooser.addChoosableFileFilter(this.d_filterTarga);
            this.d_filterTiff.addExtension("tiff");
            this.d_filenameChooser.addChoosableFileFilter(this.d_filterTiff);
        } else {
            this.d_filenameChooser.addChoosableFileFilter(this.d_filterPng);
            this.d_filterTarga.addExtension("targa");
            this.d_filenameChooser.addChoosableFileFilter(this.d_filterTarga);
            this.d_filenameChooser.addChoosableFileFilter(this.d_filterPpm);
        }
        this.d_filenameChooser.setAcceptAllFileFilterUsed(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.d_snapshotButton);
        group.add(this.d_povrayButton);
        this.d_snapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotDialog.this.d_antiAlias.setEnabled(false);
                SnapshotDialog.this.d_shadows.setEnabled(false);
                SnapshotDialog.this.d_povFile.setEnabled(false);
                SnapshotDialog.this.d_filenameChooser.addChoosableFileFilter(SnapshotDialog.this.d_filterBmp);
                SnapshotDialog.this.d_filenameChooser.addChoosableFileFilter(SnapshotDialog.this.d_filterJpeg);
                SnapshotDialog.this.d_filenameChooser.addChoosableFileFilter(SnapshotDialog.this.d_filterTiff);
                SnapshotDialog.this.d_filenameChooser.removeChoosableFileFilter(SnapshotDialog.this.d_filterPpm);
                Dimension maxSize = SnapshotDialog.this.d_mv.getScreenshotGenerator().getMaximumSize();
                SnapshotDialog.this.d_widthField.setValueRange(IntVR.between(1, maxSize.width, true, true));
                SnapshotDialog.this.d_heightField.setValueRange(IntVR.between(1, maxSize.height, true, true));
                if (SnapshotDialog.this.d_filenameField.getText().endsWith(".ppm")) {
                    SnapshotDialog.this.d_filenameField.setText(SnapshotDialog.this.d_filenameField.getText().replace(".ppm", ".png"));
                }
            }
        });
    }

    private void fillSizeFromView() {
        this.d_widthField.setValue(this.d_mv.getRenderComp().getWidth());
        this.d_heightField.setValue(this.d_mv.getRenderComp().getHeight());
    }

    private void runPOV() {
    }

    private boolean takeShot() {
        String file = this.d_filenameField.getText();
        int dotIndex = file.lastIndexOf(".");
        if (dotIndex < 0) {
            JOptionPane.showMessageDialog(this.d_dlgPanel, "Enter a file name.", "Error", 0);
            return false;
        }
        this.d_mv.getScreenshotGenerator().setSize((Integer)this.d_widthField.getValue(), (Integer)this.d_heightField.getValue());
        this.d_mv.getScreenshotGenerator().writeFile(file);
        MerlinApp app = MerlinApp.getApp();
        TeciProps prefs = app.getPrefs();
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, new File(file).getAbsolutePath());
        prefs.set(MerlinPrefs.LastScreenShotAbsoluteProp, file);
        prefs.set(MerlinPrefs.LastScreenShotWidth, this.d_widthField.getValue());
        prefs.set(MerlinPrefs.LastScreenShotHeight, this.d_heightField.getValue());
        prefs.set(MerlinPrefs.LastScreenShotPyroButton, Boolean.valueOf(true));
        this.d_mv.getRenderComp().repaint();
        return true;
    }
}

