/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.PrintStream;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Scrollable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.IdentityHashSet;

public class ScrollingConsole
extends JScrollPane {
    private static final long serialVersionUID = 8986649444390675776L;
    private static final String nl = System.getProperty("line.separator");
    public static final AttributeSet STYLE_DEFAULT = new SimpleAttributeSet();
    public static final AttributeSet STYLE_WARN;
    private JTextPane d_textPane;
    private Set<Object> d_updaters;

    public ScrollingConsole() {
        this.setAutoscrolls(true);
        this.d_updaters = new IdentityHashSet<Object>();
        this.d_textPane = new JTextPane();
        this.d_textPane.setEditable(false);
        this.setViewportView(new WrapFixer(this.d_textPane));
        this.getViewport().setBackground(this.d_textPane.getBackground());
        final StyledDocument doc = this.d_textPane.getStyledDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ScrollingConsole.this.d_textPane.setCaretPosition(doc.getLength());
            }
        });
    }

    public void writeText(PrintStream ps) {
        Document doc = this.d_textPane.getDocument();
        try {
            ps.print(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void addLine(AttributeSet style, String line) {
        Document doc = this.d_textPane.getDocument();
        if (!line.endsWith(nl)) {
            line = line + nl;
        }
        try {
            doc.insertString(doc.getLength(), line, style);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void addLine(String line) {
        this.addLine(STYLE_DEFAULT, line);
    }

    static {
        StyleConstants.setFontFamily((SimpleAttributeSet)STYLE_DEFAULT, "Monospaced");
        STYLE_WARN = new SimpleAttributeSet(STYLE_DEFAULT);
        StyleConstants.setForeground((SimpleAttributeSet)STYLE_WARN, Color.RED);
    }

    private static class WrapFixer
    extends guiPanel
    implements Scrollable {
        private static final long serialVersionUID = -8102721251231158795L;
        private JTextPane d_text;

        public WrapFixer(JTextPane text) {
            super(new BorderLayout());
            this.d_text = text;
            this.add((Component)this.d_text, "North");
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.d_text.getScrollableBlockIncrement(visibleRect, orientation, direction);
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.d_text.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
    }
}

