/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Map;
import merlin.gui.IPropEditor;
import merlin.gui.PanPane;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.LinkedIdentityHashMap;

public class PropPanel
extends PanPane
implements Validateable {
    private static final long serialVersionUID = 1L;
    public static final int BORDER_SIZE = 3;
    private final guiPanel d_holder;
    private final Map<IPropEditor, String> d_panelNames;
    private IPropEditor d_editor;
    private Dimension d_maxPreferredSize;
    private final IPropEditor d_nullEditor;
    private final ComponentListener d_scrollListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
        }
    };

    public PropPanel() {
        this.setBorder(null);
        this.d_holder = new guiPanel(new BorderLayout());
        this.d_panelNames = new LinkedIdentityHashMap<IPropEditor, String>();
        this.d_nullEditor = new NullEditor();
        this.setViewportView(this.d_holder);
    }

    public void addEditor(IPropEditor editor) {
        if (editor == null) {
            editor = this.d_nullEditor;
        }
        if (this.d_panelNames.containsKey(editor)) {
            return;
        }
        int i = 0;
        String name = Integer.toString(i);
        while (this.findEditor(name) != null) {
            name = Integer.toString(++i);
        }
        this.d_panelNames.put(editor, name);
    }

    private IPropEditor findEditor(String name) {
        for (Map.Entry<IPropEditor, String> entry : this.d_panelNames.entrySet()) {
            if (!entry.getValue().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        if (this.d_maxPreferredSize == null) {
            this.d_maxPreferredSize = prefSize;
        } else if (prefSize.height > this.d_maxPreferredSize.height) {
            this.d_maxPreferredSize = new Dimension(this.d_maxPreferredSize.width, prefSize.height);
        }
        return this.d_maxPreferredSize;
    }

    public void setEditor(IPropEditor editor) {
        if (editor == null) {
            editor = this.d_nullEditor;
        }
        if (this.d_editor != editor) {
            String name = this.d_panelNames.get(editor);
            if (name == null) {
                this.addEditor(editor);
                name = this.d_panelNames.get(editor);
            }
            if (this.d_editor != null) {
                this.d_holder.remove(this.d_editor.getComponent());
                this.d_editor.getComponent().removeComponentListener(this.d_scrollListener);
            }
            if (editor != null) {
                this.d_holder.add(editor.getComponent());
                editor.getComponent().addComponentListener(this.d_scrollListener);
                this.scroll(PanPane.ScrollDir.LEFT);
            }
            this.d_holder.revalidate();
            this.d_holder.repaint();
            this.d_editor = editor;
        }
    }

    public IPropEditor getEditor() {
        return this.d_editor;
    }

    public void commit() {
        IPropEditor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        editor.commit();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        IPropEditor editor = this.getEditor();
        if (editor == null) {
            return true;
        }
        return editor.validateData(showWarn, allowModify);
    }

    private static class NullEditor
    extends guiPanel
    implements IPropEditor {
        private static final long serialVersionUID = 1L;

        private NullEditor() {
        }

        @Override
        public void activate() {
        }

        @Override
        public void commit() {
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }
}

