/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import common.data.EscalatorPreference;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.vecmath.Point3f;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.EditProps;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.EgressStair;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.property.Function1dProp;
import merlin.data.property.INamedProp;
import merlin.data.value.IFunction1d;
import merlin.gui.AvatarEditor;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.gui.SetChooser;
import merlin.gui.UnitUpdator;
import merlin.gui.guiUtil;
import merlin.gui.stat.VerboseCurveEditor;
import merlin.gui.stat.guiCurveUtil;
import merlin.gui.value.AValEditor;
import merlin.gui.value.FixedValEditor;
import merlin.gui.value.Function1dEditorFactory;
import merlin.gui.value.IValEditor;
import merlin.gui.value.MultiValEditor;
import merlin.gui.value.PopupValEditor;
import merlin.mv.gui.OccEditorPanel;
import merlin.unitsystem.SIUS;
import merlin.unitsystem.UnitUpdatableComponent;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Property;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class ProfilesPanel
extends guiPanel
implements IEditor<OccProfile> {
    private static final long serialVersionUID = 1L;
    private final guiTextField d_name;
    private final guiTextField d_desc;
    private final AvatarEditor d_model;
    private final ColorButton d_colorBtn;
    private final CharPanel d_propsPnl;
    private final MovementPanel d_behaviorPnl;
    private final RestrictionsPanel d_restrictionsPnl;
    private final DoorChoicePanel d_doorChoicePnl;
    private final OutputPanel d_outputPnl;
    private final AdvancedPanel d_advancedPnl;
    private static List<IPropertySet.Prop<?>> ADVANCED_SPEED_PROPS = Arrays.asList(OccProfile.PROP_MAXVEL, OccProfile.PROP_FUNDAMENTAL, OccProfile.PROP_STAIR_SPEED_UP, OccProfile.PROP_STAIR_FUNDAMENTAL_UP, OccProfile.PROP_STAIR_SPEED_DOWN, OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN, OccProfile.PROP_RAMP_SPEED_UP, OccProfile.PROP_RAMP_FUNDAMENTAL_UP, OccProfile.PROP_RAMP_SPEED_DOWN, OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN);

    public ProfilesPanel(Window owner) {
        this.setLayout(new GridBagLayout());
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        this.d_desc = new guiTextField();
        this.d_desc.getDocument().addDocumentListener(this.d_comm);
        this.d_colorBtn = new ColorButton(1);
        this.d_model = new AvatarEditor(3, ResourceAvatar.Type.OCCUPANT);
        this.d_model.addValueListener(e -> this.setModified(true));
        Border border = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        this.d_propsPnl = new CharPanel();
        this.d_propsPnl.setBorder(border);
        this.d_behaviorPnl = new MovementPanel();
        this.d_behaviorPnl.setBorder(border);
        this.d_restrictionsPnl = new RestrictionsPanel();
        this.d_restrictionsPnl.setBorder(border);
        this.d_advancedPnl = new AdvancedPanel();
        this.d_advancedPnl.setBorder(border);
        this.d_doorChoicePnl = new DoorChoicePanel();
        this.d_doorChoicePnl.setBorder(border);
        this.d_outputPnl = new OutputPanel();
        this.d_outputPnl.setBorder(border);
        JTabbedPane tb = new JTabbedPane();
        tb.addTab(CharPanel.TITLE, this.d_propsPnl);
        tb.addTab(MovementPanel.TITLE, this.d_behaviorPnl);
        tb.addTab(RestrictionsPanel.TITLE, this.d_restrictionsPnl);
        tb.addTab(DoorChoicePanel.TITLE, this.d_doorChoicePnl);
        tb.addTab(OutputPanel.TITLE, this.d_outputPnl);
        tb.addTab(AdvancedPanel.TITLE, this.d_advancedPnl);
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(Intl.intl("Name:"), this.d_name, 1.0, GridBagHelper.REMAINING);
        gb.addRow(Intl.intl("Description:"), this.d_desc, 1.0, GridBagHelper.REMAINING);
        gb.addRow(Intl.intl("3D Model:"), this.d_model, 1.0, 0);
        gb.addRow(Intl.intl("Color:"), this.d_colorBtn);
        gb.addRow(tb, new int[]{0, 0}, new double[]{1.0, 1.0});
        gb.finalizeRows();
    }

    private static guiLabel newLbl(String text, String tt) {
        guiLabel result = new guiLabel(text);
        return ProfilesPanel.setTooltip(result, tt);
    }

    private static <T extends JComponent> T setTooltip(T c, String tt) {
        if (!tt.isEmpty()) {
            tt = tt.replace("\n", "<br>");
            tt = "<html>" + tt + "</html>";
        }
        c.setToolTipText(tt);
        return c;
    }

    @Override
    public OccProfile preview(OccProfile previewObj) {
        return previewObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(OccProfile dataObj) {
        if (dataObj != null) {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            try {
                this.d_name.setText(dataObj.getProperty(OccProfile.PROP_NAME));
                this.d_desc.setText(dataObj.getProperty(OccProfile.PROP_DESC));
                Point3f c3f = dataObj.getProperty(OccProfile.PROP_COLOR);
                this.d_colorBtn.setColor(new Color(c3f.x, c3f.y, c3f.z, 1.0f));
                this.d_model.setValue(Property.of(dataObj.getProperty(OccProfile.PROP_OCCMODEL)));
                this.d_propsPnl.init(dataObj);
                this.d_behaviorPnl.init(dataObj);
                this.d_restrictionsPnl.init(dataObj);
                this.d_advancedPnl.init(dataObj);
                this.d_outputPnl.init(dataObj);
                this.d_doorChoicePnl.init(dataObj);
            }
            finally {
                md.endRead();
            }
        }
        this.setModified(false);
    }

    @Override
    public OccProfile commit(final OccProfile dataObj) {
        if (dataObj != null) {
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    Undo.begin(Intl.intl("Edit Profile"));
                    md.beginWrite();
                    try {
                        ProfilesPanel.insertUndoOp(md, dataObj);
                        ProfilesPanel.this.commitProfile(dataObj, true);
                    }
                    finally {
                        Undo.end(MerlinApp.getApp().getData());
                        md.endWrite();
                    }
                }
            };
            UIHook.run(this, "ProfilesPanel.commit", op, 2);
        }
        this.setModified(false);
        return dataObj;
    }

    private void commitProfile(OccProfile profile, boolean changeModified) {
        if (profile == null) {
            return;
        }
        profile.setIfNotDefault(OccProfile.PROP_DESC, this.d_desc.getText());
        Color c = this.d_colorBtn.getColor();
        Point3f c3f = new Point3f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        profile.setIfNotDefault(OccProfile.PROP_COLOR, c3f);
        profile.setIfNotDefault(OccProfile.PROP_OCCMODEL, ((Property)this.d_model.getValue()).get());
        this.d_propsPnl.commit(profile, changeModified);
        this.d_behaviorPnl.commit(profile, changeModified);
        this.d_restrictionsPnl.commit(profile, changeModified);
        this.d_advancedPnl.commit(profile, changeModified);
        this.d_outputPnl.commit(profile, changeModified);
        this.d_doorChoicePnl.commit(profile, changeModified);
    }

    public Collection<INamedProp> getChanges(OccProfile origProf) {
        OccProfile tempProf = origProf.clone();
        this.commitProfile(tempProf, false);
        ArrayList<INamedProp> changes = new ArrayList<INamedProp>();
        for (Object o : tempProf.getPropTypes(0)) {
            IPropertySet.Prop prop;
            if (!(o instanceof IPropertySet.Prop) || Objects.equals(tempProf.getProperty(prop = (IPropertySet.Prop)o), origProf.getProperty(prop))) continue;
            assert (prop instanceof INamedProp);
            if (!(prop instanceof INamedProp)) continue;
            changes.add((INamedProp)((Object)prop));
        }
        return changes;
    }

    private static void insertUndoOp(MerlinData md, OccProfile prof) {
        Collection<EgressAgent> agents = ProfilesPanel.getAgentsUsing(md, prof);
        Op op = new Op(prof, prof.getRestoreObj(), md.selection.isSelected(prof), agents);
        Undo.insertEntry(md, op);
        ProfilesPanel.updateAgents(agents);
    }

    private static Collection<EgressAgent> getAgentsUsing(MerlinData md, OccProfile profile) {
        ArrayList<EgressAgent> agents = new ArrayList<EgressAgent>();
        for (EgressAgent agent : md.agents.getDeepMembers(EgressAgent.class)) {
            if (agent.getProfile().getProfParent() != profile) continue;
            agents.add(agent);
        }
        return agents;
    }

    private static void updateAgents(Collection<EgressAgent> agents) {
        for (EgressAgent agent : agents) {
            agent.updateProps();
        }
    }

    public static boolean checkReset(Component comp, String valType) {
        int option = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(comp), String.format("<html>" + Intl.intl("Are you sure you want to reset to the default <b>%s</b> values?") + "</html>", valType), Intl.intl("Confirm Reset"), 0);
        return option == 0;
    }

    private static IValEditor<OccProfile> newSpeedEditor() {
        Predicate<OccProfile> isAdvanced = prof -> ADVANCED_SPEED_PROPS.stream().anyMatch(prop -> prop != OccProfile.PROP_MAXVEL && !Objects.equals(prof.getProperty(prop), prop.defVal));
        Collection<MultiValEditor.Entry<ICurve, ? extends ICurve>> curveEntries = VerboseCurveEditor.getEntries(5, 15, false, UnitDoubleVR.above(0.0, SIUS.unit(5), true));
        ArrayList speedEntries = new ArrayList();
        for (MultiValEditor.Entry<ICurve, ? extends ICurve> entry : curveEntries) {
            MultiValEditor.Entry<OccProfile, OccProfile> newEntry = new MultiValEditor.Entry<OccProfile, OccProfile>(entry.key, entry.tooltip, new ProfileSpeedEditor(entry.editor), prof -> {
                if (prof == null || isAdvanced.test((OccProfile)prof)) {
                    return false;
                }
                ICurve curve = prof.getProperty(OccProfile.PROP_MAXVEL);
                return entry.editor.getType().isInstance(curve) && entry.filter.test(curve);
            }, entry.init, prof -> {
                OccProfile result = new OccProfile();
                ICurve newCurve = (ICurve)entry.converter.apply(prof.getProperty(OccProfile.PROP_MAXVEL));
                result.setProperty(OccProfile.PROP_MAXVEL, newCurve);
                return result;
            });
            speedEntries.add(newEntry);
        }
        PopupValEditor<OccProfile> advSpeedEditor = new PopupValEditor<OccProfile>(PopupValEditor.Mode.BUTTON, OccProfile.class, Intl.intl("Advanced Speed Properties"), () -> new AdvancedSpeedEditor(), profile -> AdvancedSpeedEditor.format(profile));
        speedEntries.add(new MultiValEditor.Entry<OccProfile, OccProfile>(Intl.intl("Advanced"), "<html>" + Intl.intl("Enter advanced speed properties, such as the speed-density profile<br>and ramp and stair speeds."), advSpeedEditor, o -> o != null, () -> advSpeedEditor.editValue(), o -> o));
        return new MultiValEditor(OccProfile.class, speedEntries, false);
    }

    private static guiLabel newLabel(Function1dProp prop) {
        guiLabel lbl = new guiLabel(prop.desc + ":");
        if (prop.longDesc != null) {
            lbl.setToolTipText(prop.longDesc);
        }
        return lbl;
    }

    public static IValEditor<OccProfile.IProfileFunction> newSlopedFundEditor(OccProfile.ProfileFunctionProp prop, Supplier<IFunction1d> levelFund) {
        List<MultiValEditor.Entry<IFunction1d, ? extends IFunction1d>> fentries = Function1dEditorFactory.getEntries(prop.fprop, false, levelFund, 7);
        ArrayList entries = new ArrayList(fentries.size() + 1);
        entries.add(new MultiValEditor.Entry<OccProfile.IProfileFunction, OccProfile.FromLevelFundamental>(Intl.intl("From Level Terrain"), Intl.intl("Use the same speed-density function as for level terrain."), new FixedValEditor<OccProfile.FromLevelFundamental>(OccProfile.FromLevelFundamental.class, OccProfile.FromLevelFundamental.INSTANCE), f -> f != null, () -> true, f -> OccProfile.FromLevelFundamental.INSTANCE));
        for (MultiValEditor.Entry<IFunction1d, ? extends IFunction1d> fentry : fentries) {
            entries.add(new MultiValEditor.Entry<OccProfile.IProfileFunction, OccProfile.ConstProfileFunction>(fentry.key, fentry.tooltip, new ProfileFunctionEditor(fentry.editor), f -> f != null && entry.editor.getType().isInstance(f.function) && entry.filter.test(f.function), () -> entry.init.getAsBoolean(), f -> {
                if (f == null) {
                    return new OccProfile.ConstProfileFunction((IFunction1d)entry.converter.apply(null));
                }
                if (f instanceof OccProfile.FromLevelFundamental) {
                    return new OccProfile.ConstProfileFunction((IFunction1d)entry.converter.apply(levelFund.get()));
                }
                if (f instanceof OccProfile.ConstProfileFunction) {
                    OccProfile.ConstProfileFunction pf = (OccProfile.ConstProfileFunction)f;
                    IFunction1d cfunc = (IFunction1d)entry.converter.apply(pf.function);
                    return cfunc == pf.function ? pf : new OccProfile.ConstProfileFunction(cfunc);
                }
                assert (false);
                return null;
            }));
        }
        return new MultiValEditor(OccProfile.IProfileFunction.class, entries, false);
    }

    private static <T> IUrn<T> toUrn(T value) {
        return new Urn<Object>(value);
    }

    private static class AdvancedPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Advanced");
        private final IValEditor<ICurve> d_persist;
        private final IValEditor<ICurve> d_collResponseTime;
        private final IValEditor<ICurve> d_slowFactor;
        private final IValEditor<ICurve> d_accelTime;
        private final IValEditor<ICurve> d_boundaryLayer;
        private final PersonalDistanceEditor d_spacingPnl;
        private final IValEditor<ICurve> d_socialDist;
        private final JButton d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));

        public AdvancedPanel() {
            this.d_resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!ProfilesPanel.checkReset(this, TITLE)) {
                        return;
                    }
                    this.init(new OccProfile());
                    this.setModified(true);
                }
            });
            guiLabel accelLbl = ProfilesPanel.newLbl(Intl.intl("Acceleration Time:"), Intl.intl("The amount of time for an occupant to accelerate from standing to moving at maximum velocity."));
            this.d_accelTime = new VerboseCurveEditor(1, false);
            guiLabel persistLbl = ProfilesPanel.newLbl(Intl.intl("Persist Time:"), Intl.intl("Amount of time an occupant keeps elevated priority to resolve conflicts when no progress is being made."));
            this.d_persist = new VerboseCurveEditor(1, false);
            guiLabel collResponseTimeLbl = ProfilesPanel.newLbl(Intl.intl("Collision Response Time:"), Intl.intl("Time used by an occupant to determine the critical stopping distance to avoid hitting other occupants."));
            this.d_collResponseTime = new VerboseCurveEditor(1, false);
            guiLabel slowFactorLbl = ProfilesPanel.newLbl(Intl.intl("Slow Factor:"), Intl.intl("The fraction of an occupant's maximum speed that determines if the occupant is slow,\nallowing the occupant to consider more travel directions."));
            this.d_slowFactor = new VerboseCurveEditor(11, false);
            guiLabel blayerLbl = ProfilesPanel.newLbl(Intl.intl("Wall Boundary Layer:"), Intl.intl("The distance the occupant tries to maintain with walls."));
            this.d_boundaryLayer = new VerboseCurveEditor(0, false);
            guiLabel spacingLbl = ProfilesPanel.newLbl(Intl.intl("Personal Distance:"), Intl.intl("Controls the spacing of occupants when queueing or travelling with restricted speed."));
            this.d_spacingPnl = new PersonalDistanceEditor(this.getComm());
            guiLabel socialDistLbl = ProfilesPanel.newLbl(Intl.intl("Social Distancing:"), Intl.intl("The preferred distance to other occupants outside the occupant's movement group."));
            this.d_socialDist = new VerboseCurveEditor(0, false, 31);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(accelLbl, this.d_accelTime, 1.0, 0);
            gb.addRow(persistLbl, this.d_persist, 1.0, 0);
            gb.addRow(collResponseTimeLbl, this.d_collResponseTime, 1.0, 0);
            gb.addRow(slowFactorLbl, this.d_slowFactor, 1.0, 0);
            gb.addRow(blayerLbl, this.d_boundaryLayer, 1.0, 0);
            gb.addRow(spacingLbl, this.d_spacingPnl, 1.0, 0);
            gb.addRow(socialDistLbl, this.d_socialDist, 1.0, 0);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_accelTime.setValue(dataObj.getProperty(OccProfile.PROP_ACCEL_TIME));
            this.d_collResponseTime.setValue(dataObj.getProperty(OccProfile.PROP_COLLISION_RESPONSE_TIME));
            this.d_persist.setValue(dataObj.getProperty(OccProfile.PROP_PERSIST_TIME));
            this.d_slowFactor.setValue(dataObj.getProperty(OccProfile.PROP_SLOW_FACTOR));
            this.d_boundaryLayer.setValue(dataObj.getProperty(OccProfile.PROP_BOUNDARY_LAYER));
            this.d_spacingPnl.setValue(dataObj.getProperty(OccProfile.PROP_SPACING));
            this.d_socialDist.setValue(dataObj.getProperty(OccProfile.PROP_SOCIAL_DIST));
            this.setModified(false);
        }

        public OccProfile commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            dataObj.setIfNotDefault(OccProfile.PROP_ACCEL_TIME, this.d_accelTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_COLLISION_RESPONSE_TIME, this.d_collResponseTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_PERSIST_TIME, this.d_persist.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_SLOW_FACTOR, this.d_slowFactor.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_BOUNDARY_LAYER, this.d_boundaryLayer.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_SPACING, this.d_spacingPnl.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_SOCIAL_DIST, this.d_socialDist.getValue());
            if (changeModified) {
                this.setModified(false);
            }
            return dataObj;
        }
    }

    public static class ShapeEditor
    extends HTMLBtn
    implements Modifiable,
    IValEditor<OccProfile.OccShape>,
    UnitUpdatableComponent {
        private static final long serialVersionUID = 1L;
        private final Comm d_comm;
        private OccProfile.OccShape d_shape;
        private boolean d_modified;
        private OccEditorPanel.ShapePropConn d_shapePropConn;
        private ShapePnl d_pnl;

        public ShapeEditor(Comm comm, int options) {
            super("");
            this.d_comm = comm;
            this.d_modified = false;
            if (options == 1) {
                UnitUpdator.addComp(this);
            }
            this.addActionListener(e -> {
                OccProfile.OccShape newShape;
                guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Shape"), 9);
                dlg.setResizable(true);
                this.d_pnl = new ShapePnl(options);
                this.d_pnl.load(this.d_shape);
                dlg.getDialogPane().add(this.d_pnl);
                dlg.setResizable(false);
                if (dlg.doModal() == 1 && !Objects.equals(newShape = this.d_pnl.save(), this.d_shape)) {
                    this.setValue(newShape);
                    this.setModified(true);
                    this.d_comm.touch(e);
                    if (this.d_shapePropConn != null) {
                        this.d_shapePropConn.editModel(newShape);
                    }
                }
            });
            this.update();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public Class<OccProfile.OccShape> getType() {
            return OccProfile.OccShape.class;
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }

        @Override
        public void setModified(boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setValue(OccProfile.OccShape shape) {
            if (Objects.equals(shape, this.d_shape)) {
                return;
            }
            this.d_shape = shape;
            this.update();
            this.setModified(false);
        }

        @Override
        public OccProfile.OccShape getValue() {
            return this.d_shape;
        }

        public void update() {
            this.setText(this.d_shape != null ? ShapeEditor.format(this.d_shape) : Intl.intl("&lt;mixed&gt;"));
        }

        public static String format(OccProfile.OccShape shape) {
            if (shape.type == VehicleShape.ShapeType.CYLINDER) {
                return String.format(Intl.intl("Cylinder: shoulder width = %s"), guiCurveUtil.format(shape.shoulderWidth, 6));
            }
            return String.format(Intl.intl("Polygon: %s"), shape.vehicleShape.getName());
        }

        public void addConnection(OccEditorPanel.ShapePropConn shapePropConn) {
            this.d_shapePropConn = shapePropConn;
        }

        @Override
        public void update(Unit newUnit) {
            this.update();
        }

        @Override
        public Unit getDisplayUnit() {
            return SI.CENTI(SI.METER);
        }
    }

    public static class PersonalDistanceEditor
    extends HTMLBtn
    implements Modifiable,
    IValEditor<OccProfile.Spacing> {
        private static final long serialVersionUID = 1L;
        private final Comm d_comm;
        private OccProfile.Spacing d_spacing;
        private boolean d_modified;

        public PersonalDistanceEditor(Comm comm) {
            this(comm, 15);
        }

        public PersonalDistanceEditor(Comm comm, int options) {
            super("");
            this.d_comm = comm;
            this.d_modified = false;
            this.addActionListener(e -> {
                OccProfile.Spacing newSpacing;
                guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Personal Distance"), 9);
                SpacingPnl pnl = new SpacingPnl(options);
                pnl.load(this.d_spacing);
                dlg.getDialogPane().add(pnl);
                if (dlg.doModal() == 1 && !Objects.equals(newSpacing = pnl.save(), this.d_spacing)) {
                    this.setValue(newSpacing);
                    this.setModified(true);
                    this.d_comm.touch(e);
                }
            });
            this.update();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public Class<OccProfile.Spacing> getType() {
            return OccProfile.Spacing.class;
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }

        @Override
        public void setModified(boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setValue(OccProfile.Spacing spacing) {
            if (Objects.equals(spacing, this.d_spacing)) {
                return;
            }
            this.d_spacing = spacing;
            this.update();
            this.setModified(false);
        }

        @Override
        public OccProfile.Spacing getValue() {
            return this.d_spacing;
        }

        private void update() {
            this.setText(this.d_spacing != null ? PersonalDistanceEditor.format(this.d_spacing) : Intl.intl("&lt;mixed&gt;"));
        }

        private static String format(OccProfile.Spacing spacing) {
            if (spacing.type == OccProfile.SpacingType.COMFORT_DIST) {
                return String.format("%s", guiCurveUtil.format(spacing.val));
            }
            return String.format("%s=%s", spacing.type.desc, guiCurveUtil.format(spacing.val));
        }
    }

    public static enum CorridorType {
        STAIR(Intl.intl("Stair")),
        RAMP(Intl.intl("Ramp"));

        public final String desc;

        private CorridorType(String desc) {
            this.desc = desc;
        }
    }

    private static enum ShapeTypeEnum {
        CYLINDER(Intl.intl("Cylinder"), Intl.intl("A shape of a regular occupant.")),
        POLYGON(Intl.intl("Polygon"), Intl.intl("A shape of a vehicle occupant."));

        public final String name;
        public final String tt;

        private ShapeTypeEnum(String name, String tt) {
            this.name = name;
            this.tt = tt;
        }
    }

    private static class ShapePnl
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private MerlinComboBox<VehicleShape> d_cbVehicleShape;
        private VerboseCurveEditor d_shoulderWidth;
        private VerboseCurveEditor d_height;
        private final guiPanel d_cardPanel;
        private final guiComboBox<ShapeTypeEnum> d_cbShapeType;
        private final guiCheckBox d_reduceDiamOccsCyl;
        private final guiCheckBox d_reduceDiamOccsPol;
        private final guiCheckBox d_reduceDiamGeom;
        private final guiDoubleField d_redFactorOccsCyl;
        private final guiDoubleField d_redFactorOccsPol;
        private final MerlinUDF d_minDiamGeom;
        private Component d_parent;

        public ShapePnl(int curveOpts) {
            guiLabel shoulderWidthLbl = ProfilesPanel.newLbl(Intl.intl("Diameter:"), Intl.intl("The occupant diameter used when performing collisions with other occupants."));
            this.d_shoulderWidth = new VerboseCurveEditor(6, false, curveOpts);
            guiLabel heightLbl = ProfilesPanel.newLbl(Intl.intl("Height:"), Intl.intl("The height used when performing collisions with other occupants."));
            this.d_height = new VerboseCurveEditor(0, false, curveOpts);
            if (curveOpts == 1) {
                this.d_shoulderWidth.getComboBox().setEnabled(false);
                this.d_height.getComboBox().setEnabled(false);
            }
            guiLabel vehicleShapeLbl = ProfilesPanel.newLbl(Intl.intl("Vehicle Shape:"), Intl.intl("Shape of the vehicle agent."));
            this.d_cbVehicleShape = new MerlinComboBox(MerlinApp.getApp().getData(), VehicleShape.class, (IMerlinObj[])new VehicleShape[0]);
            this.d_cbVehicleShape.setPreferredSize(new Dimension(150, this.d_cbVehicleShape.getPreferredSize().height));
            String reduceDiamOccs = Intl.intl("Reduce diameter to resolve congestion");
            guiLabel squeezeLblCyl = ProfilesPanel.newLbl(Intl.intl("Reduction Factor:"), Intl.intl("The fraction by which an occupant can reduce his/her radius to move past others."));
            guiLabel squeezeLblPol = ProfilesPanel.newLbl(Intl.intl("Reduction Factor:"), Intl.intl("The fraction by which an occupant can reduce his/her radius to move past others."));
            guiLabel minDiamLbl = ProfilesPanel.newLbl(Intl.intl("Minimum Diameter:"), Intl.intl("The minimum diameter to which an occupant can reduce its body to move past narrow geometry."));
            this.d_reduceDiamOccsCyl = new guiCheckBox(reduceDiamOccs);
            this.d_reduceDiamOccsPol = new guiCheckBox(reduceDiamOccs);
            this.d_reduceDiamGeom = new guiCheckBox(Intl.intl("Reduce diameter to move through narrow geometry"));
            this.d_reduceDiamGeom.setToolTipText(Intl.intl("Reduced diameter applies only to steering-mode simulations and is not used by SFPE-mode simulations."));
            this.d_redFactorOccsCyl = new guiDoubleField(DoubleVR.between(0.0, 1.0, true, true));
            this.d_redFactorOccsPol = new guiDoubleField(DoubleVR.between(0.0, 1.0, true, true));
            this.d_minDiamGeom = new MerlinUDF(SI.CENTI(SI.METER));
            int prefWidth = 90;
            this.d_redFactorOccsCyl.setPreferredSize(new Dimension(prefWidth, this.d_redFactorOccsCyl.getPreferredSize().height));
            this.d_redFactorOccsPol.setPreferredSize(new Dimension(prefWidth, this.d_redFactorOccsPol.getPreferredSize().height));
            this.d_minDiamGeom.setPreferredSize(new Dimension(prefWidth, this.d_minDiamGeom.getPreferredSize().height));
            HTMLBtn editVehicleShape = new HTMLBtn(Intl.intl("Edit..."));
            editVehicleShape.addActionListener(e -> {
                AMerlinOp op = new AMerlinOp(){

                    @Override
                    public void run(MerlinApp app, MerlinData md) {
                        EditProps.editVehicleShapes(MerlinApp.getApp(), MerlinApp.getApp().getData(), Optional.of(d_cbVehicleShape.getSelectedItem()));
                    }
                };
                UIHook.run(this, "Edit Vehicle Shapes", op, 0);
            });
            LinkStatus.link((AbstractButton)this.d_reduceDiamOccsCyl, this.d_redFactorOccsCyl, squeezeLblCyl);
            LinkStatus.link((AbstractButton)this.d_reduceDiamOccsPol, this.d_redFactorOccsPol, squeezeLblPol);
            LinkStatus.link((AbstractButton)this.d_reduceDiamGeom, this.d_minDiamGeom, minDiamLbl);
            guiPanel cylinderPnl = new guiPanel();
            GridBagHelper gb = new GridBagHelper(cylinderPnl);
            gb.add(shoulderWidthLbl);
            this.d_shoulderWidth.addTwoComps(gb, false);
            gb.add(heightLbl);
            this.d_height.addTwoComps(gb, false);
            gb.addRow(this.d_reduceDiamOccsCyl, GridBagHelper.REMAINING);
            gb.addIdentRow(squeezeLblCyl, 2, this.d_redFactorOccsCyl);
            gb.addRow(this.d_reduceDiamGeom, GridBagHelper.REMAINING);
            gb.addIdentRow(minDiamLbl, 2, this.d_minDiamGeom);
            gb.finalizeRows();
            guiPanel polygonPnl = new guiPanel();
            gb = new GridBagHelper(polygonPnl);
            gb.addRow(new Object[]{vehicleShapeLbl, this.d_cbVehicleShape, GridBagHelper.Fill.HORIZONTAL, editVehicleShape});
            gb.addRow(this.d_reduceDiamOccsPol, GridBagHelper.REMAINING);
            gb.addIdentRow(squeezeLblPol, this.d_redFactorOccsPol);
            gb.finalizeRows();
            this.d_cbShapeType = new guiComboBox<ShapeTypeEnum>(ShapeTypeEnum.values());
            this.d_cbShapeType.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    ShapeTypeEnum p = (ShapeTypeEnum)((Object)value);
                    this.setText(p.name);
                    this.setToolTipText(p.tt);
                    return this;
                }
            });
            this.d_cbShapeType.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.d_cbShapeType.setToolTipText(this.d_cbShapeType.getSelectedItem().tt);
            });
            CardLayout cardLayout = new CardLayout();
            this.d_cardPanel = new guiPanel(cardLayout);
            this.d_cardPanel.add((Component)cylinderPnl, ShapeTypeEnum.CYLINDER.name);
            this.d_cardPanel.add((Component)polygonPnl, ShapeTypeEnum.POLYGON.name);
            this.d_cbShapeType.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                ShapeTypeEnum selItem = this.d_cbShapeType.getSelectedItem();
                cardLayout.show(this.d_cardPanel, selItem.name);
            });
            gb = new GridBagHelper(this);
            this.add(gb, (Component)this);
            this.loadDefaults();
        }

        public void add(GridBagHelper gb, Component parent) {
            gb.addRow(new Object[]{Intl.intl("Shape:"), this.d_cbShapeType, GridBagHelper.Fill.HORIZONTAL});
            gb.addIdentRow(this.d_cardPanel, 1.0, 5);
            this.d_parent = parent;
        }

        public void load(OccProfile.OccShape shape) {
            this.loadDefaults();
            if (shape == null) {
                return;
            }
            if (shape.shoulderWidth != null) {
                this.d_shoulderWidth.setValue(shape.shoulderWidth);
            }
            if (shape.geomShoulderWidth != null) {
                this.d_minDiamGeom.setValue(shape.geomShoulderWidth);
            }
            if (shape.height != null) {
                this.d_height.setValue(shape.height);
            }
            if (shape.minSqueezeFactor != null) {
                this.d_redFactorOccsCyl.setValue(shape.minSqueezeFactor);
                this.d_redFactorOccsPol.setValue(shape.minSqueezeFactor);
            }
            switch (shape.type) {
                case CYLINDER: {
                    this.d_cbShapeType.setSelectedItem((Object)ShapeTypeEnum.CYLINDER);
                    this.d_reduceDiamGeom.setSelected(shape.geomShoulderWidth != null);
                    this.d_reduceDiamOccsCyl.setSelected(shape.minSqueezeFactor != null);
                    break;
                }
                case POLYGON: {
                    this.d_cbShapeType.setSelectedItem((Object)ShapeTypeEnum.POLYGON);
                    this.d_cbVehicleShape.setSelectedItem(shape.vehicleShape);
                    this.d_reduceDiamOccsPol.setSelected(shape.minSqueezeFactor != null);
                }
            }
        }

        private void loadDefaults() {
            this.d_shoulderWidth.setValue(OccProfile.PROP_DIAMETER.defVal);
            this.d_height.setValue(OccProfile.PROP_HEIGHT.defVal);
            this.d_redFactorOccsCyl.setValue(OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST.defVal);
            this.d_redFactorOccsPol.setValue(OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST.defVal);
            this.d_minDiamGeom.setValue(OccProfile.PROP_GEOM_DIAMETER.defVal != null ? (UnitDouble)OccProfile.PROP_GEOM_DIAMETER.defVal : new UnitDouble(33.0, SI.CENTI(SI.METER)));
            this.d_reduceDiamOccsCyl.setSelected(OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST.defVal != null);
            this.d_reduceDiamOccsPol.setSelected(OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST.defVal != null);
            this.d_reduceDiamGeom.setSelected(OccProfile.PROP_GEOM_DIAMETER.defVal != null);
            this.d_cbVehicleShape.setSelectedIndex(0);
            this.d_cbShapeType.setSelectedItem((Object)ShapeTypeEnum.CYLINDER);
        }

        public OccProfile.OccShape save() {
            VehicleShape vehicleShape = null;
            ICurve shoulderWidth = null;
            UnitDouble minDiamGeom = null;
            ICurve height = null;
            Double minSqueezeFactor = null;
            ShapeTypeEnum selection = this.d_cbShapeType.getSelectedItem();
            boolean isSelectedCylinder = selection.equals((Object)ShapeTypeEnum.CYLINDER);
            boolean isSelectedPolygon = selection.equals((Object)ShapeTypeEnum.POLYGON);
            if (isSelectedCylinder) {
                shoulderWidth = (ICurve)this.d_shoulderWidth.getValue();
                minDiamGeom = this.d_reduceDiamGeom.isSelected() ? (UnitDouble)this.d_minDiamGeom.getValue() : null;
                height = (ICurve)this.d_height.getValue();
                minSqueezeFactor = this.d_reduceDiamOccsCyl.isSelected() ? (Double)this.d_redFactorOccsCyl.getValue() : null;
            } else if (isSelectedPolygon) {
                vehicleShape = (VehicleShape)this.d_cbVehicleShape.getSelectedItem();
                minSqueezeFactor = this.d_reduceDiamOccsPol.isSelected() ? (Double)this.d_redFactorOccsPol.getValue() : null;
            }
            return new OccProfile.OccShape(vehicleShape, shoulderWidth, minDiamGeom, height, minSqueezeFactor);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            OccProfile.OccShape shape = this.save();
            if (shape.type == VehicleShape.ShapeType.CYLINDER && shape.geomShoulderWidth != null && theUtil.ge(shape.geomShoulderWidth.get(SI.METER), shape.shoulderWidth.getMin().get(SI.METER), 0.0)) {
                if (showWarn) {
                    String msg = Intl.intl("Minimum diameter for movement through narrow geometry must be smaller than the regular diameter.");
                    JOptionPane.showMessageDialog(this.d_parent, msg, Intl.intl("Invalid Minimum Diameter"), 0);
                }
                return false;
            }
            return true;
        }
    }

    private static class SpacingPnl
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final IValEditor<ICurve> d_personalDist;
        private final IValEditor<ICurve> d_queueDensity;
        private final IValEditor<ICurve> d_queueArea;
        private final guiRadioButton d_comfortDistRB;
        private final guiRadioButton d_queueDensityRB;
        private final guiRadioButton d_queueAreaRB;

        public SpacingPnl(int curveOpts) {
            BiFunction<String, String, guiRadioButton> newRB = (lbl, tt) -> (guiRadioButton)ProfilesPanel.setTooltip(new guiRadioButton((String)lbl), tt);
            BiFunction<Double, Unit, ConstantCurve> cc = (val, unit) -> new ConstantCurve(new UnitDouble((double)val, (Unit)unit));
            this.d_comfortDistRB = newRB.apply(Intl.intl("Personal Distance:"), Intl.intl("The desired separation distance to maintain with other occupants."));
            this.d_personalDist = new VerboseCurveEditor(0, false, curveOpts);
            this.d_personalDist.setValue(cc.apply(0.08, SI.METER));
            LinkStatus.link((AbstractButton)this.d_comfortDistRB, this.d_personalDist.getComponent());
            this.d_queueDensityRB = newRB.apply(Intl.intl("From Queue Density:"), Intl.intl("An approximate occupant density to maintain."));
            this.d_queueDensity = new VerboseCurveEditor(3, false, curveOpts);
            this.d_queueDensity.setValue(cc.apply(4.0, SIUS.unit(3)));
            LinkStatus.link((AbstractButton)this.d_queueDensityRB, this.d_queueDensity.getComponent());
            this.d_queueAreaRB = newRB.apply(Intl.intl("From Queue Area:"), Intl.intl("An approximate amount of area to maintain around the occupant."));
            this.d_queueArea = new VerboseCurveEditor(2, false, curveOpts);
            this.d_queueArea.setValue(cc.apply(0.25, SIUS.unit(2)));
            LinkStatus.link((AbstractButton)this.d_queueAreaRB, this.d_queueArea.getComponent());
            guiUtil.group(new AbstractButton[]{this.d_comfortDistRB, this.d_queueDensityRB, this.d_queueAreaRB});
            GridBagHelper gb = new GridBagHelper(this);
            gb.addIdentRow(this.d_comfortDistRB, this.d_personalDist, 1.0, 0);
            gb.addIdentRow(this.d_queueDensityRB, this.d_queueDensity, 1.0, 0);
            gb.addIdentRow(this.d_queueAreaRB, this.d_queueArea, 1.0, 0);
            gb.finalizeRows();
        }

        public void load(OccProfile.Spacing spacing) {
            if (spacing == null) {
                this.d_queueAreaRB.setSelected(false);
                this.d_queueDensityRB.setSelected(false);
                this.d_comfortDistRB.setSelected(false);
            } else {
                switch (spacing.type) {
                    case AREA: {
                        this.d_queueAreaRB.setSelected(true);
                        this.d_queueArea.setValue(spacing.val);
                        break;
                    }
                    case DENSITY: {
                        this.d_queueDensityRB.setSelected(true);
                        this.d_queueDensity.setValue(spacing.val);
                        break;
                    }
                    case COMFORT_DIST: {
                        this.d_comfortDistRB.setSelected(true);
                        this.d_personalDist.setValue(spacing.val);
                    }
                }
            }
        }

        public OccProfile.Spacing save() {
            ICurve val;
            OccProfile.SpacingType type;
            if (this.d_comfortDistRB.isSelected()) {
                type = OccProfile.SpacingType.COMFORT_DIST;
                val = this.d_personalDist.getValue();
            } else if (this.d_queueAreaRB.isSelected()) {
                type = OccProfile.SpacingType.AREA;
                val = this.d_queueArea.getValue();
            } else if (this.d_queueDensityRB.isSelected()) {
                type = OccProfile.SpacingType.DENSITY;
                val = this.d_queueDensity.getValue();
            } else {
                return null;
            }
            return new OccProfile.Spacing(type, val);
        }
    }

    private static class DoorChoicePanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Door Choice");
        private final IValEditor<ICurve> d_localTime;
        private final IValEditor<ICurve> d_queueTime;
        private final IValEditor<ICurve> d_tailTime;
        private final IValEditor<ICurve> d_elevatorWaitTime;
        private final IValEditor<ICurve> d_currDoorPref;
        private final IValEditor<ICurve> d_doubleDist;
        private final JButton d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));

        public DoorChoicePanel() {
            this.d_resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!ProfilesPanel.checkReset(this, TITLE)) {
                        return;
                    }
                    this.init(new OccProfile());
                    this.setModified(true);
                }
            });
            guiLabel localTimeLbl = ProfilesPanel.newLbl(Intl.intl("Current Room Travel Time:"), Intl.intl("This value affects the cost of travelling to a door in the occupant's\ncurrent room.  Higher values increase a door's cost in this category."));
            this.d_localTime = new VerboseCurveEditor(11, false);
            guiLabel queueLbl = ProfilesPanel.newLbl(Intl.intl("Current Room Queue Time:"), Intl.intl("This value affects the cost of waiting in a queue at a door in the\noccupant's current room.  Higher values increase a door's cost in\nthis category."));
            this.d_queueTime = new VerboseCurveEditor(11, false);
            guiLabel tailLbl = ProfilesPanel.newLbl(Intl.intl("Global Travel Time:"), Intl.intl("This value affects the cost of travelling from a door in the occupant's\ncurrent room to an exit or the occupant's next goal. Higher values increase\na door's cost in this category."));
            this.d_tailTime = new VerboseCurveEditor(11, false);
            guiLabel elevatorWaitTimeLbl = ProfilesPanel.newLbl(Intl.intl("Elevator Wait Time:"), Intl.intl("This value determines for how long occupants wait for an elevator even if there\nis a faster alternative.\n"));
            this.d_elevatorWaitTime = new VerboseCurveEditor(1, false);
            guiLabel currDoorPrefLbl = ProfilesPanel.newLbl(Intl.intl("Current Door Preference:"), Intl.intl("This value is used to help occupants stick to their currently chosen\ndoors, preventing excessive switching.  A value of 100 % will cause\noccupants to never switch doors, and a value of 0 % will allow occupants\nto freely change their selected doors."));
            this.d_currDoorPref = new VerboseCurveEditor(10, false);
            guiLabel doubleLbl = ProfilesPanel.newLbl(Intl.intl("Current Room Distance Penalty:"), Intl.intl("<b>NOTE: Enter <i>0</i> to turn off.</b>\nThis value is used as a simple way to model fatigue.  The further an occupant\ntravels in a room, the more the occupant prefers shorter distances over shorter\ntimes.<br>More precisely, every time the occupant travels this distance in the current\nroom, the overall travel time cost will have doubled."));
            this.d_doubleDist = new VerboseCurveEditor(0, false);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Cost Factors")));
            gb.indent();
            gb.addRow(localTimeLbl, this.d_localTime, 1.0, 0);
            gb.addRow(queueLbl, this.d_queueTime, 1.0, 0);
            gb.addRow(tailLbl, this.d_tailTime, 1.0, 0);
            gb.addRow(elevatorWaitTimeLbl, this.d_elevatorWaitTime, 1.0, 0);
            gb.unindent();
            gb.addFilledRow(new TitleSeparator(Intl.intl("Advanced")));
            gb.indent();
            gb.addRow(currDoorPrefLbl, this.d_currDoorPref, 1.0, 0);
            gb.addRow(doubleLbl, this.d_doubleDist, 1.0, 0);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.unindent();
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_localTime.setValue(dataObj.getProperty(OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR));
            this.d_queueTime.setValue(dataObj.getProperty(OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR));
            this.d_tailTime.setValue(dataObj.getProperty(OccProfile.PROP_TAIL_TIME_FACTOR));
            this.d_elevatorWaitTime.setValue(dataObj.getProperty(OccProfile.PROP_ELEVATOR_WAIT_TIME));
            this.d_currDoorPref.setValue(dataObj.getProperty(OccProfile.PROP_CURR_DOOR_PREF));
            this.d_doubleDist.setValue(dataObj.getProperty(OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY));
            this.setModified(false);
        }

        public OccProfile commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            dataObj.setIfNotDefault(OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR, this.d_localTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR, this.d_queueTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_TAIL_TIME_FACTOR, this.d_tailTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_ELEVATOR_WAIT_TIME, this.d_elevatorWaitTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_CURR_DOOR_PREF, this.d_currDoorPref.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY, this.d_doubleDist.getValue());
            if (changeModified) {
                this.setModified(false);
            }
            return dataObj;
        }
    }

    private static class OutputPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Output");
        private final guiCheckBox d_extraOutput = new guiCheckBox(Intl.intl("Print CSV Data"), false);

        public OutputPanel() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_extraOutput, 0);
            gb.finalizeRows();
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_extraOutput.setSelected(UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_PRINT_EXTRA_OUTPUT)));
            this.setModified(false);
        }

        public OccProfile commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            dataObj.setIfNotDefault(OccProfile.PROP_PRINT_EXTRA_OUTPUT, ProfilesPanel.toUrn(this.d_extraOutput.isSelected()));
            if (changeModified) {
                this.setModified(false);
            }
            return dataObj;
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_extraOutput.isModified() && this.d_extraOutput.isSelected() && showWarn) {
                String msg = Intl.intl("WARNING: Enabling CSV output for many occupants may use significant computing\nresources and/or disk space during simulation. Are you sure you want to enable\nthis feature?");
                int opt = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), msg, Intl.intl("CSV Output"), 0, 2);
                if (opt != 0) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class MovementPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Movement");
        private final JButton d_resetBtn;
        private final guiCheckBox d_assisted;
        private final guiCheckBox d_requiresAssistance;
        private final guiCheckBox d_ignoreOnewayDoors;
        private final guiComboBox<EscalatorPreference> d_escalatorPreference;
        private final VerboseCurveEditor d_orient;
        private final VerboseCurveEditor d_attractorSuscSeek;
        private final VerboseCurveEditor d_attractorSuscWait;
        private final AttractorsRestriction d_attrRestrictions;

        public MovementPanel() {
            MerlinData md = MerlinApp.getApp().getData();
            guiLabel orientLbl = new guiLabel(Intl.intl("Initial Orientation:"));
            orientLbl.setToolTipText(Intl.intl("Set the initial orientation in degrees from positive x axis counter-clockwise"));
            this.d_orient = new VerboseCurveEditor(7, false, UnitDoubleVR.unbounded());
            this.d_assisted = new guiCheckBox(Intl.intl("Requires Assistance"), false);
            this.d_assisted.setToolTipText(Intl.intl("Controls whether the occupants require assistance from others to reach their desired exits."));
            this.d_requiresAssistance = new guiCheckBox(Intl.intl("Requires Assistance to Move"), false);
            this.d_requiresAssistance.setToolTipText(Intl.intl("Recommended for occupants that are unable to move under their own power (e.g. in a bed or other carrying device)."));
            this.d_ignoreOnewayDoors = new guiCheckBox(Intl.intl("Ignore One-way Door Restrictions"), true);
            String ignoreOnewayTT = Intl.intl("Controls whether occupants observe directionality of one-way doors,<br>stairs, and ramps. If they ignore it, they will go through in either <br>direction; if not, they will go only in the required direction.");
            ignoreOnewayTT = "<html>" + ignoreOnewayTT + "</html>";
            this.d_ignoreOnewayDoors.setToolTipText(ignoreOnewayTT);
            guiLabel escalatorPrefLabel = new guiLabel(Intl.intl("Escalator Preference:"));
            this.d_escalatorPreference = guiUtil.newCombo(val -> new Pair<String, Object>(val.name, null), EscalatorPreference.values());
            String EscPrefTT = Intl.intl("Controls if occupants walk on escalators and moving walkways, or if they stand, where they stand");
            escalatorPrefLabel.setToolTipText(EscPrefTT);
            Supplier<VerboseCurveEditor> newSuscEditor = () -> new VerboseCurveEditor(10, false, UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true));
            this.d_attractorSuscSeek = newSuscEditor.get();
            this.d_attractorSuscWait = newSuscEditor.get();
            this.d_attrRestrictions = new AttractorsRestriction(md);
            this.d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));
            this.d_resetBtn.addActionListener(evt -> {
                if (!ProfilesPanel.checkReset(this, TITLE)) {
                    return;
                }
                this.init(new OccProfile());
                this.setModified(true);
            });
            GridBagHelper gb = new GridBagHelper(this);
            if (MerlinApp.isFP()) {
                gb.addRow(this.d_assisted, 1.0, 0);
            }
            gb.addRow(orientLbl, this.d_orient, 1.0, 0);
            gb.addRow(this.d_requiresAssistance, 0);
            gb.addRow(this.d_ignoreOnewayDoors, 0);
            gb.addRow(escalatorPrefLabel, this.d_escalatorPreference, 0);
            gb.addRow(guiUtil.lbl(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK.displayName, OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK.getHtmlDescr()), this.d_attractorSuscSeek, 0);
            gb.addRow(guiUtil.lbl(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE.displayName, OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE.getHtmlDescr()), this.d_attractorSuscWait, 0);
            this.d_attrRestrictions.addToLayout(gb);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.d_attrRestrictions.validateData(this, showWarn, allowModify);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_orient.setValue(dataObj.getProperty(OccProfile.PROP_INIT_ORIENT));
            this.d_assisted.setSelected(UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_ASSIST)));
            this.d_requiresAssistance.setSelected(UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_REQUIRES_ASSISTANCE)));
            this.d_ignoreOnewayDoors.setSelected(UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_OBEY_ONEWAY_DOORS)) == false);
            this.d_escalatorPreference.setSelectedItem((Object)UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_ESCALATOR_PREF)));
            this.d_attractorSuscSeek.setValue(dataObj.getProperty(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK));
            this.d_attractorSuscWait.setValue(dataObj.getProperty(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE));
            this.d_attrRestrictions.setValue(dataObj.getProperty(OccProfile.PROP_ATTRACTOR_RESTRICTIONS));
            this.setModified(false);
        }

        public void commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            dataObj.setIfNotDefault(OccProfile.PROP_ASSIST, ProfilesPanel.toUrn(this.d_assisted.isSelected()));
            dataObj.setIfNotDefault(OccProfile.PROP_REQUIRES_ASSISTANCE, ProfilesPanel.toUrn(this.d_requiresAssistance.isSelected()));
            dataObj.setIfNotDefault(OccProfile.PROP_OBEY_ONEWAY_DOORS, ProfilesPanel.toUrn(!this.d_ignoreOnewayDoors.isSelected()));
            dataObj.setIfNotDefault(OccProfile.PROP_ESCALATOR_PREF, ProfilesPanel.toUrn((Object)this.d_escalatorPreference.getSelectedItem()));
            dataObj.setIfNotDefault(OccProfile.PROP_INIT_ORIENT, this.d_orient.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK, this.d_attractorSuscSeek.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE, this.d_attractorSuscWait.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_ATTRACTOR_RESTRICTIONS, this.d_attrRestrictions.getValue());
            if (changeModified) {
                this.setModified(false);
            }
        }
    }

    public static class AttractorsRestriction
    extends ObjsRestriction<OccProfile.AttractorRestrictions.Mode, Attractor> {
        public AttractorsRestriction(MerlinData md) {
            super(md, Intl.intl("Allowed Attractors:"), Intl.intl("Attractors"), Attractor.class, md.attractors, Predicates.alwaysTrue(), mode -> mode == null ? new Pair<String, String>(Intl.intl("<mixed>"), null) : guiUtil.encodeToHtmlLabel(mode.name, mode.desc), OccProfile.AttractorRestrictions.Mode.FROM_LIST, OccProfile.AttractorRestrictions.Mode.values());
        }

        public void setValue(OccProfile.AttractorRestrictions attrRestr) {
            if (attrRestr == null) {
                this.load(null, true, Collections.emptySet());
                return;
            }
            this.load(attrRestr.mode, !attrRestr.rejected, attrRestr.attractors);
        }

        public OccProfile.AttractorRestrictions getValue() {
            ObjsRestriction.Data attrRestr = this.save();
            return new OccProfile.AttractorRestrictions((OccProfile.AttractorRestrictions.Mode)((Object)attrRestr.mode), !attrRestr.accepted, attrRestr.objs);
        }
    }

    public static class CompRestrictionsPanel {
        private CompRestriction<EgressDoor> d_doorChooser;
        private CompRestriction<EgressRoom> d_roomChooser;
        private CompRestriction<EgressStair> d_stairChooser;
        private CompRestriction<EgressStair> d_escalatorChooser;
        private CompRestriction<EgressCorridor> d_rampChooser;
        private CompRestriction<EgressCorridor> d_movingWalkwayChooser;
        private CompRestriction<Elevator> d_elevatorChooser;
        private final List<CompRestriction> d_allRestrictions = new ArrayList<CompRestriction>();

        public CompRestrictionsPanel() {
            MerlinData md = MerlinApp.getApp().getData();
            this.d_doorChooser = new CompRestriction<EgressDoor>(md, Intl.intl("Use Doors:"), Intl.intl("Restricted Doors"), md.floors, EgressDoor.class, Predicates.alwaysTrue(), cr -> cr.doorInfo, (cr, info) -> {
                cr.doorInfo = info;
            }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST);
            this.d_allRestrictions.add(this.d_doorChooser);
            this.d_roomChooser = new CompRestriction<EgressRoom>(md, Intl.intl("Use Rooms:"), Intl.intl("Restricted Rooms"), md.floors, EgressRoom.class, Predicates.alwaysTrue(), cr -> cr.roomInfo, (cr, info) -> {
                cr.roomInfo = info;
            }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST);
            this.d_allRestrictions.add(this.d_roomChooser);
            this.d_stairChooser = new CompRestriction<EgressStair>(md, Intl.intl("Use Stairs:"), Intl.intl("Restricted Stairs"), md.floors, EgressStair.class, stair -> !stair.isEscalator(), cr -> cr.stairInfo, (cr, info) -> {
                cr.stairInfo = info;
            }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST);
            this.d_allRestrictions.add(this.d_stairChooser);
            this.d_escalatorChooser = new CompRestriction<EgressStair>(md, Intl.intl("Use Escalators:"), Intl.intl("Restricted Escalators"), md.floors, EgressStair.class, stair -> stair.isEscalator(), cr -> cr.escalatorInfo, (cr, info) -> {
                cr.escalatorInfo = info;
            }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.UP_ONLY, OccProfile.CompRestrictions.Mode.DOWN_ONLY, OccProfile.CompRestrictions.Mode.FROM_LIST);
            this.d_allRestrictions.add(this.d_escalatorChooser);
            this.d_rampChooser = new CompRestriction<EgressCorridor>(md, Intl.intl("Use Ramps:"), Intl.intl("Restricted Ramps"), md.floors, EgressCorridor.class, comp -> !(comp instanceof EgressStair) && !comp.isMovingWalkway(), cr -> cr.rampInfo, (cr, info) -> {
                cr.rampInfo = info;
            }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST);
            this.d_allRestrictions.add(this.d_rampChooser);
            this.d_movingWalkwayChooser = new CompRestriction<EgressCorridor>(md, Intl.intl("Use Moving Walkways:"), Intl.intl("Restricted Moving Walkways"), md.floors, EgressCorridor.class, comp -> !(comp instanceof EgressStair) && comp.isMovingWalkway(), cr -> cr.movingWalkwayInfo, (cr, info) -> {
                cr.movingWalkwayInfo = info;
            }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST);
            this.d_allRestrictions.add(this.d_movingWalkwayChooser);
            this.d_elevatorChooser = new CompRestriction<Elevator>(md, Intl.intl("Use Elevators:"), Intl.intl("Restricted Elevators"), md.elevators, Elevator.class, Predicates.alwaysTrue(), cr -> cr.elevatorInfo, (cr, info) -> {
                cr.elevatorInfo = info;
            }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST, OccProfile.CompRestrictions.Mode.FROM_BEHAVIOR);
            this.d_allRestrictions.add(this.d_elevatorChooser);
            int maxModeWidth = this.d_allRestrictions.stream().mapToInt(r -> r.d_modeCB.getPreferredSize().width).max().getAsInt();
            this.d_allRestrictions.stream().forEach(r -> r.d_modeCB.setPreferredSize(new Dimension(maxModeWidth, r.d_modeCB.getPreferredSize().height)));
        }

        public boolean validateData(Component parent, boolean allowWarn, boolean allowEdit) {
            return this.d_allRestrictions.stream().allMatch(r -> r.validateData(parent, allowWarn, allowEdit));
        }

        public void init(OccProfile dataObj) {
            OccProfile.CompRestrictions compRestrictions = dataObj.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS);
            this.init(compRestrictions);
        }

        public void init(OccProfile.CompRestrictions compRestrictions) {
            for (CompRestriction restr : this.d_allRestrictions) {
                restr.initCompRestrictions(compRestrictions);
            }
        }

        public OccProfile.CompRestrictions commit() {
            OccProfile.CompRestrictions restrictions = new OccProfile.CompRestrictions();
            for (CompRestriction restr : this.d_allRestrictions) {
                restr.commitRestrictions(restrictions);
            }
            return restrictions;
        }

        public void addToLayout(GridBagHelper gb) {
            for (CompRestriction restr : this.d_allRestrictions) {
                restr.addToLayout(gb);
            }
        }
    }

    private static class CompRestriction<T extends IMerlinObj>
    extends ObjsRestriction<OccProfile.CompRestrictions.Mode, T> {
        public final Function<OccProfile.CompRestrictions, OccProfile.CompRestrictions.CompRestrictionsInfo> d_getInfo;
        public final BiConsumer<OccProfile.CompRestrictions, OccProfile.CompRestrictions.CompRestrictionsInfo> d_setInfo;

        public CompRestriction(MerlinData md, String compLbl, String chooserLbl, Composite<?> objRoot, Class<T> objType, Predicate<? super T> allowedObjs, Function<OccProfile.CompRestrictions, OccProfile.CompRestrictions.CompRestrictionsInfo> getInfo, BiConsumer<OccProfile.CompRestrictions, OccProfile.CompRestrictions.CompRestrictionsInfo> setInfo, OccProfile.CompRestrictions.Mode ... allowedModes) {
            super(md, compLbl, chooserLbl, objType, objRoot, allowedObjs, (ModeT mode) -> new Pair<String, String>(guiUtil.encodeToHtmlLabel(mode.name), guiUtil.encodeToHtmlLabel(mode.desc)), OccProfile.CompRestrictions.Mode.FROM_LIST, allowedModes);
            this.d_getInfo = getInfo;
            this.d_setInfo = setInfo;
        }

        public void initCompRestrictions(OccProfile.CompRestrictions restrictions) {
            if (restrictions == null) {
                this.load(null, true, Collections.emptySet());
                return;
            }
            OccProfile.CompRestrictions.CompRestrictionsInfo compInfo = this.d_getInfo.apply(restrictions);
            this.load(compInfo.mode, !compInfo.rejected, theUtil.filter(restrictions.getObjs(this.clazz), this.d_chooser.getFilter()));
        }

        public void commitRestrictions(OccProfile.CompRestrictions restrictions) {
            ObjsRestriction.Data data = this.save();
            OccProfile.CompRestrictions.CompRestrictionsInfo info = new OccProfile.CompRestrictions.CompRestrictionsInfo();
            info.mode = (OccProfile.CompRestrictions.Mode)((Object)data.mode);
            switch ((OccProfile.CompRestrictions.Mode)((Object)data.mode)) {
                case NONE: 
                case FROM_BEHAVIOR: {
                    info.rejected = false;
                    break;
                }
                case ALL: 
                case UP_ONLY: 
                case DOWN_ONLY: {
                    info.rejected = true;
                    break;
                }
                case FROM_LIST: {
                    info.rejected = !data.accepted;
                    restrictions.addAll(data.objs);
                }
            }
            this.d_setInfo.accept(restrictions, info);
        }
    }

    private static class ObjsRestriction<ModeT, ObjT extends IMerlinObj> {
        public final Class<ObjT> clazz;
        public final guiLabel d_compLbl;
        public final guiComboBox<ModeT> d_modeCB;
        public final SetChooser<ObjT> d_chooser;
        public final guiComboBox<Boolean> d_acceptCB;
        public final ModeT d_fromListMode;

        public ObjsRestriction(MerlinData md, String compLbl, String chooserLbl, Class<ObjT> objType, Composite<?> objRoot, Predicate<? super ObjT> allowedObjs, Function<ModeT, Pair<String, String>> restrFormat, ModeT fromListMode, ModeT ... allowedModes) {
            this.clazz = objType;
            this.d_fromListMode = fromListMode;
            this.d_compLbl = new guiLabel(compLbl);
            this.d_modeCB = guiUtil.newCombo(restrFormat, allowedModes);
            int chooserOpt = 1;
            this.d_chooser = new SetChooser<ObjT>(md, chooserLbl, Intl.intl("none"), chooserOpt, objRoot, objType, allowedObjs);
            this.d_acceptCB = guiUtil.newCombo(Boolean.valueOf(true), Intl.intl("Accept"), false, Intl.intl("Reject"));
            Runnable updateVis = () -> {
                boolean visible = this.d_modeCB.getSelectedItem() == this.d_fromListMode;
                this.d_acceptCB.setVisible(visible);
                this.d_chooser.setVisible(visible);
            };
            this.d_modeCB.addItemListener(e -> updateVis.run());
            updateVis.run();
        }

        public void addToLayout(GridBagHelper gb) {
            Dimension d = new Dimension(220, 24);
            guiPanel doorPlaceHolder = new guiPanel();
            doorPlaceHolder.setPreferredSize(d);
            GridBagHelper tempGB = new GridBagHelper(doorPlaceHolder);
            tempGB.addRow(this.d_acceptCB, this.d_chooser, new double[]{1.0, 0.0});
            gb.addRow(this.d_compLbl, this.d_modeCB, doorPlaceHolder, new double[]{1.0, 0.0});
        }

        public boolean validateData(Component parent, boolean allowWarn, boolean allowEdit) {
            if (this.d_modeCB.getSelectedItem() == null) {
                if (allowWarn) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(parent), Intl.intl("An empty selection is not allowed."), Intl.intl("Invalid data"), 0);
                }
                return false;
            }
            return true;
        }

        public void load(ModeT mode, boolean accepted, Set<ObjT> fromListObjs) {
            this.d_modeCB.setSelectedItem(mode);
            this.d_acceptCB.setSelectedItem(accepted);
            this.d_chooser.setObjs(fromListObjs);
        }

        public Data save() {
            ModeT mode = this.d_modeCB.getSelectedItem();
            if (mode == this.d_fromListMode) {
                return new Data(mode, this.d_acceptCB.getSelectedItem(), this.d_chooser.getObjs());
            }
            return new Data(mode, true, Collections.emptySet());
        }

        protected class Data {
            public final ModeT mode;
            public final boolean accepted;
            public final Set<ObjT> objs;

            public Data(ModeT mode, boolean accepted, Set<ObjT> objs) {
                this.mode = mode;
                this.accepted = accepted;
                this.objs = objs;
            }
        }
    }

    public static class RestrictionsPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        public static final String TITLE = Intl.intl("Restrictions");
        private final JButton d_resetBtn;
        private final CompRestrictionsPanel d_restrictionsPnl = new CompRestrictionsPanel();

        public RestrictionsPanel() {
            this.d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));
            this.d_resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!ProfilesPanel.checkReset(this, TITLE)) {
                        return;
                    }
                    this.init(new OccProfile());
                    this.setModified(true);
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            this.d_restrictionsPnl.addToLayout(gb);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            this.d_restrictionsPnl.init(dataObj);
        }

        public void commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            dataObj.setIfNotDefault(OccProfile.PROP_RESTRICTED_COMPONENTS, this.d_restrictionsPnl.commit());
            if (changeModified) {
                this.setModified(false);
            }
        }
    }

    public static class ProfileFunctionEditor
    extends AValEditor<OccProfile.ConstProfileFunction> {
        private static final long serialVersionUID = 1L;
        private final IValEditor<? extends IFunction1d> d_fed;

        public ProfileFunctionEditor(IValEditor<? extends IFunction1d> fed) {
            super(OccProfile.ConstProfileFunction.class);
            this.d_fed = this.registerEd(fed);
            GridBagHelper gb = new GridBagHelper(this);
            this.add(gb);
            gb.finalizeRows();
        }

        @Override
        public void add(GridBagHelper gb) {
            this.d_fed.add(gb);
        }

        @Override
        protected void loadValue(OccProfile.ConstProfileFunction value) {
            this.d_fed.setValue(value.function);
        }

        @Override
        protected OccProfile.ConstProfileFunction saveValue() {
            return new OccProfile.ConstProfileFunction(this.d_fed.getValue());
        }
    }

    private static class SlopedSpeedEditor
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final Function1dProp d_upSpeedProp;
        private final OccProfile.ProfileFunctionProp d_upFundProp;
        private final Function1dProp d_downSpeedProp;
        private final OccProfile.ProfileFunctionProp d_downFundProp;
        private final IValEditor<IFunction1d> d_upEditor;
        private final IValEditor<OccProfile.IProfileFunction> d_upFundEditor;
        private final IValEditor<IFunction1d> d_downEditor;
        private final IValEditor<OccProfile.IProfileFunction> d_downFundEditor;

        public SlopedSpeedEditor(String compDesc, Supplier<IFunction1d> levelFund, Function1dProp upSpeedProp, OccProfile.ProfileFunctionProp upFundProp, Function1dProp downSpeedProp, OccProfile.ProfileFunctionProp downFundProp, IFunction1d sfpeFunc) {
            this.d_upSpeedProp = upSpeedProp;
            this.d_upFundProp = upFundProp;
            this.d_downSpeedProp = downSpeedProp;
            this.d_downFundProp = downFundProp;
            this.d_upEditor = this.registerEd(Function1dEditorFactory.nonNullable(upSpeedProp, false, () -> null, 7));
            this.d_upFundEditor = this.registerEd(ProfilesPanel.newSlopedFundEditor(this.d_upFundProp, levelFund));
            this.d_downEditor = this.registerEd(Function1dEditorFactory.nonNullable(downSpeedProp, false, () -> null, 7));
            this.d_downFundEditor = this.registerEd(ProfilesPanel.newSlopedFundEditor(this.d_downFundProp, levelFund));
            guiLabel fracUp = ProfilesPanel.newLabel(upSpeedProp);
            guiLabel densUp = ProfilesPanel.newLabel(upFundProp.fprop);
            guiLabel fracDown = ProfilesPanel.newLabel(downSpeedProp);
            guiLabel densDown = ProfilesPanel.newLabel(downFundProp.fprop);
            GridBagHelper gb = new GridBagHelper(this);
            gb.add(fracUp);
            this.d_upEditor.add(gb);
            gb.nextRow();
            gb.add(densUp);
            this.d_upFundEditor.add(gb);
            gb.nextRow();
            gb.add(fracDown);
            this.d_downEditor.add(gb);
            gb.nextRow();
            gb.add(densDown);
            this.d_downFundEditor.add(gb);
            gb.nextRow();
            gb.finalizeRows();
        }

        private <T extends IValEditor<?>> T registerEd(T editor) {
            editor.addValueListener(e -> this.firePropertyChange("value", e.getOldValue(), e.getNewValue()));
            return editor;
        }

        public void load(OccProfile profile) {
            this.d_upEditor.setValue(profile.getProperty(this.d_upSpeedProp));
            this.d_upFundEditor.setValue(profile.getProperty(this.d_upFundProp));
            this.d_downEditor.setValue(profile.getProperty(this.d_downSpeedProp));
            this.d_downFundEditor.setValue(profile.getProperty(this.d_downFundProp));
        }

        public void save(OccProfile profile) {
            profile.setIfNotDefault(this.d_upSpeedProp, this.d_upEditor.getValue());
            profile.setIfNotDefault(this.d_upFundProp, this.d_upFundEditor.getValue());
            profile.setIfNotDefault(this.d_downSpeedProp, this.d_downEditor.getValue());
            profile.setIfNotDefault(this.d_downFundProp, this.d_downFundEditor.getValue());
        }
    }

    private static class AdvancedSpeedEditor
    extends AValEditor<OccProfile> {
        private static final long serialVersionUID = 1L;
        private final VerboseCurveEditor d_levelSpeed = this.registerEd(new VerboseCurveEditor(5, false));
        private final IValEditor<IFunction1d> d_levelFundamental = this.registerEd(Function1dEditorFactory.nonNullable(OccProfile.PROP_FUNDAMENTAL, false, () -> null, 7));
        private final SlopedSpeedEditor d_stairEditor;
        private final SlopedSpeedEditor d_rampEditor;

        public AdvancedSpeedEditor() {
            super(OccProfile.class);
            guiPanel levelPnl = new guiPanel();
            GridBagHelper gb = new GridBagHelper(levelPnl, true);
            gb.add(Intl.intl("Speed:"));
            this.d_levelSpeed.add(gb);
            gb.nextRow();
            gb.add(ProfilesPanel.newLabel(OccProfile.PROP_FUNDAMENTAL));
            this.d_levelFundamental.add(gb);
            gb.nextRow();
            gb.finalizeRows();
            this.d_stairEditor = this.registerEd(new SlopedSpeedEditor(Intl.intl("Stair"), () -> this.d_levelFundamental.getValue(), OccProfile.PROP_STAIR_SPEED_UP, OccProfile.PROP_STAIR_FUNDAMENTAL_UP, OccProfile.PROP_STAIR_SPEED_DOWN, OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN, OccProfile.SFPE_STAIR_FUNCTION));
            this.d_rampEditor = this.registerEd(new SlopedSpeedEditor(Intl.intl("Ramp"), () -> this.d_levelFundamental.getValue(), OccProfile.PROP_RAMP_SPEED_UP, OccProfile.PROP_RAMP_FUNDAMENTAL_UP, OccProfile.PROP_RAMP_SPEED_DOWN, OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN, OccProfile.SFPE_RAMP_FUNCTION));
            guiPanel stairsPnl = new guiPanel();
            gb = new GridBagHelper(stairsPnl, true);
            gb.addFilledRow(this.d_stairEditor);
            gb.finalizeRows();
            guiPanel rampsPnl = new guiPanel();
            gb = new GridBagHelper(rampsPnl, true);
            gb.addFilledRow(this.d_rampEditor);
            gb.finalizeRows();
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab(Intl.intl("Level Terrain"), levelPnl);
            tabs.addTab(Intl.intl("Stairs"), stairsPnl);
            tabs.addTab(Intl.intl("Ramps"), rampsPnl);
            JButton resetButton = new JButton(Intl.intl("Reset to Defaults..."));
            resetButton.setToolTipText(Intl.intl("Resets the advanced speed properties."));
            resetButton.addActionListener(e -> {
                if (!ProfilesPanel.checkReset(this, Intl.intl("Speed"))) {
                    return;
                }
                this.setValue(new OccProfile());
            });
            gb = new GridBagHelper(this);
            gb.addFilledRow(tabs);
            gb.addFilledRow("<html>" + Intl.intl("NOTE: When simulating in SFPE mode, all advanced speed properties are ignored except for <i>Speed</i>."));
            gb.addRow(resetButton, 0);
            gb.finalizeRows();
        }

        @Override
        protected void updateValue() {
            super.updateValue();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }

        @Override
        protected void loadValue(OccProfile value) {
            this.d_levelSpeed.setValue(value.getProperty(OccProfile.PROP_MAXVEL));
            this.d_levelFundamental.setValue(value.getProperty(OccProfile.PROP_FUNDAMENTAL));
            this.d_stairEditor.load(value);
            this.d_rampEditor.load(value);
        }

        @Override
        protected OccProfile saveValue() {
            OccProfile adv = new OccProfile();
            adv.setIfNotDefault(OccProfile.PROP_MAXVEL, this.d_levelSpeed.getValue());
            adv.setIfNotDefault(OccProfile.PROP_FUNDAMENTAL, this.d_levelFundamental.getValue());
            this.d_stairEditor.save(adv);
            this.d_rampEditor.save(adv);
            return adv;
        }

        public static String format(OccProfile adv) {
            StringBuilder str = new StringBuilder();
            str.append(String.format(Intl.intl("Speed=%s"), guiCurveUtil.format(adv.getProperty(OccProfile.PROP_MAXVEL))));
            if (AdvancedSpeedEditor.isCustom(adv, OccProfile.PROP_FUNDAMENTAL)) {
                str.append("; ");
                str.append(Intl.intl("Custom speed-density profile"));
            }
            if (AdvancedSpeedEditor.isCustom(adv, OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN, OccProfile.PROP_STAIR_FUNDAMENTAL_UP, OccProfile.PROP_STAIR_SPEED_DOWN, OccProfile.PROP_STAIR_SPEED_UP)) {
                str.append("; ");
                str.append(Intl.intl("Custom stair speed"));
            }
            if (AdvancedSpeedEditor.isCustom(adv, OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN, OccProfile.PROP_RAMP_FUNDAMENTAL_UP, OccProfile.PROP_RAMP_SPEED_DOWN, OccProfile.PROP_RAMP_SPEED_UP)) {
                str.append("; ");
                str.append(Intl.intl("Custom ramp speed"));
            }
            return str.toString();
        }

        private static boolean isCustom(OccProfile profile, IPropertySet.Prop<?> ... props) {
            for (IPropertySet.Prop<?> prop : props) {
                if (Objects.equals(profile.getProperty(prop), prop.defVal)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ProfileSpeedEditor
    extends AValEditor<OccProfile> {
        private static final long serialVersionUID = 1L;
        private final IValEditor<? extends ICurve> d_curveEditor;

        public ProfileSpeedEditor(IValEditor<? extends ICurve> curveEditor) {
            super(OccProfile.class);
            this.d_curveEditor = curveEditor;
            this.d_curveEditor.addValueListener(e -> this.updateValue());
            this.add(this.d_curveEditor.getComponent());
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this.d_curveEditor.getComponent(), 1.0);
        }

        @Override
        protected void loadValue(OccProfile value) {
            this.d_curveEditor.setValue(value.getProperty(OccProfile.PROP_MAXVEL));
        }

        @Override
        protected OccProfile saveValue() {
            OccProfile result = new OccProfile();
            result.setProperty(OccProfile.PROP_MAXVEL, this.d_curveEditor.getValue());
            return result;
        }
    }

    private static class CharPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Characteristics");
        private final IValEditor<OccProfile> d_speed;
        private final guiIntField d_priorityFld;
        private final JButton d_resetBtn;
        private final ShapePnl d_shapePnl;

        public CharPanel() {
            guiLabel speedLbl = ProfilesPanel.newLbl(Intl.intl("Speed:"), Intl.intl("The occupant's maximum velocity"));
            this.d_speed = ProfilesPanel.newSpeedEditor();
            guiLabel priorityLbl = ProfilesPanel.newLbl(Intl.intl("Priority Level:"), Intl.intl("The priority of the occupant.  Higher values indicate higher priority."));
            this.d_priorityFld = new guiIntField(IntVR.above(0, true));
            this.d_priorityFld.setColumns(6);
            this.d_shapePnl = new ShapePnl(15);
            this.d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));
            this.d_resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!ProfilesPanel.checkReset(this, TITLE)) {
                        return;
                    }
                    this.init(new OccProfile());
                    this.setModified(true);
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(new Object[]{priorityLbl, this.d_priorityFld, 1, GridBagHelper.Fill.HORIZONTAL});
            gb.add(speedLbl);
            this.d_speed.add(gb);
            this.d_shapePnl.add(gb, (Component)this);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_speed.setValue(this.getSpeedVal(dataObj));
            this.d_priorityFld.setValue(UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_PRIORITY_LEVEL)));
            this.d_shapePnl.load(dataObj.getProperty(OccProfile.PROP_SHAPE));
            this.setModified(false);
        }

        private static <T> IUrn<T> toUrn(T value) {
            return new Urn<Object>(value);
        }

        public void commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            this.saveSpeed(dataObj, this.d_speed.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_PRIORITY_LEVEL, CharPanel.toUrn(this.d_priorityFld.getValue()));
            dataObj.setIfNotDefault(OccProfile.PROP_SHAPE, this.d_shapePnl.save());
            if (changeModified) {
                this.setModified(false);
            }
        }

        private OccProfile getSpeedVal(OccProfile val) {
            OccProfile adv = new OccProfile();
            CharPanel.copyAdvancedVals(val, adv);
            return adv;
        }

        private void saveSpeed(OccProfile val, OccProfile speed) {
            CharPanel.copyAdvancedVals(speed, val);
        }

        private static void copyAdvancedVals(OccProfile src, OccProfile target) {
            for (IPropertySet.Prop prop : ADVANCED_SPEED_PROPS) {
                target.setIfNotDefault(prop, src.getProperty(prop));
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.d_shapePnl.validateData(showWarn, allowModify);
        }
    }

    public static class Op
    extends Undo.RestoreOp {
        private Collection<EgressAgent> d_agentsUsing;

        public Op(OccProfile prof, Object restoreObj, boolean selected, Collection<EgressAgent> agentsUsing) {
            super(prof, restoreObj, selected);
            this.d_agentsUsing = agentsUsing;
        }

        @Override
        public Undo.RestoreOp perform(MerlinSelectionModel sel) {
            Undo.RestoreOp op = super.perform(sel);
            ProfilesPanel.updateAgents(this.d_agentsUsing);
            return new Op((OccProfile)op.getObj(), op.getMomento(), op.getSelect(), this.d_agentsUsing);
        }
    }
}

