/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.gui.PointListEditor;
import merlin.gui.guiUtil;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiPanel;

public class PolygonEditor
extends guiPanel {
    private static final long serialVersionUID = 3642136365364432751L;
    private final PointListEditor d_pointEditor;
    private boolean d_isPolygon;

    public PolygonEditor(boolean showZ, int options, boolean isPolygon) {
        super(new GridBagLayout());
        this.d_isPolygon = isPolygon;
        this.setMinimumSize(new Dimension(350, 180));
        this.d_pointEditor = new PointListEditor(this.d_isPolygon, showZ, options, true);
        GridBagUtil.add(this, this.d_pointEditor, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
    }

    public int getNumSides() {
        return this.d_pointEditor.getNumPoints();
    }

    public String getGeomName() {
        return Intl.intl("Polygon");
    }

    public guiPanel getPanel() {
        return this;
    }

    public void addPoint(Point3d point) {
        this.d_pointEditor.setPoint(point, this.d_pointEditor.getNumPoints());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        int[] nonCoplanar;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        Point3d[] points = this.getPoints();
        if (points == null) {
            this.error(showWarn, Intl.intl("Empty cells are not permitted."));
            return false;
        }
        if (this.d_isPolygon && points.length < 3) {
            this.error(showWarn, Intl.intl("Polygons must have at least 3 points."));
            return false;
        }
        if (this.d_pointEditor.getShowZ() && (nonCoplanar = Util3D.getNonCoplanar(1.0E-6, points)).length > 0) {
            if (allowModify) {
                this.d_pointEditor.markRows(nonCoplanar);
            }
            this.error(showWarn, Intl.intl("All points must be coplanar."));
            return false;
        }
        return true;
    }

    private void error(boolean show, String msg) {
        if (show) {
            JOptionPane.showMessageDialog(guiUtil.getWindow(this), msg, Intl.intl("Invalid Polygon"), 0);
        }
    }

    private Point3d[] getPoints() {
        List<Point3d> points = this.d_pointEditor.save();
        if (points == null) {
            return null;
        }
        return points.toArray(new Point3d[points.size()]);
    }

    public void load(IPolygon polygon) {
        if (polygon == null) {
            this.d_pointEditor.load(Collections.EMPTY_LIST);
            return;
        }
        assert (polygon.getNumLoops() == 1);
        Point3d[] points = PolyUtil.getLoop(polygon, 0, false);
        this.load(points);
    }

    public void load(Point3d[] points) {
        if (points == null) {
            this.d_pointEditor.load(Collections.EMPTY_LIST);
            return;
        }
        this.d_pointEditor.load(Arrays.asList(points));
    }

    public IPolygon savePolygon() {
        Point3d[] points = this.getPoints();
        return points == null || points.length == 0 ? null : PolyUtil.newPoly(points);
    }

    public Point3d[] savePoints() {
        return this.getPoints();
    }

    public TableModel getModel() {
        return this.d_pointEditor.getModel();
    }

    public void setPoint(Point3d newPoint, int index) {
        this.d_pointEditor.setPoint(newPoint, index);
    }

    public void addPoint(Point3d newPoint, int index) {
        this.d_pointEditor.addPoint(newPoint, index);
    }

    public void removePoint(int index) {
        this.d_pointEditor.removePoint(index);
    }

    public void selectRow(int index) {
        this.d_pointEditor.selectRow(index);
    }

    public void clearSelection() {
        this.d_pointEditor.clearSelection();
    }

    public ListSelectionModel getSelectionModel() {
        return this.d_pointEditor.getSelectionModel();
    }

    public int[] getSelectedRows() {
        return this.d_pointEditor.getSelectedRows();
    }

    public PointListEditor getPointListEditor() {
        return this.d_pointEditor;
    }
}

