/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.io.File;
import java.util.Optional;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.data.material.MaterialDB;
import merlin.gui.guiUtil;
import thunderheadeng.gui.ImageBtn;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.gui.materialdlg.IImageBtnListener;

public class ImageBtnListener
implements IImageBtnListener {
    public static final ImageBtnListener INSTANCE = new ImageBtnListener();
    private String d_lastChoice;

    @Override
    public void setDefaultFile(File dir) {
        this.d_lastChoice = dir.getAbsolutePath();
    }

    @Override
    public boolean chooseNewImage(ImageBtn btn, String name) {
        Optional<Object> startingDir = Optional.empty();
        if (btn.getImage() != null) {
            startingDir = Optional.of(btn.getImage().getFilename());
        } else if (this.d_lastChoice != null) {
            startingDir = Optional.of(this.d_lastChoice);
        }
        guiFileChooser chooser = guiUtil.getChooser(MerlinPrefs.OPEN_DIR_PREF, startingDir, MerlinApp.getApp().getData().materials.getFileFilters());
        chooser.setDialogTitle(String.format(Intl.intl("Choose %s Image"), name));
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(btn)) != 0) {
            return false;
        }
        File f = chooser.getSelectedFile();
        this.d_lastChoice = f.getAbsolutePath();
        IImage img = MaterialDB.loadImage(f.getAbsolutePath());
        if (img == null) {
            return false;
        }
        if (img != btn.getImage()) {
            btn.setImage(img);
            btn.setModified(true);
        }
        return true;
    }
}

