/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorComposite;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.SortCache;

public class FloorListModel
extends AbstractListModel<Object>
implements IEventObserver {
    private static final long serialVersionUID = -6932102919775527155L;
    private SortCache<Object> d_floorCache;
    private final MerlinData d_data;

    public FloorListModel(MerlinData data) {
        this.d_data = data;
        this.regenFloorCache();
    }

    public MerlinData getData() {
        return this.d_data;
    }

    private void regenFloorCache() {
        this.d_floorCache = new SortCache(this.getFloors(this.d_data));
    }

    private SortCache<Object> getFloorCache() {
        return this.d_floorCache;
    }

    protected Collection<?> getFloors(MerlinData md) {
        return md.floors.getMembers(Floor.class);
    }

    public Object getFloor(int index) {
        return this.getFloorCache().get(index);
    }

    @Override
    public Object getElementAt(int index) {
        return this.getFloor(index);
    }

    @Override
    public int getSize() {
        return this.getFloorCache().size();
    }

    @Override
    public void update(Events events) {
        TreeSet<Integer> removedIxes = new TreeSet<Integer>();
        for (EventChannel<Floor> channel : events.getAffectedChannels(Floor.class, new Class[0])) {
            this.getIxes(removedIxes, channel.getRemovedObjs());
        }
        List<int[]> removedIntervals = this.getIntervals(removedIxes);
        for (int m = removedIntervals.size() - 1; m >= 0; --m) {
            int[] interval = removedIntervals.get(m);
            this.fireIntervalRemoved(this, interval[0], interval[1]);
        }
        for (EventChannel<FloorComposite> channel : events.getAffectedChannels(FloorComposite.class, new Class[0])) {
            if (!channel.hasChangedObjs(MerlinData.CHILD_ADDED) && !channel.hasChangedObjs(MerlinData.CHILD_REMOVED) && !channel.hasChangedObjs(MerlinData.CHILDREN_CHANGED)) continue;
            this.regenFloorCache();
            break;
        }
        TreeSet<Integer> addedIxes = new TreeSet<Integer>();
        TreeSet<Integer> changedIxes = new TreeSet<Integer>();
        for (EventChannel<Floor> channel : events.getAffectedChannels(Floor.class, new Class[0])) {
            this.getIxes(addedIxes, channel.getAddedObjs());
            this.getIxes(changedIxes, channel.getChangedObjs(new Object[0]));
        }
        for (int[] interval : this.getIntervals(addedIxes)) {
            this.fireIntervalAdded(this, interval[0], interval[1]);
        }
        for (int[] interval : this.getIntervals(changedIxes)) {
            this.fireContentsChanged(this, interval[0], interval[1]);
        }
    }

    public int indexOf(Object floor) {
        return this.getFloorCache().indexOf(floor);
    }

    private void getIxes(Collection<Integer> ixes, Collection<? extends Floor> floors) {
        SortCache<Object> floorCache = this.getFloorCache();
        for (Floor floor : floors) {
            int ix = floorCache.indexOf(floor);
            ixes.add(ix);
        }
    }

    private List<int[]> getIntervals(SortedSet<Integer> ixes) {
        int i1;
        if (ixes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<int[]> intervals = new ArrayList<int[]>();
        Iterator it = ixes.iterator();
        int i2 = i1 = ((Integer)it.next()).intValue();
        while (it.hasNext()) {
            Integer i = (Integer)it.next();
            if (i != i2 + 1) {
                intervals.add(new int[]{i1, i2});
                i1 = i;
            }
            i2 = i;
        }
        intervals.add(new int[]{i1, i2});
        return intervals;
    }
}

