/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.actions.CreateElevator;
import merlin.data.egress.Floor;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.elevators.ITimingModel;
import merlin.gui.NewElevatorDlg;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.units.UnitDouble;

public class ElevatorLevelDlg
extends guiDialog {
    private static final long serialVersionUID = -262599694019603607L;
    private guiTable d_table;
    private JButton d_btnReset = new JButton(Intl.intl("Reset..."));

    public ElevatorLevelDlg(Window parent, Map<Floor, Elevator.LevelData> data, final Elevator elevator) {
        super(parent, Intl.intl("Elevator Levels"), 9);
        this.updateButtonBar();
        this.setResizable(true);
        guiDefaultTableModel model = new guiDefaultTableModel(data.size(), 5, false, data.size(), false, 4);
        model.setColumnClass(UnitDouble.class);
        model.setColumnClass(0, Floor.class);
        ArrayList<Map.Entry<Floor, Elevator.LevelData>> sortedFloors = new ArrayList<Map.Entry<Floor, Elevator.LevelData>>(data.entrySet());
        Collections.sort(sortedFloors, (o1, o2) -> ((Floor)o1.getKey()).getWorkingZ().compareTo(((Floor)o2.getKey()).getWorkingZ()));
        for (int m = 0; m < sortedFloors.size(); ++m) {
            Elevator.LevelData ls = (Elevator.LevelData)((Map.Entry)sortedFloors.get(m)).getValue();
            model.setValueAt(((Map.Entry)sortedFloors.get(m)).getKey(), m, 0);
            if (ls == null) continue;
            model.setValueAt(ls.delay, m, 1);
            model.setValueAt(ls.openTime.add(ls.closeTime), m, 2);
            model.setValueAt(ls.pickupTime, m, 3);
            model.setValueAt(ls.dischargeTime, m, 4);
        }
        this.d_table = new guiTable((TableModel)model, 0);
        this.d_table.setDefaultRenderer(Floor.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -4522168946834984796L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(((Floor)value).getName());
                return this;
            }
        });
        this.d_table.setDefaultRenderer(UnitDouble.class, new guiTable.UnitDoubleRenderer());
        this.d_table.setDefaultEditor(UnitDouble.class, new guiTable.UnitDoubleEditor(SI.SECOND));
        this.d_table.setColumnEditable(0, false);
        TableColumnModel tcm = this.d_table.getColumnModel();
        tcm.getColumn(0).setHeaderValue(Intl.intl("Floor"));
        tcm.getColumn(1).setHeaderValue(Intl.intl("Delay"));
        tcm.getColumn(2).setHeaderValue(Intl.intl("Open+Close Time"));
        tcm.getColumn(3).setHeaderValue(Intl.intl("Pickup Time"));
        tcm.getColumn(4).setHeaderValue(Intl.intl("Discharge Time"));
        this.d_table.autoSizeColumns();
        this.d_btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ITimingModel timMdl;
                if (elevator == null) {
                    JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Cannot compute level data for multiple discharge floors.  Please reset elevators individually."), Intl.intl("Selection error"), 0);
                    return;
                }
                guiDialog timingDlg = new guiDialog((Window)ElevatorLevelDlg.this, Intl.intl("Elevator Timing"), 9);
                NewElevatorDlg.TimingPnl timingPnl = new NewElevatorDlg.TimingPnl();
                timingDlg.getDialogPane().add(timingPnl);
                timingPnl.load(CreateElevator.getLastTimingModel());
                if (timingDlg.doModal() == 1 && (timMdl = timingPnl.save()) != null) {
                    Point3d basePt = elevator.getDischargeRoom().getBounds().getMin();
                    int m = 0;
                    for (ElevatorRoom er : elevator.getDeepMembers(ElevatorRoom.class)) {
                        Point3d erPt = er.getBounds().getMin();
                        double dist = erPt.distance(basePt);
                        UnitDouble time = new UnitDouble(timMdl.getTime(dist), SI.SECOND);
                        ElevatorLevelDlg.this.d_table.getModel().setValueAt(new UnitDouble(timMdl.getOpenCloseTimes()[0] + timMdl.getOpenCloseTimes()[1], SI.SECOND), m, 2);
                        ElevatorLevelDlg.this.d_table.getModel().setValueAt(time, m, 3);
                        ElevatorLevelDlg.this.d_table.getModel().setValueAt(time, m, 4);
                        ++m;
                    }
                }
            }
        });
        JScrollPane tablesp = new JScrollPane(this.d_table);
        tablesp.setPreferredSize(new Dimension(tablesp.getPreferredSize().width, 200));
        this.getDialogPane().add((Component)tablesp, "Center");
    }

    private void updateButtonBar() {
        guiPanel buttonPanel = this.getButtonPanel();
        buttonPanel.removeAll();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 11, 11, 10));
        GridBagHelper gbh = new GridBagHelper(buttonPanel);
        gbh.addRow(this.d_btnReset, Box.createHorizontalGlue(), 1.0, this.getButton(1), this.getButton(8));
        this.getRootPane().setDefaultButton(this.getButton(1));
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        for (int m = 0; m < this.d_table.getModel().getRowCount(); ++m) {
            int emptyCount = 0;
            for (int n = 1; n < 5; ++n) {
                Object val = this.d_table.getModel().getValueAt(m, n);
                if (val != null) continue;
                ++emptyCount;
            }
            if (emptyCount <= 0 || emptyCount >= 4) continue;
            if (allowModify) {
                this.d_table.setRowSelectionInterval(m, m);
                this.d_table.setColumnSelectionInterval(1, 4);
            }
            if (showWarn) {
                ElevatorLevelDlg.showInvalidEntryMessage(this, Intl.intl("Each row must be completely filled in or empty."));
            }
            return false;
        }
        return true;
    }

    public Map<Floor, Elevator.LevelData> getLevelData() {
        IdentityHashMap<Floor, Elevator.LevelData> levelData = new IdentityHashMap<Floor, Elevator.LevelData>();
        for (int m = 0; m < this.d_table.getModel().getRowCount(); ++m) {
            Floor floor = (Floor)this.d_table.getModel().getValueAt(m, 0);
            UnitDouble delay = (UnitDouble)this.d_table.getModel().getValueAt(m, 1);
            UnitDouble openClose = (UnitDouble)this.d_table.getModel().getValueAt(m, 2);
            UnitDouble pickup = (UnitDouble)this.d_table.getModel().getValueAt(m, 3);
            UnitDouble discharge = (UnitDouble)this.d_table.getModel().getValueAt(m, 4);
            if (delay == null || pickup == null || discharge == null) continue;
            UnitDouble halfOpenClose = new UnitDouble(openClose.getValueNoUnit() / 2.0, openClose.getUnit());
            levelData.put(floor, new Elevator.LevelData(halfOpenClose, halfOpenClose, pickup, discharge, delay));
        }
        return levelData;
    }
}

