/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.MerlinActionMap;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressRoom;
import merlin.gui.guiUtil;
import org.jscience.physics.units.NonSI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.dialogs.CustomKeyAcceleratorDlg;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.scene3d.gui.GPUInfoPnl;
import thunderheadeng.scene3d.gui.RenderPrefs;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public class EditPreferencesDlg
extends guiDialog {
    private static final long serialVersionUID = 3687627459355463425L;
    private guiCheckBox d_anoCk;
    private ValueField<Integer> d_maxVBSizeFld;
    private final guiCheckBox d_autosaveCB;
    private final ValueField<UnitDouble> d_autosaveIntervalFld;
    private final guiCheckBox d_backupCB;
    private final guiCheckBox d_customBackupDirCB;
    private final guiFileChooser d_customBackupDirChooser;
    private final guiTextField d_customBackupDirTF;
    private final JButton d_customBackupDirButton;
    private final ValueField<Double> d_displayEdgeError;
    private final ValueField<Double> d_displayFaceError;
    private final guiComboBox<Boolean> d_occAnim;
    private final RenderPrefs.PrefsUI d_rprefs;
    private final JTabbedPane d_tabs;
    private final Map<Tabs, Integer> d_tabMap = new HashMap<Tabs, Integer>();
    private final guiCheckBox d_meshOptimization;

    public EditPreferencesDlg(JFrame owner, Supplier<IRenderSurface.OpenGLInfo> getRenderInfo, Supplier<IPropertySet> getRenderDef, Supplier<IPropertySet> getRenderPref, Supplier<IPropertySet> getRenderComp) {
        super((Window)owner, Intl.intl("Preferences"), 9);
        this.d_anoCk = new guiCheckBox(Intl.intl("Include Group Names in Output"));
        this.d_maxVBSizeFld = ValueFields.intFld();
        this.d_occAnim = guiUtil.newCombo(Boolean.valueOf(true), Intl.intl("Animate in Hardware"), false, Intl.intl("Animate in Software"));
        this.d_rprefs = new RenderPrefs.PrefsUI("Pathfinder");
        this.d_autosaveCB = new guiCheckBox(Intl.intl("Autosave:"));
        this.d_autosaveIntervalFld = ValueFields.udFld(10.0, DoubleVR.above(0.0, false), NonSI.MINUTE);
        LinkStatus.link((AbstractButton)this.d_autosaveCB, this.d_autosaveIntervalFld);
        this.d_backupCB = new guiCheckBox(Intl.intl("Create Backup on Open"));
        this.d_customBackupDirCB = new guiCheckBox(Intl.intl("Custom Backup Directory:"));
        this.d_customBackupDirChooser = new guiFileChooser();
        this.d_customBackupDirChooser.setAcceptAllFileFilterUsed(false);
        this.d_customBackupDirChooser.setFileSelectionMode(1);
        this.d_customBackupDirTF = new guiTextField();
        this.d_customBackupDirTF.setEditable(false);
        this.d_customBackupDirTF.setPreferredSize(new Dimension(100, this.d_customBackupDirTF.getPreferredSize().height));
        this.d_customBackupDirButton = new JButton("Edit...");
        this.d_customBackupDirButton.addActionListener(evt -> this.showCustomDirChooser());
        LinkStatus.link((AbstractButton)this.d_customBackupDirCB, this.d_customBackupDirTF, this.d_customBackupDirButton);
        this.d_displayEdgeError = ValueFields.doubleFld(DoubleVR.above(0.0, false));
        this.d_displayFaceError = ValueFields.doubleFld(DoubleVR.above(0.0, false));
        guiLabel edgeErrorLbl = new guiLabel(Intl.intl("Curve error:"));
        edgeErrorLbl.setToolTipText(Intl.intl("Sets the amount of error when displaying curved CAD lines."));
        guiLabel faceErrorLbl = new guiLabel(Intl.intl("Face error:"));
        faceErrorLbl.setToolTipText(Intl.intl("Sets the amount of error when displaying curved CAD faces."));
        this.d_meshOptimization = new guiCheckBox(Intl.intl("Optimize Navigation Geometry"));
        guiLabel hotkeyLbl = new guiLabel(Intl.intl("Edit Shortcuts:"));
        JButton editHotkeys = new JButton(Intl.intl("Edit..."));
        editHotkeys.addActionListener(e -> {
            CustomKeyAcceleratorDlg dlg = new CustomKeyAcceleratorDlg(owner, new MerlinActionMap.MerlinCustomUIHelper());
            if (dlg.doModal() == 1) {
                dlg.saveData();
            }
        });
        this.d_tabs = new JTabbedPane();
        BiConsumer<Tabs, guiPanel> addTab = (tab, pnl) -> {
            int ix = this.d_tabs.getTabCount();
            this.d_tabs.addTab(tab.desc, (Component)pnl);
            this.d_tabMap.put((Tabs)((Object)tab), ix);
        };
        guiPanel generalPnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(generalPnl, true);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Keyboard Shortcuts")));
        gb.indent();
        gb.addRow(hotkeyLbl, editHotkeys);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("File Backup")));
        gb.indent();
        gb.addRow(this.d_autosaveCB, this.d_autosaveIntervalFld, 0);
        gb.addRow(this.d_backupCB, 0);
        gb.addRow(this.d_customBackupDirCB, this.d_customBackupDirTF, this.d_customBackupDirButton);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("Results")));
        gb.indent();
        gb.addRow(this.d_anoCk, 0);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("Display")));
        gb.indent();
        gb.addRow(edgeErrorLbl, this.d_displayEdgeError, 0);
        gb.addRow(faceErrorLbl, this.d_displayFaceError, 0);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("Navigation Geometry")));
        gb.indent();
        gb.addRow(this.d_meshOptimization, 0);
        gb.unindent();
        gb.finalizeRows();
        addTab.accept(Tabs.GENERAL, generalPnl);
        guiPanel renderingPnl = new guiPanel();
        gb = new GridBagHelper(renderingPnl, true);
        gb.addTitle(Intl.intl("GPU Information"));
        gb.indent();
        gb.addFilledRow(new GPUInfoPnl(getRenderInfo, true));
        gb.unindent();
        gb.addSeparator();
        guiPanel rendPrefBtns = RenderPrefs.getRenderPrefsBtns(getRenderDef, getRenderPref, getRenderComp, props -> this.loadRenderPrefs((IPropertySet)props, true, false));
        gb.addRow(new Object[]{rendPrefBtns, 1.0, 0, GridBagHelper.Anchor.CENTER});
        gb.addRow(Intl.intl("Occupant Animation:"), this.d_occAnim, 1.0);
        gb.addRow(Intl.intl("Max. Graphics Buffer Size (KB):"), this.d_maxVBSizeFld, 1.0);
        this.d_rprefs.addTo(gb);
        gb.finalizeRows();
        addTab.accept(Tabs.RENDERING, renderingPnl);
        this.getDialogPane().add(this.d_tabs);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        return this.d_rprefs.validateData(showWarn, allowModify);
    }

    public void setTab(Tabs tab) {
        this.d_tabs.setSelectedIndex(this.d_tabMap.get((Object)tab));
    }

    public void init(MerlinApp app) {
        this.loadPrefs(app);
        this.loadRenderPrefs(MerlinPrefs.instance(), false, true);
        this.setModified(false);
    }

    private void loadPrefs(MerlinApp app) {
        this.d_anoCk.setSelected(MerlinPrefs.getBoolean(MerlinPrefs.KEY_ANNOTATE));
        this.d_autosaveCB.setSelected(MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_AUTOSAVE));
        this.d_autosaveIntervalFld.setValue(MerlinPrefs.getUnitDouble(MerlinPrefs.BACKUP_AUTOSAVE_INTERVAL, NonSI.MINUTE));
        this.d_backupCB.setSelected(MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_BACKUPONOPEN));
        this.d_customBackupDirCB.setSelected(MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_CUSTOMDIR));
        this.d_customBackupDirTF.setText(MerlinPrefs.getString(MerlinPrefs.BACKUP_CUSTOMDIR_PATH));
        this.d_customBackupDirTF.setToolTipText(MerlinPrefs.getString(MerlinPrefs.BACKUP_CUSTOMDIR_PATH));
        this.d_displayEdgeError.setValue(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_EDGE_ERROR));
        this.d_displayFaceError.setValue(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_FACE_ERROR));
        this.d_meshOptimization.setSelected(MerlinPrefs.get(MerlinPrefs.MESH_OPTIMIZATION));
    }

    private void loadRenderPrefs(IPropertySet props, boolean onlyIfDefined, boolean clearRestart) {
        guiUtil.loadPref(props, onlyIfDefined, this.d_occAnim, MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140);
        if (guiUtil.canLoadPref(props, onlyIfDefined, MerlinPrefs.KEY_RFIXED_MAX_VB_SIZE)) {
            this.d_maxVBSizeFld.setValue((int)(MerlinPrefs.getLong(MerlinPrefs.KEY_RFIXED_MAX_VB_SIZE) / 1024L));
        }
        this.d_rprefs.loadData(props, onlyIfDefined, clearRestart);
    }

    private static <T> void set(TypedProp<T> prop, T value) {
        MerlinApp.setPref(prop, value);
    }

    public void commit(MerlinApp app) {
        TeciProps tprops = new TeciProps();
        this.d_rprefs.saveData(tprops);
        MerlinApp.setPrefs(tprops);
        EditPreferencesDlg.set(MerlinPrefs.KEY_ANNOTATE, this.d_anoCk.isSelected());
        if (this.d_occAnim.isModified()) {
            EditPreferencesDlg.set(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10, false);
            EditPreferencesDlg.set(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140, this.d_occAnim.getSelectedItem());
        }
        if (this.d_maxVBSizeFld.isModified()) {
            EditPreferencesDlg.set(MerlinPrefs.KEY_RFIXED_MAX_VB_SIZE, (long)((Integer)this.d_maxVBSizeFld.getValue()).intValue() * 1024L);
        }
        EditPreferencesDlg.set(MerlinPrefs.DISPLAY_EDGE_ERROR, this.d_displayEdgeError.getValue());
        EditPreferencesDlg.set(MerlinPrefs.DISPLAY_FACE_ERROR, this.d_displayFaceError.getValue());
        EditPreferencesDlg.set(MerlinPrefs.BACKUP_AUTOSAVE, this.d_autosaveCB.isSelected());
        EditPreferencesDlg.set(MerlinPrefs.BACKUP_AUTOSAVE_INTERVAL, ((UnitDouble)this.d_autosaveIntervalFld.getValue()).get(NonSI.MINUTE));
        EditPreferencesDlg.set(MerlinPrefs.BACKUP_BACKUPONOPEN, this.d_backupCB.isSelected());
        EditPreferencesDlg.set(MerlinPrefs.BACKUP_CUSTOMDIR, this.d_customBackupDirCB.isSelected());
        if (this.d_customBackupDirCB.isSelected()) {
            EditPreferencesDlg.set(MerlinPrefs.BACKUP_CUSTOMDIR_PATH, this.d_customBackupDirTF.getText());
        }
        if (this.d_meshOptimization.isSelected() != MerlinPrefs.get(MerlinPrefs.MESH_OPTIMIZATION).booleanValue()) {
            EditPreferencesDlg.set(MerlinPrefs.MESH_OPTIMIZATION, this.d_meshOptimization.isSelected());
            if (this.d_meshOptimization.isSelected()) {
                this.optimizeMesh();
            }
        }
    }

    private void optimizeMesh() {
        int reply = JOptionPane.showConfirmDialog(this, Intl.intl("Would you like to optimize all navigation geometry now?"), Intl.intl("Optimize navigation geometry?"), 0);
        if (reply == 0) {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            Collection<EgressRoom> rooms = md.floors.flatten(EgressRoom.class);
            md.endRead();
            Undo.begin(Intl.intl("Optimize Geometry"));
            Undo.insertUndoEntry_restore(md, rooms);
            md.beginWrite();
            EgressRoom.cleanup(md, rooms);
            Undo.end(md);
            md.endWrite();
        }
    }

    private void showCustomDirChooser() {
        guiFileChooser chooser = new guiFileChooser();
        String path = MerlinPrefs.getString(MerlinPrefs.BACKUP_CUSTOMDIR_PATH);
        if (!path.isEmpty()) {
            chooser.setCurrentDirectory(new File(path), false);
        }
        chooser.setFileSelectionMode(1);
        int result = chooser.showOpenDialog(this.getParent());
        if (result == 0) {
            this.d_customBackupDirTF.setText(chooser.getFilename());
            this.d_customBackupDirTF.setToolTipText(chooser.getFilename());
        }
    }

    public static enum Tabs {
        GENERAL(Intl.intl("General")),
        RENDERING(Intl.intl("Rendering"));

        public final String desc;

        private Tabs(String desc) {
            this.desc = desc;
        }
    }
}

