/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import common.PathfinderLM;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.gui.guiUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.VersionUtil;

public class CheckForUpdatesDlg
extends VersionUtil.ACheckForUpdatesDlg {
    private static final long serialVersionUID = -8682209765937249744L;
    private final VersionUtil.URLVersionSource d_versionSource;

    public CheckForUpdatesDlg(MerlinApp app, boolean isCheckOnStart, VersionUtil.URLVersionSource versionSource) {
        super((Window)app.getMainFrame(), Intl.intl("Check For Updates"), versionSource, isCheckOnStart);
        this.d_skipUpdateButton.addActionListener(new SkipUpdate(app, this));
        this.d_versionSource = versionSource;
    }

    @Override
    protected void init(boolean isCheckOnStart, VersionUtil.IVersionSource versionSource) {
        this.d_updates = this.buildPanel(VersionUtil.getVersionSupplier(PathfinderLM.getInstance()), "2021.4.1201", versionSource);
        this.d_checkOnStartCB.setSelected(isCheckOnStart);
        guiPanel c = this.getDialogPane();
        c.setLayout(new GridBagLayout());
        guiLabel labelImg = new guiLabel(guiUtil.loadMerlinIcon("pathfinderSplash2.png"));
        GridBagUtil.add(c, labelImg, 0, 0, 1, 1, 0, 0, 0, 18, 0, 0.0, 0.0, 18);
        GridBagUtil.add(c, this.d_updates, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0.0, 0.0, 18);
        GridBagUtil.addGlue(c);
        super.getContentPane().remove(super.getButtonPanel());
        guiPanel southPnl = new guiPanel(new GridBagLayout());
        GridBagUtil.add(southPnl, this.d_checkOnStartCB, 0, 0, 1, 1, 6, 12, 0, 12, 0, 0.0, 0.0);
        GridBagUtil.add(southPnl, Box.createGlue(), 1, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.add(southPnl, this.getButtonPanel(), 2, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0);
        super.getContentPane().add((Component)southPnl, "South");
        this.pack();
    }

    private class SkipUpdateDialog
    extends guiDialog {
        private static final long serialVersionUID = 2757012068115022415L;

        public SkipUpdateDialog(Window owner) {
            super(owner, Intl.intl("Skip Update"), 9);
            String headVersion = VersionUtil.getHeadVersionString(VersionUtil.getVersionSupplier(PathfinderLM.getInstance()), CheckForUpdatesDlg.this.d_versionSource);
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(new guiLabel(String.format(Intl.intl("You will not be notified again about the %s release."), headVersion)), 0);
            gb.finalizeRows();
        }
    }

    public class SkipUpdate
    implements ActionListener {
        private final MerlinApp d_app;
        private final guiDialog d_parent;

        public SkipUpdate(MerlinApp app, guiDialog parent) {
            this.d_app = app;
            this.d_parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SkipUpdateDialog dialog = new SkipUpdateDialog(this.d_app.getMainFrame());
            if (dialog.doModal() == 1) {
                MerlinApp.setPref(MerlinPrefs.SKIP_UPDATE, true);
                MerlinApp.setPref(MerlinPrefs.SKIP_UPDATE_VERSION, VersionUtil.getHeadVersionString(VersionUtil.getVersionSupplier(PathfinderLM.getInstance()), CheckForUpdatesDlg.this.d_versionSource));
                this.d_parent.setVisible(false);
            }
        }
    }
}

