/*
 * Decompiled with CFR 0.152.
 */
package merlin.geom;

import common.geom.Trig;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import merlin.MerlinApp;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.geom.RoomUtil;
import merlin.geom.Geometry;
import merlin.geom.Inter2D;
import merlin.geom.PointGeomFinder;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.theUtil;

public class GeomUtil {
    public static double dist(Tuple3d a, Tuple3d b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        double dz = b.z - a.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double dist(Tuple3f a, Tuple3f b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        double dz = b.z - a.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static boolean samePt(Tuple3d pt1, Tuple3d pt2, double tol) {
        return GeomUtil.dist(pt1, pt2) <= tol;
    }

    public static boolean samePt(Tuple3f pt1, Tuple3f pt2, double tol) {
        return GeomUtil.dist(pt1, pt2) <= tol;
    }

    public static Vector2d randomVec(Random rand) {
        double x = 0.0;
        double y = 0.0;
        while (x == 0.0 && y == 0.0) {
            x = rand.nextDouble() - 0.5;
            y = rand.nextDouble() - 0.5;
        }
        return new Vector2d(x, y);
    }

    public static Point2d findPointInPoly(List<? extends IParametric2D> poly, double tol) {
        if (poly.isEmpty()) {
            return null;
        }
        Point2d startPoint = poly.get(0).get(0.5);
        Random rand = new Random(0L);
        for (int m = 0; m < 10; ++m) {
            Vector2d rvec = GeomUtil.randomVec(rand);
            List<double[]> trimmed = Inter2D.trimLineToPoly(poly, startPoint, rvec, tol);
            for (double[] seg : trimmed) {
                if (theUtil.eq(seg[0], seg[1], tol)) continue;
                double midt = (seg[0] + seg[1]) * 0.5;
                return Util2D.linePoint(startPoint, rvec, midt);
            }
        }
        return startPoint;
    }

    public static boolean addToModel(Model model, int groupid, Mesh mesh) {
        boolean result = true;
        switch (mesh.primtype) {
            case 1: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    model.addEdge(groupid, new LineSeg3D(p1, p2));
                }
                break;
            }
            case 2: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    Point3d p3 = mesh.vertices[mesh.indices[m++]];
                    result &= model.addPolygonFace(groupid, new Plane3d(true, p1, p2, p3), p1, p2, p3);
                }
                break;
            }
            case 3: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    Point3d p3 = mesh.vertices[mesh.indices[m++]];
                    Point3d p4 = mesh.vertices[mesh.indices[m++]];
                    result &= model.addPolygonFace(groupid, new Plane3d(true, p1, p2, p3, p4), p1, p2, p3, p4);
                }
                break;
            }
            default: {
                return false;
            }
        }
        return result;
    }

    public static boolean addFaceToModel(Model model, int groupid, Plane3d plane, Collection<? extends IParametric3D> boundary) {
        return model.addFace(groupid, plane, boundary);
    }

    public static boolean addFaceToModel(IFace face, Model model, int groupid, double edgeError, double faceError) {
        return GeomUtil.addFaceToModel(face, true, model, groupid, edgeError, faceError);
    }

    public static boolean addFaceToModel(IFace face, boolean ccw, Model model, int groupid, double edgeError, double faceError) {
        if (face instanceof Triangle) {
            Triangle tri = (Triangle)face;
            Plane3d plane = new Plane3d(ccw, tri.p1, tri.p2, tri.p3);
            if (ccw) {
                return model.addPolygonFace(groupid, plane, tri.p1, tri.p2, tri.p3);
            }
            return model.addPolygonFace(groupid, plane, tri.p3, tri.p2, tri.p1);
        }
        if (face instanceof IPlanarFace) {
            IPolygon poly = ((IPlanarFace)face).toPoly(edgeError);
            Plane3d plane = poly.getPlane(ccw);
            Point3d[][] loops = PolyUtil.getLoops(poly, false);
            ArrayList<LineSeg3D> curves = new ArrayList<LineSeg3D>();
            for (Point3d[] loop : loops) {
                Point3d p22;
                if (loop.length == 0) continue;
                if (ccw) {
                    for (int m = 0; m < loop.length; ++m) {
                        Point3d p12 = loop[m];
                        p22 = loop[(m + 1) % loop.length];
                        if (p12.equals(p22)) continue;
                        curves.add(new LineSeg3D(p12, p22));
                    }
                    continue;
                }
                Point3d p13 = loop[0];
                for (int m = loop.length - 1; m >= 0; --m) {
                    p22 = loop[m];
                    if (!p13.equals(p22)) {
                        curves.add(new LineSeg3D(p13, p22));
                    }
                    p13 = p22;
                }
            }
            return model.addFace(groupid, plane, curves);
        }
        boolean result = true;
        Pair<Mesh, Boolean> triResult = face.triangulate(faceError, ccw);
        Mesh triangles = (Mesh)triResult.v1;
        boolean tccw = (Boolean)triResult.v2;
        TriFunction<Point3d, Point3d, Point3d, Boolean> addTri = tccw ? (p1, p2, p3) -> {
            Plane3d plane = new Plane3d(true, (Point3d)p1, (Point3d)p2, (Point3d)p3);
            return model.addPolygonFace(groupid, plane, (Point3d)p1, (Point3d)p2, (Point3d)p3);
        } : (p3, p2, p1) -> {
            Plane3d plane = new Plane3d(true, (Point3d)p1, (Point3d)p2, (Point3d)p3);
            return model.addPolygonFace(groupid, plane, (Point3d)p1, (Point3d)p2, (Point3d)p3);
        };
        int m = 0;
        while (m < triangles.indices.length) {
            Point3d p14 = triangles.vertices[triangles.indices[m++]];
            Point3d p23 = triangles.vertices[triangles.indices[m++]];
            Point3d p32 = triangles.vertices[triangles.indices[m++]];
            result &= addTri.apply(p14, p23, p32).booleanValue();
        }
        return result;
    }

    public static void addCurveToModel(ICurve curve, Model model, int groupid, double edgeError) {
        if (curve instanceof LineSeg) {
            LineSeg ls = (LineSeg)curve;
            model.addEdge(groupid, new LineSeg3D(ls.p1, ls.p2));
        } else {
            Mesh mesh = curve.getSegments(edgeError);
            int m = 0;
            while (m < mesh.indices.length) {
                Point3d p1 = mesh.vertices[mesh.indices[m++]];
                Point3d p2 = mesh.vertices[mesh.indices[m++]];
                model.addEdge(groupid, new LineSeg3D(p1, p2));
            }
        }
    }

    public static List<IFace> extractFaces(Model model, Integer groupid) {
        ArrayList<IFace> faces = new ArrayList<IFace>();
        for (Face face : model.getFaces()) {
            IFace gface;
            if (groupid != null && !face.partOfGroup(groupid) || (gface = GeomUtil.toGeomFace(face)) == null) continue;
            faces.add(gface);
        }
        return faces;
    }

    public static IFace toGeomFace(Face face) {
        ArrayList<Point3d[]> loops = new ArrayList<Point3d[]>(face.edgeLoops.size());
        for (FaceLoop loop : face.edgeLoops) {
            if (loop.edges.size() < 3) continue;
            Point3d[] points = new Point3d[loop.edges.size()];
            for (int m = 0; m < loop.edges.size(); ++m) {
                EdgeUse eu = loop.edges.get(m);
                points[m] = eu.v1().loc;
            }
            loops.add(points);
        }
        if (loops.isEmpty()) {
            return null;
        }
        return PolyUtil.newPoly((Point3d[][])loops.toArray((T[])new Point3d[loops.size()][]));
    }

    public static ICurve toGeomCurve(EdgeUse eu) {
        return GeomUtil.toGeomCurve(eu.curve());
    }

    public static ICurve toGeomCurve(IParametric3D curve) {
        if (curve.isLinear()) {
            return new LineSeg(curve.get(0.0), curve.get(1.0));
        }
        assert (false);
        return null;
    }

    public static Model transform(Model model, ITransform xform, Matrix4d matrix) {
        Model mclone = (Model)model.clone();
        mclone.transform(xform, matrix);
        RoomUtil.ensureProperFaceOrient(mclone);
        return mclone;
    }

    public static List<? extends IPolygon> toPolys(IFace face, double error) {
        if (face instanceof IPolygon) {
            return Arrays.asList((IPolygon)face);
        }
        return thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(error, face);
    }

    public static Area toArea(Face face) {
        return GeomUtil.toArea(face, face.plane);
    }

    public static Area toArea(Face face, Plane3d projPlane) {
        Matrix4d wlXform = Util.getWorldToLocalXform(projPlane);
        Path2D.Double path = new Path2D.Double(0);
        for (FaceLoop loop : face.edgeLoops) {
            ArrayList<IParametric2D> subPath = new ArrayList<IParametric2D>();
            for (EdgeUse eu : loop.edges) {
                subPath.add(eu.curve().projectToPlane(projPlane, wlXform));
            }
            ShapeUtil.appendAsSubPath(path, subPath);
        }
        return new Area(path);
    }

    public static Vector3d to3d(Vector2d v, boolean normalize) {
        double lsq;
        Vector3d result = new Vector3d(v.x, v.y, 0.0);
        if (normalize && (lsq = result.lengthSquared()) > 0.0) {
            result.scale(1.0 / Math.sqrt(lsq));
        }
        return result;
    }

    public static Vector2d to2d(Vector3d v, boolean normalize) {
        double lsq;
        Vector2d result = new Vector2d(v.x, v.y);
        if (normalize && (lsq = result.lengthSquared()) > 0.0) {
            result.scale(1.0 / Math.sqrt(lsq));
        }
        return result;
    }

    public static FindResult findRoom(MerlinData md, Point3d loc, int options) {
        FindResult closestResult = null;
        double closestDistSq = Double.MAX_VALUE;
        PointGeomFinder<IEgressOccupiable> test = new PointGeomFinder<IEgressOccupiable>(loc, 1.0E-6, IEgressOccupiable.class);
        md.geomLocation.getLocator().find(test.test, test.result, options);
        for (Map.Entry<IEgressOccupiable, IsectInfo> entry : test.getResults().entrySet()) {
            IGeom geom = entry.getKey().getGeom().flatten().getLocalGeom();
            for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode(geom, IFace.class)) {
                for (IPolygon iPolygon : GeomUtil.getPolys(face, 0.0)) {
                    Point3d nearp = iPolygon.project(loc);
                    double distsq = nearp.distanceSquared(loc);
                    if (!(distsq < closestDistSq) || !iPolygon.classify((Point3d)nearp, (double)1.0E-6).positive) continue;
                    closestDistSq = distsq;
                    closestResult = new FindResult(entry.getKey(), iPolygon.getNormal(true), nearp);
                }
            }
        }
        return closestResult;
    }

    public static FindResult findRoom(MerlinData md, Point3d rayBegin, Point3d rayEnd, int options) {
        FindResult closestResult = null;
        double closestDistSq = Double.MAX_VALUE;
        LineSegRTreeTest test = new LineSegRTreeTest(rayBegin, rayEnd);
        CollResult result = new CollResult(IEgressOccupiable.class);
        md.geomLocation.getLocator().find(test, result, options);
        for (IEgressOccupiable room : result.coll) {
            IGeom geom = room.getGeom().flatten().getLocalGeom();
            for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode(geom, IFace.class)) {
                for (IPolygon iPolygon : GeomUtil.getPolys(face, 0.0)) {
                    double distsq;
                    Point3d isect = GeomUtil.getIsect(iPolygon, rayBegin, rayEnd);
                    if (isect == null || !((distsq = isect.distanceSquared(rayBegin)) < closestDistSq)) continue;
                    closestDistSq = distsq;
                    closestResult = new FindResult(room, iPolygon.getNormal(true), isect);
                }
            }
        }
        return closestResult;
    }

    private static Collection<? extends IPolygon> getPolys(IFace face, double faceError) {
        if (face instanceof IPolygon) {
            return Arrays.asList((IPolygon)face);
        }
        return thunderheadeng.geometry.objs.GeomUtil.getTriangles(faceError, face);
    }

    private static Point3d getIsect(IPolygon poly, Point3d p1, Point3d p2) {
        Plane3d plane = poly.getPlane(true);
        Point3d isect = Inter3D.lineSegPlaneIntersection(p1, p2, plane, 1.0E-6);
        if (isect == null) {
            return null;
        }
        return poly.classify((Point3d)isect, (double)1.0E-6).positive ? isect : null;
    }

    public static UnitDouble getOccOrient(Point3d loc, Point3d target) {
        Vector3d towardsTarget = new Vector3d(target.x - loc.x, target.y - loc.y, 0.0);
        double angle = Trig.angle(OccProfile.INIT_ORIENT_REF, towardsTarget);
        return new UnitDouble(angle, Geometry.ANGLE_UNIT);
    }

    public static class LocationHandle
    implements IHandle {
        private ACircleGeometry d_geom;
        private GEOM_TYPE d_geomType;

        public LocationHandle(ACircleGeometry geom) {
            this(geom, GEOM_TYPE.POINT);
        }

        public LocationHandle(ACircleGeometry geom, GEOM_TYPE type) {
            this.d_geom = geom;
            this.d_geomType = type;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof LocationHandle;
        }

        @Override
        public IGeomNode getGeom() {
            if (this.d_geomType.equals((Object)GEOM_TYPE.POINT)) {
                return GeomNodeUtil.newNode(new Point(this.d_geom.location));
            }
            if (this.d_geomType.equals((Object)GEOM_TYPE.AREA)) {
                return GeomNodeUtil.newNode(this.d_geom);
            }
            assert (false);
            return null;
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(IEgressOccupiable.class, GeomType.FACE));
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ACircleGeometry modify(Point3d newLoc) throws ManipException {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            try {
                FindResult result = GeomUtil.findRoom(MerlinApp.getApp().getData(), newLoc, 0);
                if (result == null) {
                    throw new ManipException();
                }
                ACircleGeometry aCircleGeometry = this.d_geom = this.d_geom.getConstructedTransform(result.room, result.faceNormal, result.p, this.d_geom.radius);
                return aCircleGeometry;
            }
            finally {
                md.endRead();
            }
        }

        @Override
        public ACircleGeometry end() {
            return this.d_geom;
        }

        public static enum GEOM_TYPE {
            POINT,
            AREA;

        }
    }

    public static class RadiusHandle
    implements IHandle {
        private ACircleGeometry d_geom;

        public RadiusHandle(ACircleGeometry geom) {
            this.d_geom = geom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof RadiusHandle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(ACircleGeometry.generateCircle(this.d_geom.location, this.d_geom.radius, this.d_geom.normal));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return new PlanarConstraint(new Plane3d(this.d_geom.normal, this.d_geom.location));
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public ACircleGeometry modify(Point3d newLoc) throws ManipException {
            double newRadius = newLoc.distance(this.d_geom.location);
            this.d_geom = this.d_geom.getConstructedTransform(this.d_geom.room, this.d_geom.normal, this.d_geom.location, newRadius);
            return this.d_geom;
        }

        @Override
        public ACircleGeometry end() {
            return this.d_geom;
        }
    }

    public static abstract class ACircleGeometry
    extends GeomGroup {
        private static final long serialVersionUID = 6462995199370786383L;
        public final IEgressOccupiable room;
        public final Vector3d normal;
        public final Point3d location;
        public final double radius;

        public ACircleGeometry(IEgressOccupiable room, Vector3d normal, Point3d location, double radius, IGeom ... additionalGeoms) {
            this(room, normal, location, radius, true, additionalGeoms);
        }

        public ACircleGeometry(IEgressOccupiable room, Vector3d normal, Point3d location, double radius, boolean solid, IGeom ... additionalGeoms) {
            super(ACircleGeometry.generateGeoms(location, radius, normal, solid, additionalGeoms));
            this.room = room;
            this.location = location;
            this.normal = normal;
            this.radius = radius;
        }

        private static List<IGeom> generateGeoms(Point3d location, double radius, Vector3d normal, boolean solid, IGeom ... additionalGeom) {
            ArrayList<IGeom> geoms = new ArrayList<IGeom>();
            ShapeGeom cgeom = ACircleGeometry.generateCircle(location, radius, normal);
            geoms.add(cgeom);
            if (solid) {
                Area area = new Area(cgeom.shape);
                ShapeGeom ageom = new ShapeGeom((Shape)area, cgeom.lwXform);
                geoms.add(ageom);
            }
            Point pgeom = new Point(location);
            geoms.add(pgeom);
            geoms.addAll(Arrays.asList(additionalGeom));
            return geoms;
        }

        public static ShapeGeom generateCircle(Point3d location, double arriveRadius, Vector3d normal) {
            Plane3d plane = new Plane3d(normal, new Point3d(0.0, 0.0, 0.0));
            Ellipse2D.Double circle = ShapeUtil.newCircle(arriveRadius);
            Matrix4d xform = Util.translateMat(location.x, location.y, location.z);
            xform.mul(Util.getLocalToWorldXform(plane));
            return new ShapeGeom((Shape)circle, xform);
        }

        public static ShapeGeom generateOutline(Point3d location, double arriveRadius, Vector3d normal) {
            Plane3d plane = new Plane3d(normal, new Point3d(0.0, 0.0, 0.0));
            Arc2D.Double circle = ShapeUtil.newCircularArc(0.0, 0.0, arriveRadius, 0.0, Math.PI * 2, true);
            Matrix4d xform = Util.translateMat(location.x, location.y, location.z);
            xform.mul(Util.getLocalToWorldXform(plane));
            return new ShapeGeom((Shape)circle, xform);
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            Vector3d scaleVec = Util3D.xform(xform, new Vector3d(this.radius, 0.0, 0.0));
            double newRadius = scaleVec.length();
            Point3d newLoc = Util3D.xform(xform, this.location);
            FindResult result = GeomUtil.findRoom(MerlinApp.getApp().getData(), newLoc, 1);
            return this.constructTransformedGeom(result, newLoc, newRadius);
        }

        protected abstract IGeom constructTransformedGeom(FindResult var1, Point3d var2, double var3);

        @Override
        public abstract Collection<? extends IHandle> generateManipHandles();

        public abstract ACircleGeometry getConstructedTransform(IEgressOccupiable var1, Vector3d var2, Point3d var3, double var4);
    }

    public static class FindResult {
        public final IEgressOccupiable room;
        public final Vector3d faceNormal;
        public final Point3d p;

        public FindResult(IEgressOccupiable room, Vector3d faceNormal, Point3d p) {
            this.room = room;
            this.faceNormal = faceNormal;
            this.p = p;
        }
    }
}

