/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.image;

import java.awt.Dimension;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.geom.IMerlinGeomSrc;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.image.Image;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Sets;

public class RasterImage
extends NamedMerlinObj
implements IMerlinGeomSrc,
IRestorable,
ICompElement {
    static final long serialVersionUID = 1L;
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(MerlinData.VISIBILITY, NamedMerlinObj.NAME, MerlinData.ENABLED);
    private Image d_image;
    private boolean d_enabled;
    private boolean d_visible;
    private Matrix4d d_lwXform;

    public RasterImage(String name, Image baseImage) {
        super(name);
        this.d_image = baseImage;
        this.d_enabled = true;
        this.d_visible = true;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof RasterImage)) {
            return;
        }
        RasterImage ri = (RasterImage)obj;
        this.pauseUpdates();
        this.setName(ri.getName());
        this.d_image = ri.d_image;
        this.d_enabled = ri.d_enabled;
        this.d_visible = ri.d_visible;
        this.resumeUpdates();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    public float getOpacity() {
        return 1.0f;
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_visible = visible;
        this.changedEvt(MerlinData.VISIBILITY);
    }

    public void setImage(Image image) {
        this.d_image = image;
        this.changedEvt(new Object[0]);
    }

    public Image getImage() {
        return this.d_image;
    }

    public Matrix4d getLWXform() {
        return this.d_lwXform;
    }

    public void setLWXform(Matrix4d lwXform) {
        this.d_lwXform = lwXform;
        this.changedEvt(new Object[0]);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getRasterGeom());
    }

    public RasterImageGeom getRasterGeom() {
        return new RasterImageGeom(new Dimension(this.d_image.getWidth(), this.d_image.getHeight()), this.d_lwXform);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (!(geom instanceof RasterImageGeom)) {
            return;
        }
        RasterImageGeom rig = (RasterImageGeom)geom;
        this.setLWXform(rig.lwxform);
    }

    @Override
    public void getAll(Consumer<Object> result, IIsectFilter filter) {
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box) {
    }

    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        return NOT_SUPPORTED;
    }

    public static class RasterImageGeom
    implements IGeom {
        private static final long serialVersionUID = -2245365587792843008L;
        public final Dimension imgSize;
        public final Matrix4d lwxform;

        public RasterImageGeom(Dimension imgSize, Matrix4d xform) {
            this.imgSize = imgSize;
            this.lwxform = xform;
        }

        @Override
        public IGeom optimize(IPointOptimizer pointOptimizer) {
            return this;
        }

        @Override
        public boolean isShell() {
            return true;
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo parentXform) {
            return false;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.FREE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.FREE;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = new Matrix4d(ti.getMatrix());
            xform.mul(this.lwxform);
            return new RasterImageGeom(this.imgSize, xform);
        }

        @Override
        public int getNumPrims(int types) {
            return (types & 1) != 0 ? 1 : 0;
        }

        @Override
        public boolean canExplode() {
            return true;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> prims) {
            prims.add(this.toQuad());
            return prims;
        }

        public Quad toQuad() {
            return this.toQuad(this.lwxform);
        }

        protected Quad toQuad(Matrix4d xform) {
            Quad q = new Quad(new Point3d(0.0, 0.0, 0.0), new Point3d(this.imgSize.width, 0.0, 0.0), new Point3d(this.imgSize.width, this.imgSize.height, 0.0), new Point3d(0.0, this.imgSize.height, 0.0));
            return q.transform(new TransformInfo(xform), 0);
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            return this.toQuad().getBoundingBox(aabb);
        }

        @Override
        public void pickBox(Object source, IIsectFilter filter, ConvexHull region, thunderheadeng.geometry.objs.IBoxCollector isects) throws CancelledException {
            this.toQuad().pickBox(source, filter, region, isects);
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
            this.toQuad().pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
        }

        @Override
        public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
            result.mark(this.toQuad(), Containment.INTERSECTS);
        }

        @Override
        public void getAll(IResult<? super IPrimitive> result) {
            result.mark(this.toQuad(), Containment.INSIDE);
        }
    }
}

