/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.queues;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IOpacity;
import merlin.data.MerlinData;
import merlin.data.Opacity;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.queues.IGotoQueueDestination;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.mv.displays.MerlinDispProps;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class QueueObject
extends GeomComposite<IQueueElement>
implements IGotoQueueDestination,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    private Color d_color = theUtil.newRandomColor();
    private float d_transparency = 0.0f;
    private Collection<OccProfile> d_restrictedProfiles = new LinkedIdentityHashSet<OccProfile>();
    public static final IPropertySet.Prop<Set<OccProfile>> RESTRICTED_PROFILES = new IPropertySet.Prop("QueuePath.RESTRICTED_PROFILES", Collections.emptySet());
    public static final Set<Object> PROP_TYPES = new LinkedHashSet<Object>();
    private static final Predicate<ICompElement> s_filter;

    public QueueObject(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_restrictedProfiles == null) {
            this.d_restrictedProfiles = new LinkedIdentityHashSet<OccProfile>();
        } else if (!(this.d_restrictedProfiles instanceof Set)) {
            this.d_restrictedProfiles = new LinkedIdentityHashSet<OccProfile>(this.d_restrictedProfiles);
        }
    }

    @Override
    public boolean surrogateEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        QueueObject qo = (QueueObject)obj;
        return Objects.equals(this.getName(), qo.getName()) && Objects.equals(this.d_color, qo.d_color) && this.d_transparency == qo.d_transparency && theUtil.surrogateSetsEqual(this.d_restrictedProfiles, qo.d_restrictedProfiles) && theUtil.surrogateSetsEqual(this.getMembers(), qo.getMembers());
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.changedEvt(new Object[0]);
    }

    public void setColor(Color c) {
        if (!Objects.equals(this.d_color, c)) {
            this.d_color = c;
            for (IQueueElement elem : this.getMembers(IQueueElement.class)) {
                elem.changedEvt(MerlinData.COLOR);
            }
            this.changedEvt(MerlinData.COLOR);
        }
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setOpacity(float opacity) {
        float trans = 1.0f - opacity;
        if (theUtil.eq(trans, this.d_transparency, 0.0)) {
            return;
        }
        this.d_transparency = trans;
        for (IQueueElement elem : this.getMembers(IQueueElement.class)) {
            elem.changedEvt(MerlinData.OPACITY);
        }
        this.changedEvt(MerlinData.OPACITY);
    }

    public float getOpacity() {
        return 1.0f - this.d_transparency;
    }

    public Color getDisplayColor() {
        return MerlinDispProps.applyAlpha(this.getColor(), this.getOpacity());
    }

    public void setRestrictedProfiles(Set<OccProfile> profs) {
        this.d_restrictedProfiles = profs;
    }

    public Set<OccProfile> getRestrictedProfiles() {
        return (Set)this.d_restrictedProfiles;
    }

    public List<String> getRestrictedProfiles_Strings() {
        ArrayList<String> profs = new ArrayList<String>();
        for (OccProfile prof : this.d_restrictedProfiles) {
            profs.add(prof.getName());
        }
        return profs;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    public <T> void setProperty(IPropertySet.Prop<T> prop, T value) {
        this.setProperty((Object)prop, value);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.COLOR) {
            this.setColor((Color)value);
        } else if (property == MerlinData.OPACITY) {
            this.setOpacity(((IOpacity)value).getValue());
        } else if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (property == RESTRICTED_PROFILES) {
            this.setRestrictedProfiles((Set)value);
        } else assert (false) : "Unsupported Operation: <EgressAgent>.setProperty(" + property + ")";
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NAME) {
            return this.getName();
        }
        if (property == MerlinData.COLOR) {
            return this.getColor();
        }
        if (property == MerlinData.OPACITY) {
            return new Opacity(this.getOpacity());
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == RESTRICTED_PROFILES) {
            return this.getRestrictedProfiles();
        }
        return NOT_SUPPORTED;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof QueueObject)) {
            return;
        }
        QueueObject qo = (QueueObject)obj;
        this.pauseUpdates();
        super.restoreFrom(obj);
        this.setVisible(qo.isVisible());
        this.setOpacity(qo.getOpacity());
        this.setColor(qo.getColor());
        this.setRestrictedProfiles(qo.getRestrictedProfiles());
        this.resumeUpdates();
    }

    @Override
    public void add(ICompElement obj) {
        if (!this.getFilter().test(obj)) {
            return;
        }
        super.add(obj);
    }

    @Override
    public void addAll(Collection<? extends ICompElement> objs) {
        super.addAll(theUtil.filter(objs, IQueueElement.class));
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return null;
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        assert (old != null);
        LinkedIdentityHashSet<OccProfile> newProfiles = new LinkedIdentityHashSet<OccProfile>((Collection<OccProfile>)this.getRestrictedProfiles());
        newProfiles.remove(old);
        if (replacement != null && replacement instanceof OccProfile) {
            newProfiles.add((OccProfile)replacement);
        }
        this.setProperty(RESTRICTED_PROFILES, newProfiles);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.getRestrictedProfiles());
    }

    public void validate(MerlinData md, SimError.Level errLevel, Consumer<SimError> errors) {
        QueueObject qo = this;
        if (qo.flatten(QueueService.class).isEmpty()) {
            errors.accept(new SimError(errLevel, Intl.intl("A Queue must contain at least one Service."), Intl.intl("Delete or add a Service."), this));
        }
        if (qo.flatten(QueuePath.class).isEmpty()) {
            errors.accept(new SimError(errLevel, Intl.intl("A Queue must contain at least one Path."), Intl.intl("Delete or add a Path."), qo));
        } else {
            Set<OccProfile> qProfs = qo.getRestrictedProfiles();
            LinkedIdentityHashSet allPathRestrictedProfs = new LinkedIdentityHashSet();
            for (OccProfile prof : md.profiles.flatten(OccProfile.class)) {
                allPathRestrictedProfs.add(prof);
            }
            for (QueuePath path : qo.flatten(QueuePath.class)) {
                Set<OccProfile> pathProfs = path.getRestrictedProfiles();
                if (pathProfs.isEmpty()) {
                    allPathRestrictedProfs.clear();
                    break;
                }
                allPathRestrictedProfs.removeIf(qProf -> !pathProfs.contains(qProf));
            }
            for (OccProfile prof : allPathRestrictedProfs) {
                if (qProfs.contains(prof)) continue;
                errors.accept(new SimError(errLevel, Intl.intl("A Queue allows a profile that its Path(s) cannot accept."), Intl.intl("Change the Accepted Profiles in the Queue or Path"), qo));
                break;
            }
        }
    }

    static {
        PROP_TYPES.add(NAME);
        PROP_TYPES.add(MerlinData.COLOR);
        PROP_TYPES.add(MerlinData.OPACITY);
        PROP_TYPES.add(MerlinData.VISIBILITY);
        PROP_TYPES.add(RESTRICTED_PROFILES);
        s_filter = new TypeFilter<ICompElement>(QueuePath.class, QueueService.class);
    }
}

