/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.AMerlinObj;
import merlin.data.AssistedEvacTeam;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class WaitForAssistance
extends AMerlinObj
implements IBehaviorAction,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<Set<AssistedEvacTeam>> TEAMS = new IPropertySet.Prop("WaitForAssistance.TEAMS", Collections.emptySet());
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(NamedMerlinObj.NAME, TEAMS);
    public static final List<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(WaitForAssistance.class);
    private PropertySet d_props = new PropertySet();

    public WaitForAssistance(Set<AssistedEvacTeam> teams) {
        this.d_props.set(TEAMS, teams instanceof Set ? teams : new LinkedIdentityHashSet(teams));
    }

    public Predicate<AssistedEvacTeam> getTeamFilter() {
        Set<AssistedEvacTeam> teams = this.get(TEAMS);
        return teams.isEmpty() ? Predicates.alwaysTrue() : Filters.accept(teams);
    }

    @Override
    public WaitForAssistance clone() {
        WaitForAssistance clone = (WaitForAssistance)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public WaitForAssistance getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof WaitForAssistance)) {
            return;
        }
        WaitForAssistance ao = (WaitForAssistance)obj;
        this.pauseUpdates();
        for (IPropertySet.Prop<?> prop : ALL_PROPS) {
            this.d_props.setIfNotDefault(prop, ao.d_props.get(prop));
        }
        this.resumeUpdates();
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String getName() {
        Set<AssistedEvacTeam> teams = this.get(TEAMS);
        if (teams.size() == 1) {
            return String.format(Intl.intl("Wait for assistance <%s>"), teams.iterator().next().getName());
        }
        if (teams.isEmpty()) {
            return Intl.intl("Wait for assistance <any team>");
        }
        return Intl.intl("Wait for assistance");
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        }
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (value != this.d_props.get(prop)) {
            this.d_props.setIfNotDefault(prop, value);
            this.changedEvt(prop);
        }
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        assert (old != null);
        LinkedIdentityHashSet newTeams = new LinkedIdentityHashSet((Collection)this.get(TEAMS));
        newTeams.remove(old);
        if (replacement != null && replacement instanceof AssistedEvacTeam) {
            newTeams.add((AssistedEvacTeam)replacement);
        }
        this.set(TEAMS, newTeams);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        for (AssistedEvacTeam team : this.get(TEAMS)) {
            deps.add(DLink.WEAK, team);
        }
    }

    private int surrogateHashCode() {
        int hash = 7;
        for (AssistedEvacTeam team : this.get(TEAMS)) {
            hash = 31 * hash + theUtil.hashCode(team);
        }
        return hash;
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        WaitForAssistance comparableAction = (WaitForAssistance)comparable;
        return theUtil.surrogateSetsEqual((Collection)this.get(TEAMS), (Collection)comparableAction.get(TEAMS), comparedSet);
    }
}

