/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.SimError;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.egress.scripting.RoomLocationGeometry;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class GotoWaypoint
extends NamedMerlinObj
implements IBehaviorAction,
IEgressObj,
IDestinationAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final Object PROP_LOC = "WaypointGoal.LOC";
    public static final Object PROP_ARRIVE_RADIUS = "WaypointGoal.ARRIVE_RADIUS";
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(MerlinData.VISIBILITY, NamedMerlinObj.NAME, PROP_LOC, PROP_ARRIVE_RADIUS);
    private boolean d_visible = true;
    private Point3d d_location;
    private UnitDouble d_arriveRadius;
    @SkipDep
    private transient IEgressOccupiable d_room;
    private Vector3d d_normal;
    private static final Color BASE_COLOR = Color.RED;

    public GotoWaypoint(String name, Point3d loc, IEgressOccupiable room, Vector3d roomNormal, UnitDouble arriveRad) {
        super(name);
        this.d_location = loc;
        this.d_room = room;
        this.d_normal = roomNormal;
        this.d_arriveRadius = arriveRad;
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String getSetName() {
        return super.getName();
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            name = String.format(Intl.intl("Goto %s"), GotoWaypoint.format(this.d_location));
        }
        return name;
    }

    private static String format(Point3d p) {
        Unit su = Geometry.LENGTH_UNIT;
        Unit du = MerlinApp.getApp().getUnitSystem().getLength();
        return String.format("(%.1f, %.1f, %.1f) %s", UnitDouble.convert(p.x, su, du), UnitDouble.convert(p.y, su, du), UnitDouble.convert(p.z, su, du), du.toString());
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public Point3d astarGetTestPoint() {
        return this.d_location;
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.d_location;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.d_location;
    }

    public boolean accept(MerlinData md, Composite<?> group) {
        return group instanceof Behavior;
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_room = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public void connectTo(IEgressObj conn) {
        if (conn instanceof IEgressOccupiable) {
            // empty if block
        }
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_room) {
            this.d_room = null;
            this.d_normal = GeomConstants.VEC3D_ZPOS;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_room == null ? Collections.EMPTY_LIST : Arrays.asList(this.d_room);
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_room == null;
    }

    @Override
    public boolean updateTopo() {
        GeomUtil.FindResult room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(this.d_location.x, this.d_location.y, this.d_location.z + 1.0E-6), new Point3d(this.d_location.x, this.d_location.y, this.d_location.z - 1.0E-6), 1);
        if (room != null) {
            this.d_room = room.room;
            this.d_normal = room.faceNormal;
            this.d_location = room.p;
            this.changedEvt(new Object[0]);
        }
        return true;
    }

    @Override
    public IDestination getDestination() {
        return new Destination();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof GotoWaypoint)) {
            return;
        }
        GotoWaypoint wg = (GotoWaypoint)obj;
        this.pauseUpdates();
        super.setName(wg.getName());
        this.d_arriveRadius = wg.d_arriveRadius;
        this.d_location = wg.d_location;
        this.d_room = wg.d_room;
        this.d_normal = wg.d_normal;
        this.d_visible = wg.d_visible;
        this.changedEvt(MerlinData.TOPOLOGY);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == PROP_LOC) {
            return this.getLocation();
        }
        if (property == PROP_ARRIVE_RADIUS) {
            return this.getArriveRadius();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        }
        if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        }
        if (property == PROP_LOC) {
            this.setLocation((Point3d)value);
        }
        if (property == PROP_ARRIVE_RADIUS) {
            this.setArriveRadius((UnitDouble)value);
        }
    }

    public Point3d getLocation() {
        return this.d_location;
    }

    public void setLocation(Point3d loc) {
        if (!this.d_location.equals(loc)) {
            this.pauseUpdates();
            this.d_location = loc;
            this.changedEvt(MerlinData.TOPOLOGY);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    protected void setLocation(IEgressOccupiable room, Vector3d roomNorm, Point3d loc) {
        this.d_location = loc;
        this.d_normal = roomNorm;
        if (room != this.d_room) {
            if (this.getDomain() != null) {
                if (this.d_room != null) {
                    this.d_room.disconnectFrom(this);
                    this.disconnectFrom(this.d_room);
                }
                if (room != null) {
                    room.connectTo(this);
                }
            }
            this.d_room = room;
        }
        this.changedEvt(new Object[0]);
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    public Vector3d getRoomNorm() {
        return this.d_normal;
    }

    public UnitDouble getArriveRadius() {
        return this.d_arriveRadius;
    }

    public void setArriveRadius(UnitDouble arriveRad) {
        if (!this.d_arriveRadius.equals(arriveRad)) {
            this.d_arriveRadius = arriveRad;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getWaypointGeom());
    }

    public IGeom getWaypointGeom() {
        return new RoomLocationGeometry(this.d_room, this.d_normal, this.d_location, this.d_arriveRadius.getValue(Geometry.LENGTH_UNIT));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof RoomLocationGeometry) {
            RoomLocationGeometry wgeom = (RoomLocationGeometry)geom;
            this.pauseUpdates();
            this.setArriveRadius(new UnitDouble(wgeom.radius, Geometry.LENGTH_UNIT));
            this.setLocation(wgeom.room, wgeom.normal, wgeom.location);
            this.resumeUpdates();
        } else if (geom instanceof Point) {
            Point p = (Point)geom;
            this.setLocation(p.loc);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder gprops = new PropsBuilder();
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Face(BASE_COLOR, null, 0));
        gprops.add(new IPrimProps.Vertex(Color.BLACK, 8.0));
        return new DisplayGeom(geom, gprops);
    }

    private int surrogateHashCode() {
        int hash = 7;
        hash = 31 * hash + theUtil.hashCode(this.getLocation());
        hash = 31 * hash + theUtil.hashCode(this.getArriveRadius());
        hash = 31 * hash + theUtil.hashCode(this.isVisible());
        return hash;
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        GotoWaypoint comparableWP = (GotoWaypoint)comparable;
        return Objects.equals(this.getSetName(), comparableWP.getSetName()) && this.getLocation().equals(comparableWP.getLocation()) && this.getArriveRadius().equals(comparableWP.getArriveRadius());
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        this.updateTopo();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.d_room);
    }

    public class Destination
    implements IDestination {
        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Destination && ((Destination)obj).getWaypoint().d_location.equals(GotoWaypoint.this.d_location) && ((Destination)obj).getWaypoint().d_arriveRadius.equals(GotoWaypoint.this.d_arriveRadius) && ((Destination)obj).getWaypoint().d_normal.equals(GotoWaypoint.this.d_normal) && Objects.equals(((Destination)obj).getWaypoint().d_room, GotoWaypoint.this.d_room);
        }

        @Override
        public int hashCode() {
            return 0xFA9832F ^ GotoWaypoint.this.d_location.hashCode() + GotoWaypoint.this.d_arriveRadius.hashCode() + GotoWaypoint.this.d_normal.hashCode() + Objects.hashCode(GotoWaypoint.this.d_room);
        }

        protected GotoWaypoint getWaypoint() {
            return GotoWaypoint.this;
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            if (MerlinUtil.isConnected((IEgressObj)source, GotoWaypoint.this)) {
                return null;
            }
            return new IUnreachable(){

                @Override
                public SimError getError(IMerlinObj source) {
                    String name = MerlinUtil.getName(source);
                    return new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("\"%s\" cannot reach the next waypoint."), name), String.format(Intl.intl("Move \"%s,\" move the next waypoint, or connect their rooms."), name), source, GotoWaypoint.this);
                }
            };
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() {
            return GotoWaypoint.this.d_room == null ? Collections.EMPTY_LIST : Arrays.asList(GotoWaypoint.this.d_room);
        }
    }
}

