/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Random;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.GotoExits;
import merlin.util.MerlinUtil;
import thunderheadeng.util.TypeFilter;

public class BehaviorRoot
extends GeomComposite<Behavior> {
    private static final long serialVersionUID = 1L;
    public Behavior NO_CHANGE;
    public Behavior DEFAULT;
    private static final Predicate<ICompElement> s_filter = new TypeFilter<ICompElement>(Behavior.class, BehaviorRoot.class);

    public BehaviorRoot() {
        this(Intl.intl("Behaviors"));
        this.addDefault();
    }

    public BehaviorRoot(String name) {
        super(name);
        this.initNoChangeBehavior();
    }

    public void addDefault() {
        this.DEFAULT = new Behavior(Intl.intl("Goto Any Exit"), new GotoExits());
        this.DEFAULT.setColor(MerlinUtil.newRandomOccColor(new Random(4930185321171587L)));
        this.add(this.DEFAULT);
    }

    private void initNoChangeBehavior() {
        this.NO_CHANGE = new Behavior(Intl.intl("No Change"));
        this.NO_CHANGE.setColor(MerlinUtil.newRandomOccColor(new Random(38529902911L)));
        this.NO_CHANGE.setDomain((MerlinData)this.getDomain(), this);
    }

    public void restoreFrom(BehaviorRoot root) {
        super.restoreFrom(root);
        if (this.isEmpty()) {
            this.addDefault();
        }
        this.NO_CHANGE = root.NO_CHANGE;
        if (this.NO_CHANGE == null) {
            this.initNoChangeBehavior();
        }
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new BehaviorRoot(name);
    }

    public void reset() {
        this.pauseUpdates();
        this.clear();
        this.addDefault();
        this.resumeUpdates();
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Behavior Group");
    }
}

