/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.data.AMerlinObj;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.agents.Occupancy;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.EgressBlockage;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressModelGeom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.geom.RoomUtil;
import merlin.data.egress.geom.SpeedModifier;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.geom.Geometry;
import merlin.geom.IMerlinDispProps;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.io.inferno.InfernoGeom;
import merlin.io.inferno.InfernoType;
import merlin.unitsystem.SIUS;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class EgressRoom
extends AEgressComp
implements Serializable,
IEgressOccupiable,
ISurrogate,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final int DEFAULT_CLEANUP_OPTIONS = 23;
    public static final Object AREA_ADDED = "CopPolyNavGeom.AREA_ADDED";
    public static final Object AREA_SUBTRACTED = "CopPolyNavGeom.AREA_SUBTRACTED";
    public static final Object CLEARED = "CopPolyNavGeom.CLEARED";
    private static final Class<? extends IEgressObj>[] s_topTypes = new Class[]{EgressAgent.class, IEgressConnector.class, EgressCorridor.class, EgressRoom.class, GotoWaypoint.class, QueueService.class, QueuePathNode.class, Attractor.class, OccTarget.class};
    public static final Set<Object> PROP_TYPES = Sets.appendLHS(AEgressComp.PROP_TYPES, AREA, OCC_COUNT, SPEED_MODIFIER, TAGS, MerlinData.MATERIAL);
    private static final Matrix4d s_identity = new Matrix4d();
    @SkipDep
    private Model d_geometry;
    private Map<Integer, EgressBlockage> d_blockages;
    private SpeedModifier d_speedModifier;
    private Boolean d_overlapsSelf = null;
    @SkipDep
    private transient SoftReference<Model> d_displayGeom;
    private Set<String> d_tags;
    private IOccCount d_capacity = new ConstOccCount(50);
    private boolean d_capacityEnabled = false;
    private IMaterial d_material;
    @SkipDep
    private transient Map<Class<? extends IEgressObj>, Set<IEgressObj>> d_topology;
    private static Function<Class<? extends IEgressObj>, Set<IEgressObj>> newSet;

    public EgressRoom(String name) {
        this(name, new Model(), 0);
    }

    public EgressRoom(String name, Model geometry) {
        this(name, geometry, 23);
    }

    public EgressRoom(String name, Model geometry, int cleanupOptions) {
        super(name);
        this.d_geometry = geometry;
        this.d_geometry = RoomUtil.cleanup(this.d_geometry, cleanupOptions, Predicates.alwaysTrue());
        this.d_speedModifier = null;
        this.d_topology = new ListMap<Class<? extends IEgressObj>, Set<IEgressObj>>();
        this.d_blockages = new LinkedHashMap<Integer, EgressBlockage>();
        this.d_speedModifier = SpeedModifier.DEFAULT;
        this.d_tags = Collections.emptySet();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_capacity = new ConstOccCount(50);
        this.d_capacityEnabled = false;
        in.defaultReadObject();
        this.d_topology = new ListMap<Class<? extends IEgressObj>, Set<IEgressObj>>();
        if (this.d_blockages == null) {
            this.d_blockages = new LinkedHashMap<Integer, EgressBlockage>();
        }
        if (this.d_speedModifier == null) {
            this.d_speedModifier = SpeedModifier.DEFAULT;
        }
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    @Override
    public Point3d astarGetTestPoint() {
        for (Face face : this.d_geometry.getFaces()) {
            Point3d p = this.d_geometry.findPointInFace(face);
            if (p == null) continue;
            return p;
        }
        return new Point3d();
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        if (this.isConnected(obj)) {
            return this.astarGetSharedPt(obj);
        }
        Point3d projPt = null;
        double minDistSq = Double.POSITIVE_INFINITY;
        for (Set<IEgressObj> top : this.d_topology.values()) {
            for (IEgressObj adj : top) {
                Point3d sharedPt = this.astarGetSharedPt(adj);
                double distsq = p.distanceSquared(sharedPt);
                if (!(distsq < minDistSq)) continue;
                minDistSq = distsq;
                projPt = sharedPt;
                if (!(distsq <= 1.0E-12)) continue;
                return projPt;
            }
        }
        return projPt == null ? this.astarGetTestPoint() : projPt;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return adj.astarGetSharedPt(this);
    }

    @Override
    public Set<String> getTags() {
        return this.d_tags;
    }

    @Override
    public void setTags(Set<String> tags) {
        if (Objects.equals(tags, this.d_tags)) {
            return;
        }
        this.d_tags = tags;
        this.changedEvt(TAGS);
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_topology);
        for (EgressBlockage blockage : this.d_blockages.values()) {
            blockage.writeTopology(oos);
        }
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0018)) {
            this.d_topology.clear();
            ((Set)ois.readObject()).forEach(this::addTop);
            ((Set)ois.readObject()).forEach(this::addTop);
            ((Set)ois.readObject()).forEach(this::addTop);
            if (MerlinOIS.isVersion(ois, MerlinIO.Version.VER_0006)) {
                Set actions = (Set)ois.readObject();
                theUtil.filter(actions, IEgressObj.class).forEach(this::addTop);
            }
        } else {
            if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0108)) {
                this.d_topology.clear();
                ((Set)ois.readObject()).forEach(this::addTop);
            } else {
                this.d_topology = (Map)ois.readObject();
            }
            for (EgressBlockage blockage : this.d_blockages.values()) {
                blockage.readTopology(ois);
            }
        }
    }

    private void addTop(IEgressObj obj) {
        this.d_topology.computeIfAbsent(EgressRoom.getTopType(obj), newSet).add(obj);
    }

    private void removeTop(IEgressObj obj) {
        Class<? extends IEgressObj> type = EgressRoom.getTopType(obj);
        Set<IEgressObj> set = this.d_topology.get(type);
        if (set != null && set.remove(obj) && set.isEmpty()) {
            this.d_topology.remove(type);
        }
    }

    private static Class<? extends IEgressObj> getTopType(IEgressObj obj) {
        Class<?> otype = obj.getClass();
        for (Class<? extends IEgressObj> type : s_topTypes) {
            if (!type.isAssignableFrom(otype)) continue;
            return type;
        }
        assert (false);
        return null;
    }

    @Override
    public boolean getOccupantsAllowed() {
        return true;
    }

    private void changedEvt(boolean updateDisplay, boolean updateOverlap) {
        if (updateDisplay) {
            this.markDisplayDirty();
        }
        if (updateOverlap) {
            this.markOverlapDirty();
        }
        this.pauseUpdates();
        super.changedEvt(new Object[0]);
        this.changedEvt(this.d_blockages.values(), new Object[0]);
        this.resumeUpdates();
    }

    private void changedEvt(boolean geomChanged) {
        this.changedEvt(geomChanged, geomChanged);
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        this.pauseUpdates();
        boolean changed = super.changedEvt(changes);
        this.changedEvt(this.d_blockages.values(), changes);
        this.resumeUpdates();
        return changed;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone(false, true, null);
    }

    @Override
    public void restoreFrom(Object obj) {
        this.pauseUpdates();
        super.restoreFrom(obj);
        this.markTopoDirty();
        EgressRoom rm = (EgressRoom)obj;
        this.d_geometry = (Model)rm.d_geometry.clone();
        this.d_overlapsSelf = rm.d_overlapsSelf;
        this.d_speedModifier = rm.d_speedModifier;
        this.d_tags = rm.d_tags;
        this.d_material = rm.d_material;
        ArrayList<EgressBlockage> toRemove = new ArrayList<EgressBlockage>();
        ArrayList<EgressBlockage> toAdd = new ArrayList<EgressBlockage>();
        for (ICompElement o : this.d_blockages.values()) {
            if (rm.d_blockages.containsValue(o)) continue;
            toRemove.add((EgressBlockage)o);
        }
        for (ICompElement o : rm.d_blockages.values()) {
            if (this.d_blockages.containsValue(o)) continue;
            toAdd.add((EgressBlockage)o);
        }
        this.d_blockages.clear();
        this.d_blockages.putAll(rm.d_blockages);
        this.removeChildren(toRemove);
        this.addChildren(toAdd);
        this.setCapacity(rm.getCapacity());
        this.setCapacityEnabled(rm.getCapacityEnabled());
        this.changedEvt(true, false);
        this.resumeUpdates();
    }

    private void markDisplayDirty() {
        this.d_displayGeom = null;
    }

    private void markOverlapDirty() {
        this.d_overlapsSelf = null;
    }

    @Override
    public boolean surrogateEquals(Object obj) {
        return this.surrogateEqualsHelper(obj);
    }

    private int surrogateHashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + theUtil.hashCode(this.getCapacity());
        hash = 31 * hash + theUtil.hashCode(this.getArea());
        hash = 31 * hash + theUtil.hashCode(this.d_geometry.getBoundingBox());
        hash = 31 * hash + theUtil.hashCode(this.d_blockages);
        hash = 31 * hash + theUtil.hashCode(this.d_speedModifier);
        return hash;
    }

    @Override
    protected boolean surrogateEqualsHelper(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EgressRoom)) {
            return false;
        }
        EgressRoom room = (EgressRoom)obj;
        return super.surrogateEqualsHelper(room) && this.getCapacity().equals(room.getCapacity()) && this.getArea().equals(room.getArea()) && this.d_geometry.getBoundingBox().equals(room.d_geometry.getBoundingBox()) && theUtil.surrogateMapsEqual(this.d_blockages, room.d_blockages, true) && Objects.equals(this.d_speedModifier, room.d_speedModifier);
    }

    public EgressRoom clone(boolean deep, boolean cloneGeom, Map<IMerlinObj, IMerlinObj> cloneMap) {
        EgressRoom clone = (EgressRoom)super.clone();
        if (cloneGeom) {
            clone.d_geometry = (Model)this.d_geometry.clone();
        }
        clone.d_topology = new ListMap<Class<? extends IEgressObj>, Set<IEgressObj>>();
        clone.d_blockages = new LinkedHashMap<Integer, EgressBlockage>();
        for (Map.Entry<Integer, EgressBlockage> entry : this.d_blockages.entrySet()) {
            EgressBlockage bclone = entry.getValue();
            if (deep) {
                bclone = (EgressBlockage)bclone.clone();
                bclone.setRoom(clone);
                if (cloneMap != null) {
                    cloneMap.put(entry.getValue(), bclone);
                }
            }
            clone.d_blockages.put(entry.getKey(), bclone);
        }
        clone.markDisplayDirty();
        return clone;
    }

    @Override
    public EgressRoom clone() {
        return this.clone(true, true, null);
    }

    @Override
    public boolean updateTopo() {
        return false;
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return true;
    }

    private void markTopoDirty() {
        this.changedEvt(MerlinData.TOPOLOGY);
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return s_topTypes;
    }

    public boolean isConnected(IEgressObj obj) {
        Class<? extends IEgressObj> type = EgressRoom.getTopType(obj);
        if (type == null) {
            return false;
        }
        return this.d_topology.getOrDefault(type, Collections.emptySet()).contains(obj);
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        if (this.d_topology.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.d_topology.size() == 1) {
            return new ArrayList(this.d_topology.values().iterator().next());
        }
        ArrayList<IEgressObj> top = new ArrayList<IEgressObj>();
        for (Set<IEgressObj> set : this.d_topology.values()) {
            top.addAll(set);
        }
        return top;
    }

    @Override
    public void connectTo(IEgressObj obj) {
        boolean geomChanged = obj instanceof IEgressConnector || obj instanceof EgressCorridor;
        this.addTop(obj);
        if (geomChanged) {
            this.changedEvt(geomChanged);
        } else {
            this.changedEvt(MerlinData.CONNECTION);
        }
    }

    @Override
    public void disconnectFrom(IEgressObj obj) {
        boolean geomChanged = obj instanceof IEgressConnector || obj instanceof EgressCorridor;
        this.removeTop(obj);
        if (geomChanged) {
            this.changedEvt(geomChanged);
        } else {
            this.changedEvt(MerlinData.CONNECTION);
        }
    }

    @Override
    public void getConnectors(Collection<? super IEgressConnector> connectors) {
    }

    public SpeedModifier getSpeedModifier() {
        return this.d_speedModifier;
    }

    public void setSpeedModifier(SpeedModifier mod) {
        if (Objects.equals(this.d_speedModifier, mod)) {
            return;
        }
        this.d_speedModifier = mod;
        this.changedEvt(false);
    }

    @Override
    public Model getModel() {
        return this.d_geometry;
    }

    @Override
    public boolean isModelCached() {
        return true;
    }

    public void setModel(Model geometry) {
        this.d_geometry = geometry;
        this.markTopoDirty();
        this.changedEvt(true);
    }

    public boolean getModificationsAllowed() {
        return true;
    }

    public boolean add(EgressRoom comp2) {
        Model model1 = (Model)this.d_geometry.clone();
        Model model2 = (Model)comp2.d_geometry.clone();
        LinkedHashSet<Integer> closedIds = new LinkedHashSet<Integer>(this.d_blockages.keySet());
        ArrayList<EgressBlockage> newBlockages = new ArrayList<EgressBlockage>();
        LinkedIdentityHashMap<Face, int[]> faceRemaps = new LinkedIdentityHashMap<Face, int[]>();
        for (Map.Entry<Integer, EgressBlockage> entry : comp2.d_blockages.entrySet()) {
            EgressBlockage blockage2 = entry.getValue();
            String string = blockage2.getName();
            int remapId = -1;
            boolean equivFound = false;
            for (EgressBlockage blockage1 : this.d_blockages.values()) {
                if (!blockage1.getName().equals(string)) continue;
                equivFound = true;
                if (blockage1.getFaceId() == blockage2.getFaceId()) continue;
                remapId = blockage1.getFaceId();
                break;
            }
            if (!equivFound) {
                int cid = EgressRoom.getNextCustomId(closedIds);
                closedIds.add(cid);
                EgressBlockage newBlockage = (EgressBlockage)blockage2.clone();
                newBlockage.setFaceId(cid);
                newBlockages.add(newBlockage);
                remapId = cid;
            }
            if (remapId == -1) continue;
            int[] remap = new int[]{blockage2.getFaceId(), remapId};
            for (Face face : model2.getFaces(blockage2.getFaceId())) {
                faceRemaps.put(face, remap);
            }
        }
        for (Map.Entry<Integer, EgressBlockage> entry : faceRemaps.entrySet()) {
            Iterator<Face> face = (Face)((Object)entry.getKey());
            int[] nArray = (int[])entry.getValue();
            int[] remId = new int[]{nArray[0]};
            ((AModelObj)((Object)face)).removeGroups(remId);
            ((AModelObj)((Object)face)).addGroup(nArray[1]);
        }
        int t1 = Integer.MAX_VALUE;
        int n = 0x7FFFFFFE;
        for (Face face : model2.getFaces()) {
            face.addGroup(n);
        }
        for (Face face : model1.getFaces()) {
            face.addGroup(t1);
        }
        model1.merge(model2);
        ArrayList<Edge> sharedEdges = new ArrayList<Edge>();
        for (Edge edge : model1.getEdges()) {
            if (edge.faces.size() <= 1) continue;
            boolean m1Found = false;
            boolean m2Found = false;
            for (Face face : edge.faces) {
                if (face.partOfGroup(t1)) {
                    m1Found = true;
                }
                if (!face.partOfGroup(n)) continue;
                m2Found = true;
            }
            if (!m1Found || !m2Found) continue;
            sharedEdges.add(edge);
        }
        if (sharedEdges.isEmpty()) {
            return false;
        }
        int[] nArray = new int[]{0};
        for (Edge edge : sharedEdges) {
            if (!edge.partOfGroup(1) && !edge.partOfGroup(n)) continue;
            edge.groups = nArray;
        }
        int[] remGroups = new int[]{t1, n};
        for (Face face : model1.getFaces()) {
            face.removeGroups(remGroups);
        }
        this.d_geometry = model1;
        this.pauseUpdates();
        for (EgressBlockage blockage : newBlockages) {
            this.addBlockage(blockage);
        }
        this.markTopoDirty();
        this.changedEvt(true);
        this.resumeUpdates();
        return true;
    }

    public boolean sub(EgressRoom comp2) {
        return this.subtract(comp2.getModel(), false);
    }

    public boolean subVolume(Model volume) {
        return this.subtract(volume, true);
    }

    private static boolean delFace(Model model1, Model subModel, Face face, boolean isVolume) {
        if (face.partOfGroup(Integer.MAX_VALUE)) {
            return true;
        }
        if (!isVolume) {
            return false;
        }
        Point3d testP = model1.findPointInFace(face);
        return testP == null || subModel.contains(testP);
    }

    public List<Face> haveCommonFaces(Model subModel, boolean isVolume) {
        Model model2 = (Model)subModel.clone();
        int[] tempGroup = new int[]{Integer.MAX_VALUE};
        for (Face face : model2.getFaces()) {
            face.groups = tempGroup;
        }
        Model model1 = (Model)this.d_geometry.clone();
        model1.merge(model2);
        return this.haveCommonFaces(model1, model2, isVolume, new ArrayList<Face>());
    }

    private List<Face> haveCommonFaces(Model mergeModel, Model subModel, boolean isVolume, List<Face> delFaces) {
        ArrayList<Face> commonFaces = new ArrayList<Face>();
        for (Face face : mergeModel.getFaces()) {
            if (!EgressRoom.delFace(mergeModel, subModel, face, isVolume)) continue;
            delFaces.add(face);
            if (!face.partOfGroup(0)) continue;
            commonFaces.add(face);
        }
        return commonFaces;
    }

    public boolean subtract(Model subModel, boolean isVolume) {
        Model model2 = (Model)subModel.clone();
        int[] tempGroup = new int[]{Integer.MAX_VALUE};
        for (Face face : model2.getFaces()) {
            face.groups = tempGroup;
        }
        Model model1 = (Model)this.d_geometry.clone();
        model1.merge(model2);
        ArrayList<Face> delFaces = new ArrayList<Face>();
        if (this.haveCommonFaces(model1, subModel, isVolume, delFaces).isEmpty()) {
            return false;
        }
        for (Face face : delFaces) {
            model1.deleteFace(face, true, true);
        }
        int[] boundGroup = new int[]{1};
        for (Edge edge : model1.getEdges()) {
            Face face;
            if (edge.faces.size() != 1 || (face = edge.faces.get(0)).isInternalEdge(edge)) continue;
            edge.groups = boundGroup;
        }
        this.pauseUpdates();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (EgressBlockage blockage : new ArrayList<EgressBlockage>(this.d_blockages.values())) {
            if (!model1.getGroup((int)blockage.getFaceId(), (boolean)true, (boolean)false, (boolean)false).faces.isEmpty()) continue;
            this.removeBlockage(blockage, false);
            arrayList.add(blockage.getFaceId());
        }
        EgressRoom.removeMarkings(model1, theUtil.toIntArray(arrayList));
        this.d_geometry = model1;
        this.markTopoDirty();
        this.changedEvt(true);
        this.resumeUpdates();
        return true;
    }

    private static LineSeg3D toLineSeg3D(LineSeg ls) {
        return new LineSeg3D(ls.p1, ls.p2);
    }

    public Predicate<Edge> getInUseEdgeFilter() {
        final LinkedHashSet inUseEdges = new LinkedHashSet();
        final BiFunction<Point3d, Point3d, LineSeg3D> round = (ep1, ep2) -> new LineSeg3D(Util3D.round(ep1, 9), Util3D.round(ep2, 9));
        Consumer<LineSeg3D> addEdge = e -> inUseEdges.add(round.apply(e.p1, e.p2));
        for (EgressDoor door : theUtil.filter(this.getDoors(), EgressDoor.class)) {
            if (door.getRoom1() == this) {
                addEdge.accept(door.getEdge1());
            }
            if (door.getRoom2() != this) continue;
            addEdge.accept(door.getEdge2());
        }
        for (EgressCorridor corr : this.getCorridors()) {
            EgressCorridor.DoorInfo d1 = corr.getDoor1();
            EgressCorridor.DoorInfo d2 = corr.getDoor2();
            if (d1.getRoom() == this) {
                addEdge.accept(EgressRoom.toLineSeg3D(d1.getEdge()));
            }
            if (d2.getRoom() != this) continue;
            addEdge.accept(EgressRoom.toLineSeg3D(d2.getEdge()));
        }
        if (inUseEdges.isEmpty()) {
            return Predicates.alwaysFalse();
        }
        return new Predicate<Edge>(){

            @Override
            public boolean test(Edge o) {
                if (!o.curve.isLinear()) {
                    return false;
                }
                return inUseEdges.contains(round.apply(o.v1.loc, o.v2.loc)) || inUseEdges.contains(round.apply(o.curve.get(0.0), o.curve.get(1.0)));
            }
        };
    }

    public Model cleanup(Model model) {
        return RoomUtil.cleanup(model, 31, this.getInUseEdgeFilter());
    }

    public void cleanupModel() {
        this.setModel(this.cleanup(this.getModel()));
    }

    public static void cleanup(MerlinData md, Collection<? extends EgressRoom> rooms) {
        if (!rooms.isEmpty()) {
            md.updateTopology();
            rooms.forEach(EgressRoom::cleanupModel);
        }
    }

    @Override
    public boolean isWalkable(Point3d p) {
        return this.d_geometry.findFace(p) != null;
    }

    public List<EgressRoom> addBoundary(Collection<? extends ICurve> boundary, double edgeError) {
        this.d_geometry.addEdges(Integer.MAX_VALUE, EgressRoom.toParms(boundary, edgeError));
        ArrayList<Edge> toDelete = new ArrayList<Edge>();
        int[] boundaryid = new int[]{1};
        for (Edge edge : this.d_geometry.getEdges()) {
            boolean newEdge = edge.partOfGroup(Integer.MAX_VALUE);
            if (newEdge && edge.faces.isEmpty()) {
                toDelete.add(edge);
                continue;
            }
            if (!newEdge) continue;
            edge.groups = boundaryid;
        }
        for (Edge delEdge : toDelete) {
            this.d_geometry.deleteEdge(delEdge, true);
        }
        this.markTopoDirty();
        this.changedEvt(true);
        List<EgressRoom> separated = this.separate();
        return separated;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getRoomGeom());
    }

    public EgressModelGeom getRoomGeom() {
        return this.getGeom(true);
    }

    public EgressModelGeom getGeom(boolean includeBlockages) {
        Predicate<Face> fFilter = includeBlockages ? Filters.acceptAll(Face.class) : this.getFaceFilter();
        int options = 1;
        if (this.getModificationsAllowed()) {
            options |= 2;
        }
        return new EgressModelGeom(this.d_geometry, this.getInUseEdgeFilter(), fFilter, this.getBoundaryEdgeFilter(), options);
    }

    @Override
    public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        this.setGeom(geom);
    }

    public void setGeom(IGeom geom) {
        if (!(geom instanceof EgressModelGeom)) {
            return;
        }
        EgressModelGeom mg = (EgressModelGeom)geom;
        this.d_geometry = mg.model;
        this.markTopoDirty();
        this.changedEvt(true);
    }

    private IPrimProps getFaceProps(IMerlinDispProps props) {
        return props.getFaceProps(this, IMerlinDispProps.EgressType.ROOM, this.d_material, this.getColor(), this.getOpacity());
    }

    private IPrimProps getBoundaryProps(IMerlinDispProps props) {
        return props.getEdgeProps(this, IMerlinDispProps.EgressType.BOUNDARY, null, this.getOpacity());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps dprops) {
        if (!(dprops instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps props = (IMerlinDispProps)dprops;
        Model dispModel = null;
        if (this.d_displayGeom != null) {
            dispModel = this.d_displayGeom.get();
        }
        if (dispModel == null) {
            dispModel = (Model)this.d_geometry.clone();
            ArrayList<IParametric3D> sharedEdges = new ArrayList<IParametric3D>();
            for (IEgressConnector iEgressConnector : this.getDoors(true)) {
                sharedEdges.addAll(iEgressConnector.getSharedEdges(this));
            }
            for (EgressCorridor egressCorridor : this.getCorridors(true)) {
                sharedEdges.addAll(egressCorridor.getSharedEdges(this));
            }
            if (!sharedEdges.isEmpty()) {
                dispModel.addEdges(Integer.MAX_VALUE, sharedEdges);
                int[] group = new int[]{0};
                for (Edge edge : dispModel.getEdges()) {
                    if (!edge.partOfGroup(Integer.MAX_VALUE)) continue;
                    edge.groups = group;
                }
            }
            this.d_displayGeom = new SoftReference<Model>(dispModel);
        }
        int options = 5;
        if (this.getModificationsAllowed()) {
            options |= 2;
        }
        EgressModelGeom geom = new EgressModelGeom(dispModel, Filters.rejectAll(Edge.class), this.getFaceFilter(), this.getBoundaryEdgeFilter(), options);
        int n = geom.getNumPrims(1);
        int numBEdges = geom.getNumPrims(2);
        IPrimProps fprops = this.getFaceProps(props);
        IPrimProps bprops = this.getBoundaryProps(props);
        PropsBuilder propsSrc = new PropsBuilder();
        propsSrc.add(fprops, n);
        propsSrc.add(bprops, numBEdges);
        IPropsSrc finalProps = propsSrc.finalizeProps();
        IGeomNode node = GeomNodeUtil.newNode(geom);
        node = ImportedGeom.finalizeTexCoords(node, finalProps);
        return new DisplayGeom(node, finalProps);
    }

    protected Predicate<Face> getFaceFilter() {
        if (this.d_blockages.isEmpty()) {
            return Filters.acceptAll();
        }
        return new Predicate<Face>(){

            @Override
            public boolean test(Face o) {
                for (Integer i : EgressRoom.this.d_blockages.keySet()) {
                    if (!o.partOfGroup(i)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public void getInfernoGeom(List<InfernoGeom> geoms, IMerlinDispProps dprops) {
        ArrayList<EgressRoom> areas = new ArrayList<EgressRoom>(1);
        EgressRoom shape1 = this.clone();
        for (IEgressConnector conn : this.getDoors()) {
            EgressRoom extraGeom = conn.getExtraGeom(this);
            if (extraGeom == null) continue;
            areas.add(extraGeom);
        }
        for (EgressRoom shape2 : areas) {
            shape1.sub(shape2);
            shape2.sub(this);
            shape1.add(shape2);
        }
        shape1.setModel(RoomUtil.cleanup(shape1.getModel(), 23, Predicates.alwaysTrue(), true));
        EgressModelGeom roomGeom = shape1.getGeom(true);
        geoms.add(new InfernoGeom(this, InfernoType.OPEN, roomGeom, this.getFaceProps(dprops)));
        geoms.add(new InfernoGeom(this, InfernoType.BOUNDARY, roomGeom, this.getBoundaryProps(dprops)));
        for (EgressBlockage blockage : this.d_blockages.values()) {
            blockage.getInfernoGeom(geoms, dprops);
        }
    }

    public List<EgressRoom> separate() {
        List<Model> separatedModels = RoomUtil.separate(this.d_geometry);
        if (separatedModels.size() <= 1) {
            return Arrays.asList(this);
        }
        ArrayList<EgressRoom> separatedRooms = new ArrayList<EgressRoom>(separatedModels.size());
        for (Model model : separatedModels) {
            EgressRoom newRoom = this.clone(false, false, null);
            newRoom.d_geometry = model;
            newRoom.setVisible(this.isVisible());
            newRoom.setColor(this.getColor());
            newRoom.setOpacity(this.getOpacity());
            newRoom.setTags(this.getTags());
            newRoom.d_blockages.clear();
            for (EgressBlockage blockage : this.d_blockages.values()) {
                if (newRoom.d_geometry.getGroup((int)blockage.getFaceId(), (boolean)true, (boolean)false, (boolean)false).faces.isEmpty()) continue;
                newRoom.addBlockage((EgressBlockage)blockage.clone());
            }
            separatedRooms.add(newRoom);
        }
        int biggestRoomIx = EgressRoom.getBiggestRoom(separatedRooms);
        EgressRoom biggestRoom = (EgressRoom)separatedRooms.get(biggestRoomIx);
        separatedRooms.remove(biggestRoomIx);
        separatedRooms.add(0, biggestRoom);
        return separatedRooms;
    }

    private static int getBiggestRoom(List<EgressRoom> rooms) {
        UnitDouble biggestRoomArea = new UnitDouble(-1.0, SIUS.unit(4));
        int biggestRoom = 0;
        for (int m = 0; m < rooms.size(); ++m) {
            UnitDouble area = rooms.get(m).getArea();
            if (area.compareTo(biggestRoomArea) <= 0) continue;
            biggestRoomArea = area;
            biggestRoom = m;
        }
        return biggestRoom;
    }

    public boolean overlapsSelf() {
        if (this.d_overlapsSelf == null) {
            theTimer timer = new theTimer();
            this.d_overlapsSelf = RoomUtil.overlapsSelf(this.d_geometry);
            double time = timer.curr();
            System.out.printf("Recalculated overlap for %s: %g sec%n", this.getName(), time);
        }
        return this.d_overlapsSelf;
    }

    public Set<IEgressConnector> getDoors(boolean excludeDisabled) {
        if (excludeDisabled) {
            return theUtil.filter(this.getDoors(), d -> !(d instanceof AEgressComp) || ((AEgressComp)((Object)d)).isEnabled());
        }
        return this.getDoors();
    }

    public Set<IEgressConnector> getDoors() {
        return this.getTop(IEgressConnector.class);
    }

    public Set<EgressCorridor> getCorridors(boolean excludeDisabled) {
        if (excludeDisabled) {
            return theUtil.filter(this.getCorridors(), d -> d.isEnabled());
        }
        return this.getCorridors();
    }

    public Set<EgressCorridor> getCorridors() {
        return this.getTop(EgressCorridor.class);
    }

    @Override
    public Set<EgressAgent> getOccupants() {
        return this.getTop(EgressAgent.class);
    }

    @Override
    public Set<GotoWaypoint> getWaypoints() {
        return this.getTop(GotoWaypoint.class);
    }

    private <T extends IEgressObj> Set<T> getTop(Class<T> type) {
        assert (Arrays.asList(s_topTypes).contains(type));
        return Collections.unmodifiableSet(this.d_topology.getOrDefault(type, Collections.EMPTY_SET));
    }

    @Override
    public Occupancy getOccupancy() {
        return new Occupancy(this);
    }

    @Override
    public UnitDouble getArea() {
        double area = 0.0;
        for (Face face : this.d_geometry.getFaces()) {
            area += face.getArea();
        }
        UnitDouble areau = new UnitDouble(area, Geometry.AREA_UNIT);
        return areau;
    }

    public double getRoomArea() {
        return this.getArea().getRawValue();
    }

    public int getNextCustomId() {
        return EgressRoom.getNextCustomId(this.d_blockages.keySet());
    }

    private static int getNextCustomId(Set<Integer> closedIds) {
        int nextId = 100;
        while (closedIds.contains(nextId)) {
            ++nextId;
        }
        return nextId;
    }

    public int subdivide(IFaceClassifier classifier, Collection<? extends ICurve> boundary, double edgeError) throws Exception {
        return this.subdivide2(classifier, EgressRoom.toParms(boundary, edgeError));
    }

    protected static List<IParametric3D> toParms(Collection<? extends ICurve> curves, double edgeError) {
        ArrayList<IParametric3D> parms = new ArrayList<IParametric3D>(curves.size());
        for (ICurve iCurve : curves) {
            Mesh segments = iCurve.getSegments(edgeError);
            for (int m = 0; m < segments.indices.length; m += 2) {
                parms.add(new LineSeg3D(segments.vertices[segments.indices[m]], segments.vertices[segments.indices[m + 1]]));
            }
        }
        return parms;
    }

    public int subdivide2(IFaceClassifier classifier, Collection<? extends IParametric3D> boundary) throws Exception {
        int newId = this.getNextCustomId();
        int tempEdgeId = Integer.MAX_VALUE;
        Model newGeom = (Model)this.d_geometry.clone();
        newGeom.addEdges(tempEdgeId, boundary);
        ArrayList<Edge> newEdges = new ArrayList<Edge>(newGeom.getGroup((int)tempEdgeId, (boolean)false, (boolean)true, (boolean)false).edges);
        LinkedIdentityHashSet closedFaces = new LinkedIdentityHashSet();
        for (Edge edge : newEdges) {
            for (Face f : edge.faces) {
                if (closedFaces.contains(f)) continue;
                Set<Face> touching = EgressRoom.findTouchingFaces(f, tempEdgeId);
                closedFaces.addAll(touching);
                if (!classifier.test(newGeom, touching)) continue;
                int adjCount = 0;
                for (Face eface : edge.faces) {
                    if (!touching.contains(eface)) continue;
                    ++adjCount;
                }
                if (adjCount > 1) {
                    throw new Exception(String.format(Intl.intl("Boundary does not completely enclose a region in room %s."), this.getName()));
                }
                for (Face touchingFace : touching) {
                    touchingFace.addGroup(newId);
                }
            }
        }
        if (newGeom.getGroup((int)newId, (boolean)true, (boolean)false, (boolean)false).faces.isEmpty()) {
            return -1;
        }
        for (Edge edge : newEdges) {
            edge.removeGroups(new int[]{tempEdgeId});
        }
        this.setGeom(new EgressModelGeom(newGeom));
        return newId;
    }

    private static Set<Face> findTouchingFaces(Face seed, int boundaryId) {
        LinkedIdentityHashSet<Face> closed = new LinkedIdentityHashSet<Face>();
        ArrayDeque<Face> open = new ArrayDeque<Face>();
        open.addLast(seed);
        closed.add(seed);
        while (!open.isEmpty()) {
            Face face = (Face)open.pollLast();
            for (FaceLoop loop : face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (eu.edge.partOfGroup(boundaryId)) continue;
                    for (Face adjFace : eu.edge.faces) {
                        if (!closed.add(adjFace)) continue;
                        open.addLast(adjFace);
                    }
                }
            }
        }
        return closed;
    }

    @Override
    protected <T extends IMerlinObj> void addChild(T child) {
        if (child instanceof EgressBlockage) {
            ((EgressBlockage)child).setRoom(this);
        }
        super.addChild(child);
    }

    @Override
    protected <T extends IMerlinObj> void removeChild(T child) {
        if (child instanceof EgressBlockage) {
            ((EgressBlockage)child).setRoom(null);
        }
        super.removeChild(child);
    }

    public boolean addBlockage(EgressBlockage blockage) {
        if (this.d_blockages.containsKey(blockage.getFaceId())) {
            return false;
        }
        this.d_blockages.put(blockage.getFaceId(), blockage);
        this.addChild(blockage);
        this.changedEvt(false);
        return true;
    }

    public boolean removeBlockage(EgressBlockage blockage, boolean removeBlockageMarkings) {
        int fid = blockage.getFaceId();
        if (this.d_blockages.remove(fid) == null) {
            return false;
        }
        this.pauseUpdates();
        if (removeBlockageMarkings) {
            EgressRoom.removeMarkings(this.d_geometry, fid);
            Model newGeom = this.cleanup(this.d_geometry);
            if (newGeom != this.d_geometry) {
                this.setGeom(new EgressModelGeom(newGeom));
            }
        }
        this.removeChild(blockage);
        this.changedEvt(false);
        this.resumeUpdates();
        return true;
    }

    private static void removeMarkings(Model model, int ... markings) {
        for (Face face : model.getFaces()) {
            face.removeGroups(markings);
        }
    }

    public Collection<EgressBlockage> getBlockages() {
        return this.d_blockages.values();
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return this.getBlockages();
    }

    public IMaterial getMaterial() {
        return this.d_material;
    }

    public void setMaterial(IMaterial material) {
        if (Objects.equals(this.d_material, material)) {
            return;
        }
        this.d_material = material;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        if (MerlinUtil.test(options, 1)) {
            return PROP_TYPES;
        }
        Set<Object> propTypes = Composite.getPropTypes(options, this.d_blockages.values());
        propTypes = new LinkedHashSet<Object>(propTypes);
        propTypes.addAll(this.getPropTypes(1));
        return propTypes;
    }

    @Override
    public Object getProperty(Object property) {
        if (!this.getPropTypes(1).contains(property)) {
            return Composite.getProperty(property, this.d_blockages.values());
        }
        if (property == AREA) {
            return this.getArea();
        }
        if (property == OCC_COUNT) {
            return this.getOccupants().size();
        }
        if (property == SPEED_MODIFIER) {
            return this.getSpeedModifier();
        }
        if (property == TAGS) {
            return this.getTags();
        }
        if (property == PROP_CAPACITY) {
            return this.getCapacity();
        }
        if (property == PROP_CAPACITY_ENABLED) {
            return this.getCapacityEnabled();
        }
        if (property == MerlinData.MATERIAL) {
            return new IMaterial[]{this.getMaterial()};
        }
        return super.getProperty(property);
    }

    public void setProperty(Object property, Object value) {
        if (!this.getPropTypes(1).contains(property)) {
            Composite.setProperty(property, value, this.d_blockages.values());
        } else if (property == SPEED_MODIFIER) {
            this.setSpeedModifier((SpeedModifier)value);
        } else if (property == TAGS) {
            this.setTags((Set)value);
        } else if (property == PROP_CAPACITY) {
            this.setCapacity((IOccCount)value);
        } else if (property == PROP_CAPACITY_ENABLED) {
            this.setCapacityEnabled((Boolean)value);
        } else if (property == MerlinData.MATERIAL) {
            this.setMaterial(((IMaterial[])value)[0]);
        } else {
            super.setProperty(property, value);
        }
    }

    @Override
    public IOccCount getCapacity() {
        return this.d_capacity;
    }

    @Override
    public void setCapacity(IOccCount capacity) {
        if (this.d_capacity != capacity) {
            this.d_capacity = capacity;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public boolean getCapacityEnabled() {
        return this.d_capacityEnabled;
    }

    @Override
    public void setCapacityEnabled(boolean capacityEnabled) {
        if (this.d_capacityEnabled != capacityEnabled) {
            this.d_capacityEnabled = capacityEnabled;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public Collection<AMerlinObj> getConnObjectsForEnable(MerlinData md) {
        ArrayList<AMerlinObj> connObjects = new ArrayList<AMerlinObj>();
        connObjects.addAll(this.getOccupants());
        for (IEgressObj iEgressObj : this.getConnections()) {
            if (iEgressObj instanceof IEgressComp) {
                connObjects.add((AEgressComp)iEgressObj);
            }
            if (!(iEgressObj instanceof EgressCorridor) && !(iEgressObj instanceof EgressDoor)) continue;
            connObjects.addAll(((AEgressComp)iEgressObj).getConnObjectsForEnable(md));
        }
        ArrayList allReferences = new ArrayList();
        Dependencies.getObjReferences(md, o -> o == this, (source, target) -> allReferences.add((AMerlinObj)source));
        IFilteredCollection<OccSourceObj> iFilteredCollection = theUtil.filter(allReferences, OccSourceObj.class);
        connObjects.addAll(iFilteredCollection);
        return connObjects;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.d_material);
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        if (old == this.d_material) {
            this.setMaterial((IMaterial)replacement);
        }
    }

    static {
        s_identity.setIdentity();
        newSet = type -> new LinkedIdentityHashSet();
    }

    public static interface IFaceClassifier {
        public boolean test(Model var1, Collection<Face> var2);
    }
}

